/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class RootSystemGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MAX_ROOT_COLUMN_HEIGHT = ConfigurationProperty.integer("max_root_column_height");
    public static final ConfigurationProperty<Integer> ROOT_RADIUS = ConfigurationProperty.integer("root_radius");
    public static final ConfigurationProperty<ResourceLocation> ROOT_REPLACEABLE_TAG = ConfigurationProperty.property("root_replaceable_tag", ResourceLocation.class);
    public static final ConfigurationProperty<Integer> ROOT_PLACEMENT_ATTEMPTS = ConfigurationProperty.integer("root_replacement_attempts");
    public static final ConfigurationProperty<Block> ROOT_BLOCK = ConfigurationProperty.block("root_block");
    public static final ConfigurationProperty<Integer> HANGING_ROOT_RADIUS = ConfigurationProperty.integer("hanging_root_radius");
    public static final ConfigurationProperty<Integer> HANGING_ROOT_VERTICAL_SPAN = ConfigurationProperty.integer("hanging_root_vertical_span");
    public static final ConfigurationProperty<Integer> HANGING_ROOT_PLACEMENT_ATTEMPTS = ConfigurationProperty.integer("hanging_root_replacement_attempts");
    public static final ConfigurationProperty<Block> HANGING_ROOT_BLOCK = ConfigurationProperty.block("hanging_root_block");

    public RootSystemGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MAX_ROOT_COLUMN_HEIGHT, ROOT_RADIUS, ROOT_REPLACEABLE_TAG, ROOT_PLACEMENT_ATTEMPTS, ROOT_BLOCK, HANGING_ROOT_RADIUS, HANGING_ROOT_VERTICAL_SPAN, HANGING_ROOT_PLACEMENT_ATTEMPTS, HANGING_ROOT_BLOCK);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MAX_ROOT_COLUMN_HEIGHT, 100)).with(ROOT_RADIUS, 3)).with(ROOT_REPLACEABLE_TAG, BlockTags.f_198159_.f_203868_())).with(ROOT_BLOCK, Blocks.f_152549_)).with(ROOT_PLACEMENT_ATTEMPTS, 20)).with(HANGING_ROOT_RADIUS, 3)).with(HANGING_ROOT_VERTICAL_SPAN, 2)).with(HANGING_ROOT_BLOCK, Blocks.f_152548_)).with(HANGING_ROOT_PLACEMENT_ATTEMPTS, 20);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.isWorldGen()) {
            return true;
        }
        BlockPos.MutableBlockPos pos = context.originPos().m_122032_();
        BlockPos rootPos = context.pos();
        for (int y = pos.m_123342_(); y < rootPos.m_123342_(); ++y) {
            RootSystemGenFeature.placeRootedDirt(context.level(), configuration, context.random(), rootPos.m_123341_(), rootPos.m_123343_(), pos);
            pos.m_122173_(Direction.UP);
        }
        RootSystemGenFeature.placeHangingRoots(context.level(), configuration, context.random(), context.originPos(), pos);
        return true;
    }

    private static void placeRootedDirt(LevelAccessor level, GenFeatureConfiguration configuration, RandomSource random, int x, int z, BlockPos.MutableBlockPos pos) {
        int radius = configuration.get(ROOT_RADIUS);
        TagKey rootReplaceableTag = BlockTags.create((ResourceLocation)configuration.get(ROOT_REPLACEABLE_TAG));
        Predicate<BlockState> stateReplaceable = state -> state.m_204336_(rootReplaceableTag);
        for (int i = 0; i < configuration.get(ROOT_PLACEMENT_ATTEMPTS); ++i) {
            pos.m_122154_((Vec3i)pos, random.m_188503_(radius) - random.m_188503_(radius), 0, random.m_188503_(radius) - random.m_188503_(radius));
            BlockState state2 = level.m_8055_((BlockPos)pos);
            if (stateReplaceable.test(state2)) {
                level.m_7731_((BlockPos)pos, configuration.get(ROOT_BLOCK).m_49966_(), 2);
            }
            pos.m_142451_(x);
            pos.m_142443_(z);
        }
    }

    private static void placeHangingRoots(LevelAccessor level, GenFeatureConfiguration configuration, RandomSource random, BlockPos originPos, BlockPos.MutableBlockPos pos) {
        int radius = configuration.get(HANGING_ROOT_RADIUS);
        int verticalSpan = configuration.get(HANGING_ROOT_VERTICAL_SPAN);
        for (int k = 0; k < configuration.get(HANGING_ROOT_PLACEMENT_ATTEMPTS); ++k) {
            BlockState state;
            pos.m_122154_((Vec3i)originPos, random.m_188503_(radius) - random.m_188503_(radius), random.m_188503_(verticalSpan) - random.m_188503_(verticalSpan), random.m_188503_(radius) - random.m_188503_(radius));
            if (!level.m_46859_((BlockPos)pos) || !(state = configuration.get(HANGING_ROOT_BLOCK).m_49966_()).m_60710_((LevelReader)level, (BlockPos)pos) || !level.m_8055_(pos.m_7494_()).m_60783_((BlockGetter)level, (BlockPos)pos, Direction.DOWN)) continue;
            level.m_7731_((BlockPos)pos, state, 2);
        }
    }
}

