/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources.loader;

import com.ferreusveritas.dynamictrees.api.applier.ApplierRegistryEvent;
import com.ferreusveritas.dynamictrees.api.applier.PropertyApplierResult;
import com.ferreusveritas.dynamictrees.api.resource.ResourceAccessor;
import com.ferreusveritas.dynamictrees.api.resource.loading.AbstractResourceLoader;
import com.ferreusveritas.dynamictrees.api.resource.loading.ApplierResourceLoader;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.MultiJsonResourcePreparer;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.JsonPropertyAppliers;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.resources.loader.BiomePopulatorsResourceLoader;
import com.ferreusveritas.dynamictrees.util.IgnoreThrowable;
import com.ferreusveritas.dynamictrees.util.JsonMapWrapper;
import com.ferreusveritas.dynamictrees.util.holderset.DTBiomeHolderSet;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabase;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.ferreusveritas.dynamictrees.worldgen.FeatureCancellationRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Deque;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.levelgen.GenerationStep;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeatureCancellationResourceLoader
extends AbstractResourceLoader<Iterable<JsonElement>>
implements ApplierResourceLoader<Iterable<JsonElement>> {
    private static final MultiJsonResourcePreparer RESOURCE_PREPARER = new MultiJsonResourcePreparer("world_gen");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CANCELLATION_FILE = "feature_cancellers";
    public static final String CANCELLATION_APPLIERS = "cancellations";
    public static final String CANCELLERS = "cancellers";
    private final JsonPropertyAppliers<BiomePropertySelectors.FeatureCancellation> cancellationAppliers = new JsonPropertyAppliers<BiomePropertySelectors.FeatureCancellation>(BiomePropertySelectors.FeatureCancellation.class);

    static boolean isCancellationFile(ResourceLocation key) {
        return key.m_135815_().equals(CANCELLATION_FILE);
    }

    public FeatureCancellationResourceLoader() {
        super(RESOURCE_PREPARER);
    }

    @Override
    public void registerAppliers() {
        ((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)this.cancellationAppliers.register("namespace", (Class)String.class, BiomePropertySelectors.FeatureCancellation::cancelWithNamespace)).registerArrayApplier("namespaces", (Class)String.class, BiomePropertySelectors.FeatureCancellation::cancelWithNamespace)).register("type", (Class)FeatureCanceller.class, BiomePropertySelectors.FeatureCancellation::cancelUsing)).registerArrayApplier("types", (Class)FeatureCanceller.class, BiomePropertySelectors.FeatureCancellation::cancelUsing)).register("stage", (Class)GenerationStep.Decoration.class, BiomePropertySelectors.FeatureCancellation::cancelDuring)).registerArrayApplier("stages", (Class)GenerationStep.Decoration.class, BiomePropertySelectors.FeatureCancellation::cancelDuring);
        ApplierResourceLoader.postApplierEvent(new CancellationApplierRegistryEvent<BiomePropertySelectors.FeatureCancellation>(this.cancellationAppliers, CANCELLATION_APPLIERS));
    }

    @Override
    public void applyOnReload(ResourceAccessor<Iterable<JsonElement>> resourceAccessor, ResourceManager resourceManager) {
        BiomeDatabases.reset();
        this.readCancellers(resourceAccessor.filtered(FeatureCancellationResourceLoader::isCancellationFile).map(BiomePopulatorsResourceLoader::toLinkedList));
    }

    private void readCancellers(ResourceAccessor<Deque<JsonElement>> defaultPopulators) {
        this.readModCancellers(defaultPopulators);
        this.readTreePackCancellers(defaultPopulators);
    }

    private void readModCancellers(ResourceAccessor<Deque<JsonElement>> defaultPopulators) {
        defaultPopulators.getAllResources().forEach(defaultPopulator -> this.readCancellers(defaultPopulator.getLocation(), (JsonElement)((Deque)defaultPopulator.getResource()).pollFirst()));
    }

    private void readTreePackCancellers(ResourceAccessor<Deque<JsonElement>> defaultPopulators) {
        defaultPopulators.getAllResources().forEach(defaultPopulator -> ((Deque)defaultPopulator.getResource()).forEach(json -> this.readCancellers(defaultPopulator.getLocation(), (JsonElement)json)));
    }

    private void readCancellers(ResourceLocation location, JsonElement json) {
        LOGGER.debug("Reading cancellers from Json biome populator \"{}\".", (Object)location);
        try {
            JsonResult.forInput(json).mapEachIfArray(JsonObject.class, object -> {
                try {
                    this.readCancellersInSection(location, (JsonObject)object);
                }
                catch (IgnoreThrowable ignoreThrowable) {
                    // empty catch block
                }
                return PropertyApplierResult.success();
            }).forEachWarning(warning -> LOGGER.warn("Warning whilst loading cancellers from populator \"{}\": {}", (Object)location, warning)).orElseThrow();
        }
        catch (DeserialisationException e) {
            LOGGER.error("Error whilst loading cancellers from populator \"{}\": {}", (Object)location, (Object)e.getMessage());
        }
    }

    private void readCancellersInSection(ResourceLocation location, JsonObject json) throws DeserialisationException, IgnoreThrowable {
        Consumer<String> errorConsumer = error -> LOGGER.error("Error loading populator \"{}\": {}", (Object)location, error);
        Consumer<String> warningConsumer = warning -> LOGGER.warn("Warning whilst loading populator \"{}\": {}", (Object)location, warning);
        JsonHelper.throwIfShouldNotLoad(json);
        if (!json.has(CANCELLERS)) {
            return;
        }
        DTBiomeHolderSet biomes = BiomePopulatorsResourceLoader.collectBiomes(json, warningConsumer);
        JsonResult.forInput((JsonElement)json).mapIfContains(CANCELLERS, JsonObject.class, cancellerObject -> this.applyCanceller(location, errorConsumer, warningConsumer, biomes, (JsonObject)cancellerObject), PropertyApplierResult.success()).forEachWarning(warningConsumer).orElseThrow();
    }

    private PropertyApplierResult applyCanceller(ResourceLocation location, Consumer<String> errorConsumer, Consumer<String> warningConsumer, DTBiomeHolderSet biomes, JsonObject json) {
        BiomePropertySelectors.NormalFeatureCancellation cancellation = new BiomePropertySelectors.NormalFeatureCancellation();
        this.applyCancellationAppliers(location, json, cancellation);
        cancellation.cancelDuringDefaultIfNoneSpecified();
        BiomeDatabase.Operation operation = JsonResult.forInput((JsonElement)json).mapIfContains("method", BiomeDatabase.Operation.class, op -> op, BiomeDatabase.Operation.SPLICE_AFTER).forEachWarning(warningConsumer).orElse(BiomeDatabase.Operation.SPLICE_AFTER, errorConsumer, warningConsumer);
        FeatureCancellationRegistry.addCancellations(biomes, operation, cancellation);
        return PropertyApplierResult.success();
    }

    private void applyCancellationAppliers(ResourceLocation location, JsonObject json, BiomePropertySelectors.FeatureCancellation cancellation) {
        this.cancellationAppliers.applyAll(new JsonMapWrapper(json), cancellation).forEachErrorWarning(error -> LOGGER.error("Error whilst applying feature cancellations in \"{}\" populator: {}", (Object)location, error), warning -> LOGGER.warn("Warning whilst applying feature cancellations in \"{}\" populator: {}", (Object)location, warning));
    }

    public static final class CancellationApplierRegistryEvent<O>
    extends ApplierRegistryEvent<O, JsonElement> {
        public CancellationApplierRegistryEvent(JsonPropertyAppliers<O> appliers, String identifier) {
            super(appliers, identifier);
        }
    }
}

