/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.item;

import com.ferreusveritas.dynamictrees.block.PottedSaplingBlock;
import com.ferreusveritas.dynamictrees.event.SeedVoluntaryPlantEvent;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.LazyValue;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.JoCodeRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class Seed
extends Item
implements IPlantable {
    private static final LazyValue<RandomSource> BACKUP_RANDOM = LazyValue.supplied(RandomSource::m_216327_);
    public static final String FORCE_PLANT_KEY = "ForcePlant";
    public static final String LIFESPAN_KEY = "Lifespan";
    public static final String CODE_KEY = "Code";
    private final Species species;

    public Seed() {
        super(new Item.Properties());
        this.species = Species.NULL_SPECIES;
    }

    public Seed(Species species) {
        this(species, new Item.Properties());
    }

    public Seed(Species species, Item.Properties properties) {
        super(properties);
        this.species = species;
        DTRegistries.CREATIVE_TAB_ITEMS.add(this);
    }

    public Species getSpecies() {
        return this.species;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        if (entityItem.lifespan == 6000) {
            entityItem.lifespan = this.getTimeToLive(entityItem.m_32055_()) + 20;
            if (entityItem.lifespan == 6000) {
                entityItem.lifespan = 6001;
            }
        }
        if (entityItem.f_19797_ >= entityItem.lifespan - 20) {
            Level level = entityItem.m_9236_();
            if (!level.f_46443_) {
                ItemStack seedStack = entityItem.m_32055_();
                BlockPos pos = new BlockPos((Vec3i)entityItem.m_20183_());
                SeedVoluntaryPlantEvent seedVolEvent = new SeedVoluntaryPlantEvent(entityItem, this.getSpecies().selfOrLocationOverride((BlockGetter)level, pos), pos, this.shouldPlant(level, pos, seedStack));
                MinecraftForge.EVENT_BUS.post((Event)seedVolEvent);
                if (!seedVolEvent.isCanceled() && seedVolEvent.getWillPlant()) {
                    this.doPlanting(level, pos, null, seedStack);
                }
                seedStack.m_41764_(0);
            }
            entityItem.m_6074_();
        }
        return false;
    }

    public boolean doPlanting(Level level, BlockPos pos, @Nullable Player planter, ItemStack seedStack) {
        Species species = this.getSpecies().selfOrLocationOverride((BlockGetter)level, pos);
        if (species.plantSapling((LevelAccessor)level, pos, this.getSpecies() != species)) {
            String joCode = this.getCode(seedStack, level.f_46441_);
            if (!joCode.isEmpty()) {
                level.m_7471_(pos, false);
                BlockPos rootPos = pos.m_7495_();
                GenerationContext context = new GenerationContext(LevelContext.create((LevelAccessor)level), species, rootPos, rootPos.m_122032_(), (Holder<Biome>)level.m_204166_(pos), planter != null ? planter.m_6350_() : Direction.NORTH, 8, SafeChunkBounds.ANY);
                species.getJoCode(joCode).setCareful(true).generate(context);
            }
            return true;
        }
        return false;
    }

    public boolean shouldPlant(Level level, BlockPos pos, ItemStack seedStack) {
        if (this.hasForcePlant(seedStack)) {
            return true;
        }
        if (!level.m_46861_(pos)) {
            return false;
        }
        float plantChance = (float)((double)this.getSpecies().biomeSuitability(level, pos) * (Double)DTConfigs.SEED_PLANT_RATE.get());
        if (((Boolean)DTConfigs.SEED_ONLY_FOREST.get()).booleanValue()) {
            plantChance *= BiomeDatabases.getDimensionalOrDefault(level.m_46472_().m_135782_()).getForestness((Holder<Biome>)level.m_204166_(pos));
        }
        float accum = 1.0f;
        int count = seedStack.m_41613_();
        while (count-- > 0) {
            accum *= 1.0f - plantChance;
        }
        plantChance = 1.0f - accum;
        return plantChance > level.f_46441_.m_188501_();
    }

    public boolean hasForcePlant(ItemStack seedStack) {
        boolean forcePlant = false;
        if (seedStack.m_41782_()) {
            CompoundTag nbtData = seedStack.m_41783_();
            assert (nbtData != null);
            forcePlant = nbtData.m_128471_(FORCE_PLANT_KEY);
        }
        return forcePlant;
    }

    public int getTimeToLive(ItemStack seedStack) {
        int lifespan = (Integer)DTConfigs.SEED_TIME_TO_LIVE.get();
        if (seedStack.m_41782_()) {
            CompoundTag nbtData = seedStack.m_41783_();
            assert (nbtData != null);
            if (nbtData.m_128441_(LIFESPAN_KEY)) {
                lifespan = nbtData.m_128451_(LIFESPAN_KEY);
            }
        }
        return lifespan;
    }

    public String getCode(ItemStack seedStack, RandomSource random) {
        String joCode = "";
        if (seedStack.m_41782_()) {
            CompoundTag tag = seedStack.m_41783_();
            assert (tag != null);
            if (tag.m_128441_(CODE_KEY)) {
                JoCode code;
                if (tag.m_128435_(CODE_KEY) == 8) {
                    joCode = tag.m_128461_(CODE_KEY);
                } else if (tag.m_128435_(CODE_KEY) == 3 && (code = this.getJoCodeForRadius(random, tag.m_128451_(CODE_KEY))) != null) {
                    joCode = code.toString();
                }
            }
        }
        return joCode;
    }

    @Nullable
    private JoCode getJoCodeForRadius(RandomSource random, int radius) {
        return JoCodeRegistry.getRandomCode(this.species.getRegistryName(), Mth.m_14045_((int)radius, (int)2, (int)8), random);
    }

    public InteractionResult onItemUseFlowerPot(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState emptyPotState = level.m_8055_(pos = context.m_8083_());
        Block emptyPotBlock = emptyPotState.m_60734_();
        if (!(emptyPotBlock instanceof FlowerPotBlock) || emptyPotState != emptyPotBlock.m_49966_() || ((FlowerPotBlock)emptyPotBlock).m_53560_() != Blocks.f_50016_) {
            return InteractionResult.PASS;
        }
        PottedSaplingBlock pottingSapling = this.getSpecies().getPottedSapling();
        level.m_46597_(pos, pottingSapling.m_49966_());
        if (pottingSapling.setSpecies(level, pos, pottingSapling.m_49966_(), this.getSpecies()) && pottingSapling.setPotState(level, emptyPotState, pos)) {
            Player player = context.m_43723_();
            if (player != null) {
                context.m_43723_().m_36220_(Stats.f_12961_);
                if (!context.m_43723_().m_150110_().f_35937_) {
                    context.m_43722_().m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUsePlantSeed(UseOnContext context, boolean onFluid) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        BlockPos pos = context.m_8083_().m_6630_(onFluid ? 1 : 0);
        Direction facing = context.m_43719_();
        if (state.m_247087_()) {
            pos = pos.m_7495_();
            facing = Direction.UP;
        }
        if (facing == Direction.UP && context.m_43723_() != null && context.m_43723_().m_36204_(pos, facing, context.m_43722_()) && context.m_43723_().m_36204_(pos.m_7494_(), facing, context.m_43722_()) && this.doPlanting(context.m_43725_(), pos.m_7494_(), context.m_43723_(), context.m_43722_())) {
            context.m_43722_().m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (this.onItemUseFlowerPot(context) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().m_6425_(context.m_8083_().m_7494_()).m_76178_() && this.onItemUsePlantSeed(context, false) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        BlockHitResult blockhitresult = Seed.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos fluidPos = blockhitresult.m_82425_();
        if (this.getSpecies().selfOrLocationOverride((BlockGetter)level, fluidPos).isPlantableOnFluid()) {
            ItemStack itemstack = player.m_21120_(pHand);
            if (blockhitresult.m_6662_() == HitResult.Type.BLOCK && !level.m_6425_(fluidPos).m_76178_() && level.m_6425_(fluidPos.m_7495_()).m_76178_() && this.onItemUsePlantSeed(new UseOnContext(player, pHand, blockhitresult), true) == InteractionResult.SUCCESS) {
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        return super.m_7203_(level, player, pHand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (stack.m_41782_()) {
            String joCode = this.getCode(stack, level == null ? BACKUP_RANDOM.get() : level.f_46441_);
            if (!joCode.isEmpty()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.dynamictrees.jo_code", (Object[])new Object[]{new JoCode(joCode).getTextComponent()}));
            }
            if (this.hasForcePlant(stack)) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.dynamictrees.force_planting", (Object[])new Object[]{Component.m_237115_((String)"tooltip.dynamictrees.enabled").m_130938_(style -> style.m_131140_(ChatFormatting.DARK_AQUA))}));
            }
            CompoundTag nbtData = stack.m_41783_();
            assert (nbtData != null);
            if (nbtData.m_128441_(LIFESPAN_KEY)) {
                tooltip.add((Component)Component.m_237115_((String)("tooltip.dynamictrees.seed_life_span" + String.valueOf(Component.m_237113_((String)String.valueOf(nbtData.m_128451_(LIFESPAN_KEY))).m_130938_(style -> style.m_131140_(ChatFormatting.DARK_AQUA))))));
            }
        }
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        return this.getSpecies().getSapling().map(Block::m_49966_).orElse(Blocks.f_50016_.m_49966_());
    }
}

