/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event.handler;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.block.DynamicSaplingBlock;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VanillaSaplingEventHandler {
    @SubscribeEvent
    public void onPlayerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Level level;
        Block block;
        block6: {
            block5: {
                block = event.getPlacedBlock().m_60734_();
                LevelAccessor levelAccessor = event.getLevel();
                if (!(levelAccessor instanceof Level)) break block5;
                level = (Level)levelAccessor;
                if (TreeRegistry.SAPLING_REPLACERS.containsKey(block)) break block6;
            }
            return;
        }
        if (event.getBlockSnapshot().getReplacedBlock().m_60734_() == event.getBlockSnapshot().getCurrentBlock().m_60734_()) {
            return;
        }
        BlockPos pos = event.getPos();
        Species targetSpecies = TreeRegistry.SAPLING_REPLACERS.get(block);
        Species species = targetSpecies.selfOrLocationOverride((BlockGetter)level, pos);
        level.m_7471_(pos, false);
        if (!species.plantSapling((LevelAccessor)level, pos, targetSpecies != species)) {
            ItemUtils.spawnItemStack(level, pos, species.getSeedStack(1));
        }
    }

    @SubscribeEvent
    public void onSaplingGrowTree(SaplingGrowTreeEvent event) {
        Level level;
        Block block;
        BlockPos pos;
        block5: {
            block4: {
                LevelAccessor levelAccess = event.getLevel();
                pos = event.getPos();
                block = levelAccess.m_8055_(pos).m_60734_();
                if (!(levelAccess instanceof Level)) break block4;
                level = (Level)levelAccess;
                if (TreeRegistry.SAPLING_REPLACERS.containsKey(block)) break block5;
            }
            return;
        }
        Species species = TreeRegistry.SAPLING_REPLACERS.get(block).selfOrLocationOverride((BlockGetter)level, pos);
        level.m_7471_(pos, false);
        event.setResult(Event.Result.DENY);
        if (species.isValid() && DynamicSaplingBlock.canSaplingStay((LevelReader)level, species, pos)) {
            species.transitionToTree(level, pos);
        }
    }
}

