/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.registries.IForgeRegistry;

public final class ForgeRegistryEntryDeserialiser<T>
implements JsonDeserialiser<T> {
    private final IForgeRegistry<T> registry;
    private final String registryDisplayName;
    @Nullable
    private final T nullValue;
    private final Predicate<T> validator;

    public ForgeRegistryEntryDeserialiser(IForgeRegistry<T> registry, String registryDisplayName) {
        this(registry, registryDisplayName, null);
    }

    public ForgeRegistryEntryDeserialiser(IForgeRegistry<T> registry, String registryDisplayName, @Nullable T nullValue) {
        this.registry = registry;
        this.registryDisplayName = registryDisplayName;
        this.nullValue = nullValue;
        this.validator = value -> value != nullValue;
    }

    @Override
    public Result<T, JsonElement> deserialise(JsonElement jsonElement) {
        AtomicBoolean intentionallyNull = new AtomicBoolean();
        return JsonDeserialisers.RESOURCE_LOCATION.deserialise(jsonElement).map(registryName -> {
            if (this.nullValue != null && Objects.equals(registryName, this.registry.getKey(this.nullValue))) {
                intentionallyNull.set(true);
                return this.nullValue;
            }
            return this.registry.getValue(registryName);
        }, value -> intentionallyNull.get() || this.validator.test(value), "Could not find " + this.registryDisplayName + " for registry name '{}'.");
    }
}

