/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat.season;

import com.ferreusveritas.dynamictrees.compat.CompatHandler;
import com.ferreusveritas.dynamictrees.compat.season.ActiveSeasonGrowthCalculator;
import com.ferreusveritas.dynamictrees.compat.season.NormalSeasonManager;
import com.ferreusveritas.dynamictrees.compat.season.NullSeasonGrowthCalculator;
import com.ferreusveritas.dynamictrees.compat.season.NullSeasonProvider;
import com.ferreusveritas.dynamictrees.compat.season.SeasonProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonHooks;

public class SereneSeasonsSeasonProvider
implements SeasonProvider {
    private float seasonValue = 1.0f;

    @Override
    public Float getSeasonValue(Level level, BlockPos pos) {
        return Float.valueOf(this.seasonValue);
    }

    @Override
    public void updateTick(Level level, long dayTime) {
        this.seasonValue = ((float)SeasonHelper.getSeasonState((Level)level).getSubSeason().ordinal() + 0.5f) / (float)Season.SubSeason.VALUES.length * 4.0f;
    }

    @Override
    public boolean shouldSnowMelt(Level level, BlockPos pos) {
        if (ModConfig.seasons.generateSnowAndIce && this.seasonValue < 3.0f) {
            Holder biomeHolder = level.m_204166_(pos);
            return SeasonHooks.getBiomeTemperature((Level)level, (Holder)biomeHolder, (BlockPos)pos) >= 0.15f;
        }
        return false;
    }

    public static void registerSereneSeasonsProvider() {
        CompatHandler.registerSeasonManager("sereneseasons", () -> {
            NormalSeasonManager seasonManager = new NormalSeasonManager(world -> ModConfig.seasons.isDimensionWhitelisted(world.m_46472_()) ? new Tuple((Object)new SereneSeasonsSeasonProvider(), (Object)new ActiveSeasonGrowthCalculator()) : new Tuple((Object)new NullSeasonProvider(), (Object)new NullSeasonGrowthCalculator()));
            seasonManager.setTropicalPredicate((world, pos) -> SeasonHelper.usesTropicalSeasons((Holder)world.m_204166_(pos)));
            return seasonManager;
        });
    }
}

