/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.cell;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.cell.CellSolver;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.cell.AcaciaLeafCell;
import com.ferreusveritas.dynamictrees.cell.ConiferBranchCell;
import com.ferreusveritas.dynamictrees.cell.ConiferLeafCell;
import com.ferreusveritas.dynamictrees.cell.ConiferTopBranchCell;
import com.ferreusveritas.dynamictrees.cell.DarkOakLeafCell;
import com.ferreusveritas.dynamictrees.cell.LeafClusters;
import com.ferreusveritas.dynamictrees.cell.NetherFungusLeafCell;
import com.ferreusveritas.dynamictrees.cell.NormalCell;
import com.ferreusveritas.dynamictrees.cell.PalmFrondCell;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.core.Direction;

public class CellKits {
    public static final CellKit DECIDUOUS = new CellKit(DynamicTrees.location("deciduous")){
        private final Cell[] normalCells = new Cell[]{CellNull.NULL_CELL, new NormalCell(1), new NormalCell(2), new NormalCell(3), new NormalCell(4), new NormalCell(5), new NormalCell(6), new NormalCell(7)};
        private final Cell branchCell = new NormalCell(5);
        private final BasicSolver deciduousSolver = new BasicSolver(new short[]{1300, 1059, 802, 1041, 785, 529});

        @Override
        public Cell getCellForLeaves(int hydro) {
            return this.normalCells[hydro];
        }

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.branchCell : CellNull.NULL_CELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.DECIDUOUS;
        }

        @Override
        public CellSolver getCellSolver() {
            return this.deciduousSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit CONIFER = new CellKit(DynamicTrees.location("conifer")){
        private final Cell coniferBranch = new ConiferBranchCell();
        private final Cell coniferTopBranch = new ConiferTopBranchCell();
        private final Cell[] coniferLeafCells = new Cell[]{CellNull.NULL_CELL, new ConiferLeafCell(1), new ConiferLeafCell(2), new ConiferLeafCell(3), new ConiferLeafCell(4), new ConiferLeafCell(5), new ConiferLeafCell(6), new ConiferLeafCell(7)};
        private final BasicSolver coniferSolver = new BasicSolver(new short[]{1300, 1043, 786, 529});

        @Override
        public Cell getCellForLeaves(int hydro) {
            return this.coniferLeafCells[hydro];
        }

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.coniferTopBranch;
            }
            if (radius == 1) {
                return this.coniferBranch;
            }
            return CellNull.NULL_CELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.CONIFER;
        }

        @Override
        public CellSolver getCellSolver() {
            return this.coniferSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit ACACIA = new CellKit(DynamicTrees.location("acacia")){
        private final Cell acaciaBranch = new Cell(){
            final int[] map = new int[]{0, 3, 5, 5, 5, 5};

            @Override
            public int getValue() {
                return 5;
            }

            @Override
            public int getValueFromSide(Direction side) {
                return this.map[side.ordinal()];
            }
        };
        private final Cell[] acaciaLeafCells = new Cell[]{CellNull.NULL_CELL, new AcaciaLeafCell(1), new AcaciaLeafCell(2), new AcaciaLeafCell(3), new AcaciaLeafCell(4), new AcaciaLeafCell(5), new AcaciaLeafCell(6), new AcaciaLeafCell(7)};
        private final BasicSolver acaciaSolver = new BasicSolver(new short[]{1300, 1059, 1042, 786, 529});

        @Override
        public Cell getCellForLeaves(int hydro) {
            return this.acaciaLeafCells[hydro];
        }

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.acaciaBranch : CellNull.NULL_CELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.ACACIA;
        }

        @Override
        public CellSolver getCellSolver() {
            return this.acaciaSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit DARK_OAK = new CellKit(DynamicTrees.location("dark_oak")){
        private final Cell branchCell = new NormalCell(5);
        private final Cell[] darkOakLeafCells = new Cell[]{CellNull.NULL_CELL, new DarkOakLeafCell(1), new DarkOakLeafCell(2), new DarkOakLeafCell(3), new DarkOakLeafCell(4), new DarkOakLeafCell(5), new DarkOakLeafCell(6), new DarkOakLeafCell(7)};
        private final BasicSolver darkOakSolver = new BasicSolver(new short[]{1300, 1059, 1042, 786, 529});

        @Override
        public Cell getCellForLeaves(int hydro) {
            return this.darkOakLeafCells[hydro];
        }

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.branchCell : CellNull.NULL_CELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.DARK_OAK;
        }

        @Override
        public CellSolver getCellSolver() {
            return this.darkOakSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit BARE = new CellKit(DynamicTrees.location("bare")){
        private final CellSolver solver = new BasicSolver(new short[0]);

        @Override
        public Cell getCellForLeaves(int hydro) {
            return CellNull.NULL_CELL;
        }

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            return CellNull.NULL_CELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.BARE;
        }

        @Override
        public CellSolver getCellSolver() {
            return this.solver;
        }

        @Override
        public int getDefaultHydration() {
            return 0;
        }
    };
    public static final CellKit PALM = new CellKit(DynamicTrees.location("palm")){
        private final Cell palmBranch = new Cell(){

            @Override
            public int getValue() {
                return 5;
            }

            @Override
            public int getValueFromSide(Direction side) {
                return side == Direction.UP ? this.getValue() : 0;
            }
        };
        private final Cell[] palmFrondCells = new Cell[]{CellNull.NULL_CELL, new PalmFrondCell(1), new PalmFrondCell(2), new PalmFrondCell(3), new PalmFrondCell(4), new PalmFrondCell(5), new PalmFrondCell(6), new PalmFrondCell(7)};
        private final BasicSolver palmSolver = new BasicSolver(new short[]{1300, 1043, 786, 545});

        @Override
        public Cell getCellForLeaves(int hydro) {
            return this.palmFrondCells[hydro];
        }

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            return this.palmBranch;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.PALM;
        }

        @Override
        public CellSolver getCellSolver() {
            return this.palmSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit NETHER_FUNGUS = new CellKit(DynamicTrees.location("nether_fungus")){
        private final Cell[] netherCells = new Cell[]{CellNull.NULL_CELL, new NetherFungusLeafCell(1), new NetherFungusLeafCell(2), new NetherFungusLeafCell(3), new NetherFungusLeafCell(4), new NetherFungusLeafCell(5), new NetherFungusLeafCell(6), new NetherFungusLeafCell(7)};
        private final Cell branchCell = new NormalCell(8);
        private final Cell sideBranchCell = new NormalCell(2);
        private final BasicSolver netherFungusSolver = new BasicSolver(new short[]{2071, 1830, 1589, 1299, 786, 529});

        @Override
        public Cell getCellForLeaves(int hydro) {
            return this.netherCells[hydro];
        }

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            if (radius == 3) {
                return this.branchCell;
            }
            if (radius <= 5) {
                return this.sideBranchCell;
            }
            return CellNull.NULL_CELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.NETHER_FUNGUS;
        }

        @Override
        public CellSolver getCellSolver() {
            return this.netherFungusSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 7;
        }
    };
    public static final CellKit AZALEA = new CellKit(DynamicTrees.location("azalea")){
        private final Cell[] normalCells = new Cell[]{CellNull.NULL_CELL, new NormalCell(1), new NormalCell(2), new NormalCell(3), new NormalCell(4), new NormalCell(5), new NormalCell(6), new NormalCell(7)};
        private final Cell branchCell = new NormalCell(5);
        private final BasicSolver deciduousSolver = new BasicSolver(new short[]{1299, 802, 785, 529});

        @Override
        public Cell getCellForLeaves(int hydro) {
            return this.normalCells[hydro];
        }

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.branchCell : CellNull.NULL_CELL;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.AZALEA;
        }

        @Override
        public CellSolver getCellSolver() {
            return this.deciduousSolver;
        }

        @Override
        public int getDefaultHydration() {
            return 3;
        }
    };

    public static void register(Registry<CellKit> registry) {
        registry.registerAll(new CellKit[]{DECIDUOUS, CONIFER, ACACIA, DARK_OAK, BARE, PALM, NETHER_FUNGUS, AZALEA});
    }

    public static int solveCell(int[] nv, short[] solution) {
        for (short d : solution) {
            if (nv[d >> 8 & 0xF] < (d >> 4 & 0xF)) continue;
            return d & 0xF;
        }
        return 0;
    }

    public static class BasicSolver
    implements CellSolver {
        private final short[] codes;

        public BasicSolver(short[] codes) {
            this.codes = codes;
        }

        @Override
        public int solve(Cell[] cells) {
            int[] nv = new int[16];
            for (Direction dir : Direction.values()) {
                int n = cells[dir.ordinal()].getValueFromSide(dir.m_122424_());
                nv[n] = nv[n] + 1;
            }
            return CellKits.solveCell(nv, this.codes);
        }
    }
}

