/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.registry;

import com.ferreusveritas.dynamictrees.api.registry.AbstractRegistry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class SimpleRegistry<V extends RegistryEntry<V>>
extends AbstractRegistry<V> {
    private final Set<V> entries = new LinkedHashSet<V>();

    public SimpleRegistry(Class<V> type, V nullValue) {
        this(type.getSimpleName(), type, nullValue);
    }

    public SimpleRegistry(String name, Class<V> type, V nullValue) {
        this(name, type, nullValue, false);
    }

    public SimpleRegistry(Class<V> type, V nullValue, boolean clearable) {
        this(type.getSimpleName(), type, nullValue, clearable);
    }

    public SimpleRegistry(String name, Class<V> type, V nullValue, boolean clearable) {
        super(name, type, nullValue, clearable);
        this.register((RegistryEntry)nullValue);
    }

    @Override
    public SimpleRegistry<V> register(V value) {
        this.assertValid(value);
        this.entries.add(value);
        return this;
    }

    @Override
    public final Set<V> getAll() {
        return Collections.unmodifiableSet(this.entries);
    }

    @Override
    protected void clearAll() {
        this.entries.clear();
    }
}

