/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.applier;

import com.ferreusveritas.dynamictrees.api.applier.Applier;
import com.ferreusveritas.dynamictrees.api.applier.PropertyApplier;
import com.ferreusveritas.dynamictrees.api.applier.PropertyApplierResult;
import com.ferreusveritas.dynamictrees.deserialisation.Deserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.util.LazyValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;

public class MapPropertyApplier<T, V, I>
extends PropertyApplier<T, Map<String, V>, I> {
    private final Function<I, JsonObject> jsonObjectDeserializer;
    private final LazyValue<Deserialiser<JsonElement, V>> valueDeserialiser;

    public MapPropertyApplier(String key, Class<T> objectClass, Applier<T, Map<String, V>> applier, Function<I, JsonObject> jsonObjectDeserializer, LazyValue<Deserialiser<JsonElement, V>> valueDeserialiser) {
        super(key, objectClass, applier);
        this.jsonObjectDeserializer = jsonObjectDeserializer;
        this.valueDeserialiser = valueDeserialiser;
    }

    @Override
    @Nullable
    protected PropertyApplierResult applyIfShould(T object, I input, Applier<T, Map<String, V>> applier) {
        HashMap values = new HashMap();
        this.jsonObjectDeserializer.apply(input).entrySet().forEach(entry -> this.valueDeserialiser.get().deserialise((JsonElement)entry.getValue()).ifSuccessOrElse(v -> values.put((String)entry.getKey(), v), error -> LogManager.getLogger().error(error), warning -> LogManager.getLogger().warn(warning)));
        return applier.apply(object, values);
    }

    public static <T, V> MapPropertyApplier<T, V, JsonElement> json(String key, Class<T> objectClass, Class<V> valueClass, Applier<T, Map<String, V>> applier) {
        return new MapPropertyApplier<T, V, JsonElement>(key, objectClass, applier, element -> (JsonObject)JsonDeserialisers.JSON_OBJECT.deserialise(element).get(), LazyValue.supplied(() -> JsonDeserialisers.getOrThrow(valueClass)));
    }
}

