/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class WScroll
implements IWidget {
    public int xPos;
    public int yPos;
    public int ySize;
    public int xSize;
    public float current;
    boolean active = false;
    float step = 0.0f;
    public IWidget.ListenerAction<? super WScroll> listener;
    int height = 17;

    public WScroll(int xPos, int yPos, int ySize) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.ySize = ySize;
    }

    public WScroll(int xPos, int yPos, int xSize, int ySize) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.ySize = ySize;
        this.xSize = xSize;
    }

    @Override
    public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
        int offset = (int)(this.current * (float)(this.ySize - this.height));
        boolean in = this.mouseIn(xMouse, yMouse);
        Resource r = in ? Resource.WGT_SCROLL_F : Resource.WGT_SCROLL_N;
        gui.drawResourceContinuous(Resource.WGT_SLOT, this.xPos, this.yPos, this.xSize, this.ySize, 3, 3, 3, 3);
        gui.drawResourceContinuous(r, this.xPos, this.yPos + offset, this.xSize, this.height, 3);
        return false;
    }

    @Override
    public boolean onMouseDragged(JecaGui gui, int xMouse, int yMouse, int xDrag, int yDrag) {
        if (this.active) {
            this.setCurrent(yMouse - this.yPos - this.height / 2, true);
        }
        return this.active;
    }

    @Override
    public boolean onMouseClicked(JecaGui gui, int xMouse, int yMouse, int button) {
        this.active = this.mouseIn(xMouse, yMouse);
        if (this.active) {
            this.setCurrent(yMouse - this.yPos - this.height / 2, true);
        }
        return this.active;
    }

    @Override
    public boolean onMouseReleased(JecaGui gui, int xMouse, int yMouse, int button) {
        this.active = false;
        return false;
    }

    @Override
    public boolean onMouseScroll(JecaGui gui, int xMouse, int yMouse, int diff) {
        boolean in = this.mouseIn(xMouse, yMouse);
        if (in) {
            this.setCurrent(this.getCurrent() - (float)diff * this.step, true);
        }
        return in;
    }

    public WScroll setStep(float step) {
        this.step = step;
        return this;
    }

    public WScroll setRatio(float ratio) {
        this.height = Math.max((int)((float)(this.ySize - 6) * ratio), 2) + 6;
        return this;
    }

    private void setCurrent(int pos, boolean notify) {
        this.setCurrent((float)pos / (float)(this.ySize - this.height), notify);
    }

    public float getCurrent() {
        return this.current;
    }

    public WScroll setCurrent(float ratio, boolean notify) {
        this.current = ratio;
        if (this.current < 0.0f) {
            this.current = 0.0f;
        }
        if (this.current > 1.0f) {
            this.current = 1.0f;
        }
        if (notify && this.listener != null) {
            this.listener.invoke(this);
        }
        return this;
    }

    public WScroll setCurrent(float ratio) {
        this.setCurrent(ratio, false);
        return this;
    }

    public boolean mouseIn(int xMouse, int yMouse) {
        return JecaGui.mouseIn(this.xPos + 1, this.yPos + 1, this.xSize - 2, this.ySize - 2, xMouse, yMouse);
    }

    public WScroll setListener(@Nullable IWidget.ListenerAction<? super WScroll> listener) {
        this.listener = listener;
        return this;
    }
}

