/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis.pickers;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LFluidStack;
import me.towdium.jecalculation.data.label.labels.LFluidTag;
import me.towdium.jecalculation.data.label.labels.LItemTag;
import me.towdium.jecalculation.data.label.labels.LTag;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.gui.guis.pickers.IPicker;
import me.towdium.jecalculation.gui.widgets.WIcon;
import me.towdium.jecalculation.gui.widgets.WLabelScroll;
import me.towdium.jecalculation.gui.widgets.WSearch;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class PickerSimple
extends IPicker.Impl
implements IGui {
    public PickerSimple(List<ILabel> labels) {
        WLabelScroll ls = new WLabelScroll(7, 33, 8, 7, false).setLabels(labels).setLsnrClick((i, v) -> this.notifyLsnr(i.get((int)v).getLabel()));
        this.add(new WIcon(7, 7, 20, 20, Resource.ICN_TEXT, "common.search"));
        this.add(new WSearch(26, 7, 90, ls));
        this.add(ls);
    }

    public static class Tag
    extends PickerSimple {
        public Tag() {
            super(Tag.generate());
        }

        static List<ILabel> generate() {
            Stream<LItemTag> items = BuiltInRegistries.f_257033_.m_203612_().filter(i -> ((HolderSet.Named)i.getSecond()).m_203632_() > 1).map(i -> new LItemTag((TagKey<Item>)((TagKey)i.getFirst()))).sorted(Comparator.comparing(LTag::getName));
            Stream<LFluidTag> fluids = BuiltInRegistries.f_257020_.m_203612_().filter(i -> ((HolderSet.Named)i.getSecond()).m_203632_() > 1).map(i -> new LFluidTag((TagKey<Fluid>)((TagKey)i.getFirst()))).sorted(Comparator.comparing(LTag::getName));
            return Stream.of(items, fluids).flatMap(i -> i).collect(Collectors.toList());
        }
    }

    public static class FluidStack
    extends PickerSimple {
        public FluidStack() {
            super(BuiltInRegistries.f_257020_.m_123024_().filter(i -> i.m_7444_(i.m_76145_())).map(i -> new LFluidStack(1000L, (Fluid)i)).collect(Collectors.toList()));
        }
    }
}

