/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.forge;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.labels.LPlaceholder;
import me.towdium.jecalculation.data.structure.RecordPlayer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class JecaCapability {
    public static final Capability<Container> CAPABILITY_RECORD = CapabilityManager.get((CapabilityToken)new CapabilityToken<Container>(){});

    public static RecordPlayer getRecord(Player player) {
        return ((Container)player.getCapability(CAPABILITY_RECORD, Direction.UP).orElseGet(Container::new)).getRecord();
    }

    @SubscribeEvent
    public static void onRegisterCapability(RegisterCapabilitiesEvent event) {
        event.register(Container.class);
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof ServerPlayer) {
            e.addCapability(new ResourceLocation("jecalculation", "record"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public static void onCloneCapability(PlayerEvent.Clone e) {
        RecordPlayer r = JecaCapability.getRecord(e.getOriginal());
        ((Container)e.getOriginal().getCapability(CAPABILITY_RECORD, Direction.UP).orElseGet(Container::new)).setRecord(r);
    }

    public static class Container {
        RecordPlayer record;

        public RecordPlayer getRecord() {
            if (this.record == null) {
                this.record = new RecordPlayer();
            }
            return this.record;
        }

        public void setRecord(RecordPlayer r) {
            this.record = r;
        }
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        Container container = new Container();

        public CompoundTag serializeNBT() {
            return this.container.getRecord().serialize();
        }

        public void deserializeNBT(CompoundTag nbt) {
            boolean s = LPlaceholder.state;
            LPlaceholder.state = false;
            this.container.setRecord(new RecordPlayer(nbt));
            LPlaceholder.state = s;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return this.getCapability(cap);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
            return LazyOptional.of((NonNullSupplier)(cap == CAPABILITY_RECORD ? () -> this.container : null));
        }
    }
}

