/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LContext;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class LTag<T>
extends LContext<T> {
    public static final String KEY_NAME = "name";
    protected TagKey<T> name;

    public LTag(TagKey<T> name) {
        this(name, 1L);
    }

    public LTag(TagKey<T> name, long amount) {
        super(amount, false);
        this.name = name;
    }

    public LTag(LTag<T> lt) {
        super(lt);
        this.name = lt.name;
    }

    public LTag(CompoundTag nbt) {
        super(nbt);
        this.name = TagKey.m_203882_((ResourceKey)this.getRegistry().m_123023_(), (ResourceLocation)new ResourceLocation(nbt.m_128461_(KEY_NAME)));
    }

    protected abstract Registry<T> getRegistry();

    public static boolean mergeSame(ILabel a, ILabel b) {
        if (a instanceof LTag) {
            LTag lodA = (LTag)a;
            if (b instanceof LTag) {
                LTag lodB = (LTag)b;
                return lodA.getName().equals(lodB.getName()) && lodA.getContext() == lodB.getContext();
            }
        }
        return false;
    }

    public static boolean mergeFuzzy(ILabel a, ILabel b) {
        if (a instanceof LTag) {
            LTag lt = (LTag)a;
            if (b instanceof LStack) {
                LStack ls = (LStack)b;
                return lt.getAmount() * ls.getAmount() < 0L && lt.getContext().matches(lt.name, ls);
            }
        }
        return false;
    }

    public static List<ILabel> suggest(List<ILabel> is, @Nullable Class<?> context) {
        return LTag.convert(is, true);
    }

    private static <T> List<ILabel> convert(List<ILabel> is, boolean biDir) {
        List iss = is.stream().filter(i -> i instanceof LStack).map(i -> (LStack)i).collect(Collectors.toList());
        if (iss.isEmpty() || iss.size() != is.size()) {
            return Collections.emptyList();
        }
        LStack lis = (LStack)iss.get(0);
        if (iss.stream().anyMatch(i -> i.getContext() != ((LStack)iss.get(0)).getContext())) {
            return Collections.emptyList();
        }
        HashSet ids = new HashSet();
        long amount = lis.getAmount();
        for (TagKey i2 : lis.getContext().discover(lis)) {
            if (!LTag.check(i2, iss, biDir)) continue;
            ids.add(i2);
        }
        return ids.stream().map(i -> lis.getContext().create(i, amount)).collect(Collectors.toList());
    }

    public static List<ILabel> fallback(List<ILabel> is, @Nullable Class<?> context) {
        return LTag.convert(is, false);
    }

    private static <T> boolean check(TagKey<T> id, List<LStack<T>> labels, boolean biDir) {
        if (!id.m_207645_(Registries.f_256913_)) {
            return false;
        }
        Stream<LStack<LStack>> ores = labels.get(0).getContext().discover(id);
        Optional<List> tag = BuiltInRegistries.f_257033_.m_203612_().filter(pair -> ((TagKey)pair.getFirst()).equals((Object)id)).map(Pair::getSecond).findFirst().map(HolderSet.ListBacked::m_203614_).map(s -> s.map(Holder::m_203334_)).map(Stream::toList);
        if (tag.isEmpty()) {
            return false;
        }
        Wrapper<Boolean> acceptable = new Wrapper<Boolean>(true);
        if (biDir) {
            ores.filter(ore -> labels.stream().noneMatch(ore::matches)).findAny().ifPresent(i -> {
                acceptable.value = false;
            });
        }
        labels.stream().filter(label -> label instanceof LItemStack).filter(label -> !((List)tag.get()).contains(((LItemStack)label).item)).findAny().ifPresent(i -> {
            acceptable.value = false;
        });
        return (Boolean)acceptable.value;
    }

    @Override
    public Object getRepresentation() {
        List list = this.getContext().discover(this.name).toList();
        if (list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        long index = System.currentTimeMillis() / 1500L;
        return list.get((int)(index % (long)list.size())).getRepresentation();
    }

    @Override
    public boolean matches(Object l) {
        if (!(l instanceof LTag)) {
            return false;
        }
        LTag tag = (LTag)l;
        return tag.getContext() == this.getContext() && tag.name.equals(this.name) && super.matches(l);
    }

    @Override
    public abstract LTag<T> copy();

    @Override
    public CompoundTag toNbt() {
        CompoundTag ret = super.toNbt();
        ret.m_128359_(KEY_NAME, this.name.f_203868_().toString());
        return ret;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        existing.add("\u00a79\u00a7oJust Enough Calculation");
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ super.hashCode();
    }

    public String getName() {
        return this.name.f_203868_().toString();
    }
}

