/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.Context;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LFluidStack
extends LStack<Fluid> {
    public static final String IDENTIFIER = "fluidStack";
    public static final String KEY_FLUID = "fluid";
    public static final String KEY_NBT = "nbt";
    Fluid fluid;
    CompoundTag nbt;
    FluidStack temp;
    private static final String TIC_CLASS = "slimeknights.tconstruct.plugin.jei.casting.CastingRecipeCategory";

    public FluidStack getRepresentation() {
        return this.temp;
    }

    @Override
    public boolean acceptPercent() {
        return false;
    }

    public LFluidStack(FluidStack fs) {
        this(fs.getAmount(), fs.getFluid(), fs.getTag());
    }

    public LFluidStack(long amount, Fluid fluid) {
        this(amount, fluid, null);
    }

    public LFluidStack(long amount, Fluid fluid, @Nullable CompoundTag nbt) {
        super(amount, false);
        this.init(fluid, nbt);
    }

    public LFluidStack(CompoundTag nbt) {
        super(nbt);
        String id = nbt.m_128461_(KEY_FLUID);
        Optional f = BuiltInRegistries.f_257020_.m_6612_(new ResourceLocation(id));
        if (f.isEmpty()) {
            throw new ILabel.Serializer.SerializationException("Fluid " + id + " cannot be resolved, ignoring");
        }
        this.init((Fluid)f.get(), nbt.m_128441_(KEY_NBT) ? nbt.m_128469_(KEY_NBT) : null);
    }

    @Override
    public Fluid get() {
        return this.fluid;
    }

    @Override
    public Context<Fluid> getContext() {
        return Context.FLUID;
    }

    private void init(Fluid fluid, @Nullable CompoundTag nbt) {
        this.fluid = fluid;
        this.nbt = nbt;
        this.temp = FluidStack.create((Fluid)fluid, (long)1L, (CompoundTag)nbt);
    }

    public LFluidStack(LFluidStack lfs) {
        super(lfs);
        this.fluid = lfs.fluid;
        this.nbt = lfs.nbt;
        this.temp = lfs.temp;
    }

    @Override
    protected int getMultiplier() {
        return 100;
    }

    @Override
    public String getAmountString(boolean round) {
        return LFluidStack.format(this.amount);
    }

    public static String format(long amount) {
        float bucket = FluidStackHooks.bucketAmount();
        return (float)amount >= bucket ? Utilities.cutNumber((float)amount / bucket, 4) + "B" : amount + (Platform.isForge() ? "mB" : "U");
    }

    @Override
    public String getDisplayName() {
        return this.temp.getName().getString();
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        if (l instanceof LFluidStack) {
            LFluidStack lfs = (LFluidStack)l;
            return Objects.equals(this.nbt, lfs.nbt) && this.fluid == lfs.fluid;
        }
        return false;
    }

    @Override
    public LFluidStack copy() {
        return new LFluidStack(this);
    }

    @Override
    public CompoundTag toNbt() {
        CompoundTag ret = super.toNbt();
        ret.m_128359_(KEY_FLUID, BuiltInRegistries.f_257020_.m_7981_((Object)this.fluid).toString());
        if (this.nbt != null) {
            ret.m_128365_(KEY_NBT, (Tag)this.nbt);
        }
        return ret;
    }

    @Override
    public void getToolTip(List<String> existing, boolean detailed) {
        existing.add("\u00a79\u00a7o" + Utilities.getModName(this.fluid));
    }

    @Override
    public void drawLabel(int xPos, int yPos, JecaGui gui, boolean hand) {
        gui.drawResource(Resource.LBL_FLUID, xPos, yPos);
        gui.drawFluid(this.fluid, xPos + 2, yPos + 2, 12, 12);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ BuiltInRegistries.f_257020_.m_7981_((Object)this.fluid).hashCode() ^ (this.nbt == null ? 0 : this.nbt.hashCode());
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable Class<?> context) {
        if (context != null && context.getName().equals(TIC_CLASS) && iss.get(0) instanceof LFluidStack) {
            return Collections.singletonList(iss.get(0).copy().multiply(0.5f));
        }
        return new ArrayList<ILabel>();
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LFluidStack && b instanceof LFluidStack) {
            return a.matches(b);
        }
        return false;
    }
}

