/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label;

import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.JustEnoughCalculation;
import me.towdium.jecalculation.compat.ModCompat;
import me.towdium.jecalculation.compat.jei.JecaJEIPlugin;
import me.towdium.jecalculation.data.label.labels.LFluidStack;
import me.towdium.jecalculation.data.label.labels.LFluidTag;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.data.label.labels.LItemTag;
import me.towdium.jecalculation.data.label.labels.LPlaceholder;
import me.towdium.jecalculation.data.label.labels.LTag;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.guis.pickers.IPicker;
import me.towdium.jecalculation.gui.guis.pickers.PickerItemStack;
import me.towdium.jecalculation.gui.guis.pickers.PickerPlaceholder;
import me.towdium.jecalculation.gui.guis.pickers.PickerSimple;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface ILabel {
    public static final Merger MERGER = new Merger();
    public static final Serializer SERIALIZER = new Serializer();
    public static final Converter CONVERTER = new Converter();
    public static final RegistryEditor EDITOR = new RegistryEditor();
    public static final ILabel EMPTY = new LEmpty();
    public static final String FORMAT_BLUE = "\u00a79";
    public static final String FORMAT_GREY = "\u00a78";
    public static final String FORMAT_ITALIC = "\u00a7o";

    @Nullable
    public Object getRepresentation();

    public ILabel increaseAmount();

    public ILabel decreaseAmount();

    public static void initClient() {
        CONVERTER.register(LItemStack::suggest, Converter.Priority.SUGGEST);
        CONVERTER.register(LTag::suggest, Converter.Priority.SUGGEST);
        CONVERTER.register(LFluidStack::suggest, Converter.Priority.SUGGEST);
        CONVERTER.register(LItemStack::fallback, Converter.Priority.FALLBACK);
        CONVERTER.register(LTag::fallback, Converter.Priority.FALLBACK);
        EDITOR.register(PickerSimple.FluidStack::new, "fluid", new LFluidStack(1000L, (Fluid)Fluids.f_76193_));
        EDITOR.register(PickerSimple.Tag::new, "tag", new LItemTag(Utilities.IRON_INGOTS));
        EDITOR.register(PickerPlaceholder::new, "placeholder", new LPlaceholder("example", 1L, true));
        EDITOR.register(PickerItemStack::new, "item", new LItemStack(new ItemStack((ItemLike)Items.f_42385_)).setFMeta(true));
        MERGER.register("itemStack", "itemStack", Impl.form(LItemStack.class, LItemStack.class, LItemStack::merge));
        MERGER.register("itemTag", "itemTag", Impl.form(LItemTag.class, LItemTag.class, LTag::mergeSame));
        MERGER.register("itemTag", "itemStack", Impl.form(LItemTag.class, LItemStack.class, LTag::mergeFuzzy));
        MERGER.register("fluidTag", "fluidTag", Impl.form(LFluidTag.class, LFluidTag.class, LTag::mergeSame));
        MERGER.register("fluidTag", "fluidStack", Impl.form(LFluidTag.class, LFluidStack.class, LTag::mergeFuzzy));
        MERGER.register("fluidStack", "fluidStack", Impl.form(LFluidStack.class, LFluidStack.class, LFluidStack::merge));
        MERGER.register("placeholder", "placeholder", Impl.form(LPlaceholder.class, LPlaceholder.class, LPlaceholder::merge));
    }

    public long getAmount();

    public ILabel multiply(float var1);

    public boolean acceptPercent();

    public ILabel setPercent(boolean var1);

    public boolean isPercent();

    public static void initServer() {
        SERIALIZER.register("fluidStack", LFluidStack::new);
        SERIALIZER.register("itemStack", LItemStack::new);
        SERIALIZER.register("itemTag", LItemTag::new);
        SERIALIZER.register("fluidTag", LFluidTag::new);
        SERIALIZER.register("placeholder", LPlaceholder::new);
        SERIALIZER.register("empty", i -> EMPTY);
    }

    public String getAmountString(boolean var1);

    public String getDisplayName();

    public void getToolTip(List<String> var1, boolean var2);

    public ILabel copy();

    public CompoundTag toNbt();

    public String getIdentifier();

    public ILabel setAmount(long var1);

    public boolean matches(Object var1);

    default public void drawLabel(JecaGui gui, int xPos, int yPos, boolean center) {
        this.drawLabel(gui, xPos, yPos, center, false);
    }

    public void drawLabel(JecaGui var1, int var2, int var3, boolean var4, boolean var5);

    public static class Converter {
        static EnumMap<Priority, ArrayList<ConverterFunction>> handlers = new EnumMap(Priority.class);

        public static ILabel from(@Nullable Object o) {
            if (o == null) {
                return EMPTY;
            }
            if (o instanceof ILabel) {
                ILabel label = (ILabel)o;
                return label;
            }
            if (o instanceof ItemStack) {
                return new LItemStack((ItemStack)o);
            }
            if (o instanceof FluidStack) {
                return new LFluidStack((FluidStack)o);
            }
            if (o instanceof EnchantmentInstance) {
                return new LItemStack(EnchantedBookItem.m_41161_((EnchantmentInstance)((EnchantmentInstance)o)));
            }
            if (ModCompat.isJEILoaded && JecaJEIPlugin.FABRIC_FLUID_INGREDIENT_CLASS != null && JecaJEIPlugin.FABRIC_FLUID_INGREDIENT_CLASS.isAssignableFrom(o.getClass()) || JecaJEIPlugin.FORGE_FLUID_INGREDIENT_CLASS != null && JecaJEIPlugin.FORGE_FLUID_INGREDIENT_CLASS.isAssignableFrom(o.getClass())) {
                return new LFluidStack(Utilities.createFluidStackFromJeiIngredient(o));
            }
            return LPlaceholder.Converter.from(o);
        }

        public void register(ConverterFunction handler, Priority priority) {
            handlers.get((Object)priority).add(handler);
        }

        public ILabel first(List<ILabel> labels, @Nullable Class<?> context) {
            List guess = (List)this.guess(labels, context).one;
            return guess.isEmpty() ? labels.get(0) : (ILabel)guess.get(0);
        }

        public Pair<List<ILabel>, List<ILabel>> guess(List<ILabel> labels, @Nullable Class<?> context) {
            List suggest = new Utilities.ReversedIterator((List)handlers.get((Object)Priority.SUGGEST)).stream().flatMap(h -> h.convert(labels, context).stream()).collect(Collectors.toList());
            List fallback = new Utilities.ReversedIterator((List)handlers.get((Object)Priority.FALLBACK)).stream().flatMap(h -> h.convert(labels, context).stream()).collect(Collectors.toList());
            return new Pair<List<ILabel>, List<ILabel>>(suggest, fallback);
        }

        static {
            handlers.put(Priority.SUGGEST, new ArrayList());
            handlers.put(Priority.FALLBACK, new ArrayList());
        }

        public static enum Priority {
            SUGGEST,
            FALLBACK;

        }

        @FunctionalInterface
        public static interface ConverterFunction {
            public List<ILabel> convert(List<ILabel> var1, @Nullable Class<?> var2);
        }
    }

    public static class RegistryEditor {
        private final ArrayList<Record> records = new ArrayList();

        private RegistryEditor() {
        }

        public void register(Supplier<IPicker> editor, String unlocalizedName, ILabel representation) {
            this.records.add(new Record(editor, "common.label." + unlocalizedName, representation));
        }

        public List<Record> getRecords() {
            return this.records;
        }

        public static class Record {
            public Supplier<IPicker> editor;
            public String localizeKey;
            public ILabel representation;

            public Record(Supplier<IPicker> editor, String localizeKey, ILabel representation) {
                this.editor = editor;
                this.localizeKey = localizeKey;
                this.representation = representation;
            }
        }
    }

    public static class Merger {
        private final Utilities.Relation<String, MergerFunction> functions = new Utilities.Relation();

        private Merger() {
        }

        public void register(String a, String b, MergerFunction func) {
            this.functions.put(a, b, func);
        }

        public Optional<ILabel> merge(ILabel a, ILabel b) {
            MergerFunction mf = this.functions.get(a.getIdentifier(), b.getIdentifier());
            if (mf == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(mf.merge(a, b));
        }

        @FunctionalInterface
        public static interface MergerFunction {
            @Nullable
            public ILabel merge(ILabel var1, ILabel var2);
        }
    }

    public static abstract class Impl
    implements ILabel {
        public static final String KEY_AMOUNT = "amount";
        public static final String KEY_PERCENT = "percent";
        protected long amount;
        protected boolean percent;

        public String toString() {
            return this.getDisplayName() + "x" + this.getAmount();
        }

        public Impl(long amount, boolean percent) {
            this.amount = amount;
            this.percent = percent;
        }

        public Impl(Impl lsa) {
            this.amount = lsa.amount;
            this.percent = lsa.percent;
        }

        public Impl(CompoundTag nbt) {
            this.amount = nbt.m_128454_(KEY_AMOUNT);
            this.percent = nbt.m_128471_(KEY_PERCENT);
        }

        protected int getMultiplier() {
            return 1;
        }

        @Override
        public void drawLabel(JecaGui gui, int xPos, int yPos, boolean center, boolean hand) {
            gui.getGraphics().m_280168_().m_85836_();
            this.drawLabel(center ? xPos - 8 : xPos, center ? yPos - 8 : yPos, gui, hand);
            gui.getGraphics().m_280168_().m_85849_();
        }

        protected abstract void drawLabel(int var1, int var2, JecaGui var3, boolean var4);

        @Override
        public ILabel increaseAmount() {
            int mul = this.getMultiplier();
            if (this.getAmount() == 1L && mul != 1) {
                return this.setAmount(mul);
            }
            return this.setAmount(this.getAmount() + (long)mul);
        }

        @Override
        public ILabel decreaseAmount() {
            if (this.getAmount() <= (long)this.getMultiplier()) {
                return this.setAmount(1L);
            }
            return this.setAmount(this.getAmount() - (long)this.getMultiplier());
        }

        public int hashCode() {
            return (int)(this.amount ^ (long)(this.percent ? 1 : 0));
        }

        protected static Merger.MergerFunction form(Class<?> a, Class<?> b, BiPredicate<ILabel, ILabel> p) {
            return (c, d) -> {
                if (a.isInstance(d) && b.isInstance(c)) {
                    ILabel tmp = c;
                    c = d;
                    d = tmp;
                }
                if (a.isInstance(c) && b.isInstance(d) && p.test(c, d)) {
                    long amountC = c.isPercent() ? c.getAmount() : Math.multiplyExact(c.getAmount(), 100);
                    long amountD = d.isPercent() ? d.getAmount() : Math.multiplyExact(d.getAmount(), 100);
                    long amount = Math.addExact(amountC, amountD);
                    long amountI = (amount > 0L ? Math.addExact(amount, 99L) : Math.subtractExact(amount, 99L)) / 100L;
                    if (amount == 0L) {
                        return EMPTY;
                    }
                    if (amount > 0L) {
                        return d.copy().setAmount(d.isPercent() ? amount : amountI);
                    }
                    return c.copy().setAmount(c.isPercent() ? amount : amountI);
                }
                return null;
            };
        }

        @Override
        public ILabel multiply(float i) {
            float amount = i * (float)this.getAmount();
            if (amount > 9.223372E18f) {
                throw new ArithmeticException("Multiply overflow");
            }
            return this.setAmount((long)amount);
        }

        @Override
        public void getToolTip(List<String> existing, boolean detailed) {
            if (detailed) {
                long amount = this.percent ? (this.getAmount() + 99L) / 100L : this.getAmount();
                long stack = amount / 64L;
                long remainder = amount % 64L;
                boolean showStack = stack != 0L;
                boolean showReminder = stack < 1000L && remainder != 0L;
                Object tip = "";
                if (showStack) {
                    tip = (String)tip + Utilities.cutNumber(stack, 5) + "x64";
                }
                if (showStack && showReminder) {
                    tip = (String)tip + "+";
                }
                if (showReminder) {
                    tip = (String)tip + Long.toString(remainder);
                }
                existing.add(ILabel.FORMAT_GREY + Utilities.I18n.get("label.common.amount", tip));
            }
        }

        @Override
        public long getAmount() {
            return this.amount;
        }

        @Override
        public ILabel setAmount(long amount) {
            if (amount == 0L) {
                return EMPTY;
            }
            this.amount = amount;
            return this;
        }

        @Override
        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_(KEY_AMOUNT, this.amount);
            if (this.percent) {
                nbt.m_128379_(KEY_PERCENT, true);
            }
            return nbt;
        }

        @Override
        public boolean acceptPercent() {
            return true;
        }

        @Override
        public ILabel setPercent(boolean p) {
            if (p && !this.acceptPercent()) {
                throw new UnsupportedOperationException();
            }
            if (p && !this.percent) {
                this.amount *= 100L;
                this.percent = true;
            } else if (!p && this.percent) {
                this.amount = (this.amount + 99L) / 100L;
                this.percent = false;
            }
            return this;
        }

        @Override
        public boolean isPercent() {
            return this.percent;
        }

        public boolean equals(Object obj) {
            return obj instanceof Impl && this.amount == ((Impl)obj).amount && this.matches(obj);
        }

        @Override
        public String getAmountString(boolean round) {
            if (this.getAmount() == 0L) {
                return "";
            }
            if (!this.percent) {
                return Utilities.cutNumber(this.getAmount(), 5);
            }
            if (round) {
                return Utilities.cutNumber((this.getAmount() + 99L) / 100L, 5);
            }
            return Utilities.cutNumber(this.getAmount(), 4) + "%";
        }

        @Override
        public abstract Impl copy();

        @Override
        public boolean matches(Object l) {
            return l instanceof Impl && this.percent == ((Impl)l).percent;
        }
    }

    public static class Serializer {
        public static final String KEY_IDENTIFIER = "type";
        public static final String KEY_CONTENT = "content";
        private final HashMap<String, Function<CompoundTag, ILabel>> idToData = new HashMap();

        private Serializer() {
        }

        public void register(String identifier, Function<CompoundTag, ILabel> deserializer) {
            this.idToData.put(identifier, deserializer);
        }

        public ILabel deserialize(CompoundTag nbt) {
            String s = nbt.m_128461_(KEY_IDENTIFIER);
            Function<CompoundTag, ILabel> func = this.idToData.get(s);
            if (func == null) {
                JustEnoughCalculation.logger.warn("Unrecognized identifier \"" + s + "\", abort");
            } else {
                try {
                    return func.apply(nbt.m_128469_(KEY_CONTENT));
                }
                catch (SerializationException serializationException) {
                    // empty catch block
                }
            }
            return EMPTY;
        }

        public CompoundTag serialize(ILabel label) {
            CompoundTag ret = new CompoundTag();
            ret.m_128359_(KEY_IDENTIFIER, label.getIdentifier());
            ret.m_128365_(KEY_CONTENT, (Tag)label.toNbt());
            return ret;
        }

        public static class SerializationException
        extends RuntimeException {
            public SerializationException(String s) {
                super(s);
                JustEnoughCalculation.logger.warn(s);
            }
        }
    }

    public static class LEmpty
    implements ILabel {
        public static final String IDENTIFIER = "empty";

        @Override
        public boolean matches(Object l) {
            return l == this;
        }

        @Override
        public void drawLabel(JecaGui gui, int xPos, int yPos, boolean center, boolean hand) {
        }

        private LEmpty() {
        }

        @Override
        @Nullable
        public Object getRepresentation() {
            return null;
        }

        @Override
        public ILabel increaseAmount() {
            return this;
        }

        @Override
        public ILabel decreaseAmount() {
            return this;
        }

        @Override
        public ILabel multiply(float i) {
            return this;
        }

        @Override
        public boolean acceptPercent() {
            return false;
        }

        @Override
        public ILabel setPercent(boolean p) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPercent() {
            return false;
        }

        @Override
        public long getAmount() {
            return 0L;
        }

        @Override
        public ILabel setAmount(long amount) {
            return this;
        }

        @Override
        public String getAmountString(boolean round) {
            return "";
        }

        @Override
        public String getDisplayName() {
            return "";
        }

        @Override
        public void getToolTip(List<String> existing, boolean detailed) {
        }

        @Override
        public ILabel copy() {
            return this;
        }

        @Override
        public CompoundTag toNbt() {
            return new CompoundTag();
        }

        @Override
        public String getIdentifier() {
            return IDENTIFIER;
        }
    }
}

