/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data;

import dev.architectury.platform.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.JustEnoughCalculation;
import me.towdium.jecalculation.data.label.labels.LPlaceholder;
import me.towdium.jecalculation.data.structure.IRecord;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.data.structure.Recipes;
import me.towdium.jecalculation.data.structure.RecordCraft;
import me.towdium.jecalculation.data.structure.RecordMath;
import me.towdium.jecalculation.data.structure.RecordPlayer;
import me.towdium.jecalculation.network.packets.PCalculator;
import me.towdium.jecalculation.network.packets.PEdit;
import me.towdium.jecalculation.network.packets.PRecord;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Controller {
    public static final String KEY_MATH = "math";
    public static final String KEY_CRAFT = "craft";
    public static final String KEY_PLAYER = "player";
    static RecordPlayer rPlayerServer;
    static RecordPlayer rPlayerClient;
    static RecordCraft rCraftClient;
    static RecordMath rMathClient;

    public static void setRecordsServer(RecordPlayer r) {
        rPlayerServer = r;
    }

    public static boolean isServerActive() {
        return rPlayerServer != null;
    }

    static Recipes getRecipes() {
        if (Controller.isServerActive()) {
            return Controller.rPlayerServer.recipes;
        }
        return Controller.rPlayerClient.recipes;
    }

    public static List<Pair<String, Recipes>> discover() {
        File dir = new File(Platform.getConfigFolder().toFile(), "jecalculation/data");
        File[] fs = dir.listFiles();
        Function<File, Recipes> read = f -> {
            CompoundTag nbt = Utilities.Json.read(f);
            JustEnoughCalculation.logger.warn("File " + f.getAbsolutePath() + " contains invalid records.");
            return nbt == null ? null : new Recipes(nbt);
        };
        if (fs == null) {
            return new ArrayList<Pair<String, Recipes>>();
        }
        return Arrays.stream(fs).map(i -> new Pair<String, Recipes>(i.getName(), (Recipes)read.apply((File)i))).filter(i -> i.two != null).collect(Collectors.toList());
    }

    public static void inport(Recipes recipes, String group) {
        ArrayList buffer = new ArrayList();
        recipes.getGroup(group).stream().filter(i -> !Controller.hasDuplicate(i)).forEach(buffer::add);
        for (Recipe r : buffer) {
            Controller.addRecipe(group, r);
        }
    }

    private static void export(String s, Function<Recipes, CompoundTag> r) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        File f = new File(Platform.getConfigFolder().toFile(), "jecalculation/data/" + s + ".json");
        Utilities.Json.write(r.apply(Controller.getRecipes()), f);
        player.m_5661_((Component)Component.m_237110_((String)"jecalculation.chat.export", (Object[])new Object[]{f.getAbsolutePath()}), false);
    }

    public static void export(String group) {
        Controller.export(group, i -> i.serialize(Collections.singleton(group)));
    }

    public static void export() {
        Controller.export("groups", Recipes::serialize);
    }

    @Nullable
    public static String getLast() {
        return Controller.isServerActive() ? Controller.rPlayerServer.last : Controller.rPlayerClient.last;
    }

    static void setLast(String last) {
        if (Controller.isServerActive()) {
            Controller.rPlayerServer.last = last;
        } else {
            Controller.rPlayerClient.last = last;
        }
    }

    public static List<String> getGroups() {
        return Controller.getRecipes().getGroups();
    }

    public static void setRecipe(String neu, String old, int index, Recipe recipe) {
        Controller.getRecipes().set(neu, old, index, recipe);
        Controller.setLast(neu);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((Object)new PEdit(neu, old, index, recipe));
        }
    }

    public static void renameGroup(String old, String neu) {
        Controller.getRecipes().renameGroup(old, neu);
        Controller.setLast(neu);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((Object)new PEdit(neu, old, -1, null));
        }
    }

    public static void addRecipe(String group, Recipe recipe) {
        Controller.getRecipes().add(group, recipe);
        Controller.setLast(group);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((Object)new PEdit(group, null, -1, recipe));
        }
    }

    public static void setRecipe(String group, int index, Recipe recipe) {
        Controller.getRecipes().set(group, index, recipe);
        Controller.setLast(group);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((Object)new PEdit(group, null, index, recipe));
        }
    }

    public static void removeRecipe(String group, int index) {
        Controller.getRecipes().remove(group, index);
        Controller.setLast(group);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((Object)new PEdit(group, null, index, null));
        }
    }

    public static void removeGroup(String group) {
        Controller.getRecipes().remove(group);
        Controller.setLast(group);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((Object)new PEdit(group, null, -1, null));
        }
    }

    public static Recipe getRecipe(String group, int index) {
        return Controller.getRecipes().getRecipe(group, index);
    }

    public static Stream<Pair<String, List<Recipe>>> stream() {
        return Controller.getRecipes().stream();
    }

    public static Recipes.RecipeIterator recipeIterator() {
        return Controller.getRecipes().recipeIterator();
    }

    public static Recipes.RecipeIterator recipeIterator(String group) {
        return Controller.getRecipes().recipeIterator(group);
    }

    public static void setRMath(RecordMath math, @Nullable ItemStack is, int slot) {
        Controller.setR(math, i -> {
            rMathClient = i;
        }, KEY_MATH, is, slot);
    }

    public static void setRCraft(RecordCraft rc, @Nullable ItemStack is, int slot) {
        Controller.setR(rc, i -> {
            rCraftClient = i;
        }, KEY_CRAFT, is, slot);
    }

    public static RecordCraft getRCraft(@Nullable ItemStack is) {
        return Controller.getR(rCraftClient, KEY_CRAFT, RecordCraft::new, is);
    }

    public static RecordMath getRMath(@Nullable ItemStack is) {
        return Controller.getR(rMathClient, KEY_MATH, RecordMath::new, is);
    }

    private static <T extends IRecord> void setR(T t, Consumer<T> c, String s, @Nullable ItemStack is, int slot) {
        if (!Controller.isServerActive()) {
            c.accept(t);
        } else if (is != null) {
            Utilities.getTag(is).m_128365_(s, (Tag)t.serialize());
            JustEnoughCalculation.network.sendToServer((Object)new PCalculator(is, slot));
        }
    }

    public static <T> T getR(T t, String s, Function<CompoundTag, T> f, @Nullable ItemStack is) {
        if (!Controller.isServerActive()) {
            return t;
        }
        if (is != null) {
            return f.apply(Utilities.getTag(is).m_128469_(s));
        }
        throw new RuntimeException("Internal error");
    }

    public static boolean hasDuplicate(Recipe r, String group, int index) {
        Recipes.RecipeIterator ri = Controller.recipeIterator();
        return ri.stream().anyMatch(i -> {
            if (ri.getIndex() == index && ri.getGroup().equals(group)) {
                return false;
            }
            return i.equals(r);
        });
    }

    public static boolean hasDuplicate(Recipe r) {
        return Controller.recipeIterator().stream().anyMatch(i -> i.equals(r));
    }

    public static void loadFromLocal() {
        new File(Utilities.config(), "/data").mkdirs();
        File file = new File(Utilities.config() + "/record.json");
        CompoundTag nbt = Utilities.Json.read(file);
        boolean s = LPlaceholder.state;
        LPlaceholder.state = true;
        if (nbt != null) {
            rCraftClient = new RecordCraft(nbt.m_128469_(KEY_CRAFT));
            rMathClient = new RecordMath(nbt.m_128469_(KEY_MATH));
            rPlayerClient = nbt.m_128441_(KEY_PLAYER) ? new RecordPlayer(nbt.m_128469_(KEY_PLAYER)) : new RecordPlayer();
        } else {
            rPlayerClient = new RecordPlayer();
            rCraftClient = new RecordCraft(new CompoundTag());
            rMathClient = new RecordMath(new CompoundTag());
        }
        LPlaceholder.state = s;
    }

    public static void writeToLocal() {
        File file = new File(Utilities.config(), "/record.json");
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(KEY_CRAFT, (Tag)rCraftClient.serialize());
        nbt.m_128365_(KEY_PLAYER, (Tag)rPlayerClient.serialize());
        nbt.m_128365_(KEY_MATH, (Tag)rMathClient.serialize());
        Utilities.Json.write(nbt, file);
    }

    public static class Server {
        public static void onJoin(ServerPlayer player) {
            if (!Utilities.isClientMode()) {
                JustEnoughCalculation.network.sendToPlayer(player, (Object)new PRecord(Utilities.getRecord((Player)player)));
            }
        }
    }

    public static class Client {
        public static void onLogOut(@Nullable LocalPlayer player) {
            Controller.writeToLocal();
            rPlayerServer = null;
        }
    }
}

