/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.spectrelib.platform;

import com.illusivesoulworks.spectrelib.platform.services.IConfigHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;

public class ForgeConfigHelper
implements IConfigHelper {
    private static final LevelResource SERVERCONFIG = new LevelResource("serverconfig");

    @Override
    public Path getBackwardsCompatiblePath() {
        return FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath());
    }

    @Override
    public Path getGlobalConfigPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Path getServerConfigPath(MinecraftServer server) {
        Path serverConfig = server.m_129843_(SERVERCONFIG);
        if (!Files.isDirectory(serverConfig, new LinkOption[0])) {
            try {
                Files.createDirectories(serverConfig, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return serverConfig;
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist() == Dist.DEDICATED_SERVER;
    }
}

