/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.spectrelib.config.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ListConfigScreen
extends Screen {
    private final Set<Integer> invalidEntries = new HashSet<Integer>();
    private final List<String> values;
    private final Consumer<List<String>> onDone;
    private final Predicate<Object> validator;
    private final Screen lastScreen;
    private final Component subtitle;
    private Button doneButton;
    private ListConfig listConfig;

    public ListConfigScreen(Component title, Component subtitle, List<String> values, Screen lastScreen, Predicate<Object> validator, Consumer<List<String>> onDone) {
        super(title);
        this.subtitle = subtitle;
        this.values = new LinkedList<String>(values);
        this.lastScreen = lastScreen;
        this.onDone = onDone;
        this.validator = validator;
    }

    protected void m_7856_() {
        this.listConfig = new ListConfig();
        this.m_7787_((GuiEventListener)this.listConfig);
        GridLayout.RowHelper gridlayout$rowhelper = new GridLayout().m_267749_(10).m_264606_(2);
        this.doneButton = (Button)gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.onDone.accept(this.values);
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.lastScreen);
            }
        }).m_253136_());
        gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130656_, button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.lastScreen);
            }
        }).m_253136_());
        gridlayout$rowhelper.m_267613_().m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        gridlayout$rowhelper.m_267613_().m_264152_(this.f_96543_ / 2 - 155, this.f_96544_ - 28);
        gridlayout$rowhelper.m_267613_().m_264036_();
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.lastScreen);
        }
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int x, int y, float delta) {
        this.listConfig.m_88315_(guiGraphics, x, y, delta);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 16, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, this.subtitle, this.f_96543_ / 2, 30, 0xFFFFFF);
        super.m_88315_(guiGraphics, x, y, delta);
    }

    private void updateDoneButton() {
        this.doneButton.f_93623_ = this.invalidEntries.isEmpty();
    }

    void markInvalid(int index) {
        this.invalidEntries.add(index);
        this.updateDoneButton();
    }

    void clearInvalid(int index) {
        this.invalidEntries.remove(index);
        this.updateDoneButton();
    }

    public class ListConfig
    extends ContainerObjectSelectionList<Entry> {
        public ListConfig() {
            super(Objects.requireNonNull(ListConfigScreen.this.f_96541_), ListConfigScreen.this.f_96543_, ListConfigScreen.this.f_96544_, 43, ListConfigScreen.this.f_96544_ - 32, 24);
            for (int i = 0; i < ListConfigScreen.this.values.size(); ++i) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry(i, this.m_5759_()));
            }
            if (this.m_6702_().size() == 0) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry(-1, this.m_5759_()));
            }
        }

        void addEmptyEntry(int index) {
            this.m_93516_();
            ListConfigScreen.this.values.add(index, "");
            if (!ListConfigScreen.this.validator.test(Collections.singletonList(""))) {
                ListConfigScreen.this.markInvalid(index);
            }
            for (int i = 0; i < ListConfigScreen.this.values.size(); ++i) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry(i, this.m_5759_()));
            }
            if (this.m_6702_().size() == 0) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry(-1, this.m_5759_()));
            }
        }

        void removeEntry(int index) {
            this.m_93516_();
            ListConfigScreen.this.values.remove(index);
            for (int i = 0; i < ListConfigScreen.this.values.size(); ++i) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry(i, this.m_5759_()));
            }
            if (this.m_6702_().size() == 0) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry(-1, this.m_5759_()));
            }
        }

        public int m_5759_() {
            return super.m_5759_() + 100;
        }

        protected int m_5756_() {
            return super.m_5756_() + 50;
        }
    }

    public final class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private EditBox input = null;
        private final Button addButton;
        private Button removeButton = null;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();

        public Entry(int index, int width) {
            if (index >= 0) {
                String currentValue = ListConfigScreen.this.values.get(index);
                this.input = new EditBox(Objects.requireNonNull(((ListConfigScreen)ListConfigScreen.this).f_96541_).f_91062_, 10, 5, width - 45, 20, (Component)Component.m_237113_((String)currentValue));
                this.input.m_94144_(currentValue);
                this.input.m_94151_(newValue -> {
                    if (ListConfigScreen.this.validator.test(Collections.singletonList(newValue))) {
                        this.input.m_94202_(0xE0E0E0);
                        ListConfigScreen.this.values.set(index, (String)newValue);
                        ListConfigScreen.this.clearInvalid(index);
                    } else {
                        this.input.m_94202_(0xFF0000);
                        ListConfigScreen.this.markInvalid(index);
                    }
                });
                this.removeButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
                    ListConfigScreen.this.listConfig.removeEntry(index);
                    ListConfigScreen.this.clearInvalid(index);
                }).m_252987_(10, 5, 20, 20).m_253136_();
            }
            this.addButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> ListConfigScreen.this.listConfig.addEmptyEntry(index + 1)).m_252987_(10, 5, 20, 20).m_253136_();
            if (this.input != null) {
                this.children.add((AbstractWidget)this.input);
            }
            this.children.add((AbstractWidget)this.addButton);
            if (this.removeButton != null) {
                this.children.add((AbstractWidget)this.removeButton);
            }
        }

        @Nonnull
        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        @Nonnull
        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int p_281471_, int y, int x, int offset, int p_283543_, int mouseX, int mouseY, boolean p_283227_, float delta) {
            if (this.input != null) {
                this.input.m_252865_(x);
                this.input.m_253211_(y);
                this.input.m_88315_(guiGraphics, mouseX, mouseY, delta);
            }
            this.addButton.m_252865_(x + offset - 42);
            this.addButton.m_253211_(y);
            this.addButton.m_88315_(guiGraphics, mouseX, mouseY, delta);
            if (this.removeButton != null) {
                this.removeButton.m_252865_(x + offset - 20);
                this.removeButton.m_253211_(y);
                this.removeButton.m_88315_(guiGraphics, mouseX, mouseY, delta);
            }
        }
    }
}

