/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.spectrelib.config.client.screen;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.google.common.collect.ImmutableList;
import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import com.illusivesoulworks.spectrelib.config.client.screen.ListConfigScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.EnumUtils;

public class EditConfigScreen
extends Screen {
    private final Set<String> invalidEntries = new HashSet<String>();
    private final Map<String, Object> spec;
    private final Map<String, Object> specValues;
    private final Map<String, Object> values;
    private final Consumer<Map<String, Object>> onDone;
    private final Screen lastScreen;
    private final Component subtitle;
    private Button doneButton;
    private ConfigList configList;

    public EditConfigScreen(Component title, Component subtitle, Map<String, Object> spec, Map<String, Object> specValues, Map<String, Object> values, Screen lastScreen, Consumer<Map<String, Object>> onDone) {
        super(title);
        this.subtitle = subtitle;
        this.spec = spec;
        this.specValues = specValues;
        this.values = new HashMap<String, Object>(values);
        this.lastScreen = lastScreen;
        this.onDone = onDone;
    }

    protected void m_7856_() {
        this.configList = new ConfigList(this.spec, this.specValues);
        this.m_7787_((GuiEventListener)this.configList);
        GridLayout.RowHelper gridlayout$rowhelper = new GridLayout().m_267749_(10).m_264606_(2);
        this.doneButton = (Button)gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.onDone.accept(this.values);
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.lastScreen);
            }
        }).m_253136_());
        gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130656_, button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.lastScreen);
            }
        }).m_253136_());
        gridlayout$rowhelper.m_267613_().m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        gridlayout$rowhelper.m_267613_().m_264152_(this.f_96543_ / 2 - 155, this.f_96544_ - 28);
        gridlayout$rowhelper.m_267613_().m_264036_();
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.lastScreen);
        }
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int x, int y, float delta) {
        this.configList.m_88315_(guiGraphics, x, y, delta);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 16, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, this.subtitle, this.f_96543_ / 2, 30, 0xFFFFFF);
        super.m_88315_(guiGraphics, x, y, delta);
    }

    private void updateDoneButton() {
        this.doneButton.f_93623_ = this.invalidEntries.isEmpty();
    }

    void markInvalid(String path) {
        this.invalidEntries.add(path);
        this.updateDoneButton();
    }

    void clearInvalid(String path) {
        this.invalidEntries.remove(path);
        this.updateDoneButton();
    }

    public class ConfigList
    extends ContainerObjectSelectionList<ConfigEntry> {
        public ConfigList(Map<String, Object> spec, Map<String, Object> specValues) {
            super(Objects.requireNonNull(EditConfigScreen.this.f_96541_), EditConfigScreen.this.f_96543_, EditConfigScreen.this.f_96544_, 43, EditConfigScreen.this.f_96544_ - 32, 24);
            spec.forEach((key, obj) -> {
                if (obj instanceof SpectreConfigSpec.ValueSpec) {
                    String s2;
                    SpectreConfigSpec.ValueSpec value = (SpectreConfigSpec.ValueSpec)obj;
                    MutableComponent nameComponent = Component.m_264568_((String)(value.getLocalizationKey() + ".name"), (String)key);
                    MutableComponent defaultComponent = Component.m_237110_((String)"editGamerule.default", (Object[])new Object[]{Component.m_237113_((String)value.getDefault().toString())}).m_130940_(ChatFormatting.GRAY);
                    String s1 = value.getLocalizationKey() + ".description";
                    String comment = value.getComment() != null ? value.getComment() : "";
                    String range = "";
                    String allowed = "";
                    if (!comment.isBlank()) {
                        int i = comment.indexOf("Range:");
                        if (i != -1) {
                            range = comment.substring(i);
                            comment = comment.substring(0, i);
                        }
                        if ((i = comment.indexOf("Allowed Values:")) != -1) {
                            allowed = comment.substring(i);
                            comment = comment.substring(0, i);
                        }
                    }
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.add((Object)Component.m_237113_((String)key).m_130940_(ChatFormatting.YELLOW).m_7532_());
                    if (I18n.m_118936_((String)s1)) {
                        MutableComponent component3 = Component.m_237115_((String)s1);
                        EditConfigScreen.this.f_96547_.m_92923_((FormattedText)component3, 150).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                        s2 = component3.getString() + "\n" + defaultComponent.getString();
                    } else {
                        ArrayList<MutableComponent> commentComponents = new ArrayList<MutableComponent>();
                        for (String s : comment.split("\n")) {
                            commentComponents.add(Component.m_237113_((String)s));
                        }
                        for (Component component : commentComponents) {
                            EditConfigScreen.this.f_96547_.m_92923_((FormattedText)component, 150).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                        }
                        s2 = commentComponents.stream().map(Component::getString).collect(Collectors.joining()) + defaultComponent.getString();
                    }
                    if (!range.isBlank()) {
                        EditConfigScreen.this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)range).m_130940_(ChatFormatting.GREEN), 150).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                    } else if (!allowed.isBlank()) {
                        EditConfigScreen.this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)allowed).m_130940_(ChatFormatting.GREEN), 150).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                    }
                    EditConfigScreen.this.f_96547_.m_92923_((FormattedText)defaultComponent, 150).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                    ImmutableList list = builder.build();
                    Object current = specValues.get(key);
                    if (current instanceof SpectreConfigSpec.IntValue) {
                        this.m_7085_((AbstractSelectionList.Entry)new IntegerConfigEntry((Component)nameComponent, (List<FormattedCharSequence>)list, s2, (String)key));
                    } else if (current instanceof SpectreConfigSpec.BooleanValue) {
                        this.m_7085_((AbstractSelectionList.Entry)new BooleanConfigEntry((Component)nameComponent, (List<FormattedCharSequence>)list, s2, (String)key));
                    } else if (current instanceof SpectreConfigSpec.DoubleValue) {
                        this.m_7085_((AbstractSelectionList.Entry)new DoubleConfigEntry((Component)nameComponent, (List<FormattedCharSequence>)list, s2, (String)key));
                    } else if (current instanceof SpectreConfigSpec.LongValue) {
                        this.m_7085_((AbstractSelectionList.Entry)new LongConfigEntry((Component)nameComponent, (List<FormattedCharSequence>)list, s2, (String)key));
                    } else if (current instanceof SpectreConfigSpec.EnumValue) {
                        SpectreConfigSpec.EnumValue enumValue = (SpectreConfigSpec.EnumValue)current;
                        this.m_7085_((AbstractSelectionList.Entry)new EnumConfigEntry((Component)nameComponent, (List<FormattedCharSequence>)list, s2, (String)key, enumValue.getEnumClass()));
                    } else if (current instanceof SpectreConfigSpec.ConfigValue) {
                        Object object = EditConfigScreen.this.values.get(key);
                        if (object instanceof List) {
                            this.m_7085_((AbstractSelectionList.Entry)new ListConfigEntry((Component)nameComponent, (List<FormattedCharSequence>)list, s2, (String)key));
                        } else {
                            this.m_7085_((AbstractSelectionList.Entry)new StringConfigEntry((Component)nameComponent, (List<FormattedCharSequence>)list, s2, (String)key));
                        }
                    }
                } else if (obj instanceof AbstractConfig) {
                    AbstractConfig abstractConfig = (AbstractConfig)obj;
                    Object patt8728$temp = specValues.get(key);
                    if (patt8728$temp instanceof AbstractConfig) {
                        AbstractConfig abstractConfig1 = (AbstractConfig)patt8728$temp;
                        Object patt8824$temp = EditConfigScreen.this.values.get(key);
                        if (patt8824$temp instanceof AbstractConfig) {
                            AbstractConfig abstractConfig2 = (AbstractConfig)patt8824$temp;
                            MutableComponent nameComponent = Component.m_237113_((String)key);
                            this.m_7085_((AbstractSelectionList.Entry)new SectionEntry(new ArrayList<FormattedCharSequence>(), (Component)nameComponent, abstractConfig.valueMap(), abstractConfig1.valueMap(), abstractConfig2.valueMap()));
                        }
                    }
                }
            });
        }

        public int m_5759_() {
            return super.m_5759_() + 100;
        }

        protected int m_5756_() {
            return super.m_5756_() + 50;
        }

        public void m_88315_(@Nonnull GuiGraphics guiGraphics, int x, int y, float delta) {
            super.m_88315_(guiGraphics, x, y, delta);
            ConfigEntry configEntry = (ConfigEntry)this.m_168795_();
            if (configEntry != null && configEntry.tooltip != null) {
                EditConfigScreen.this.m_257959_(configEntry.tooltip);
            }
        }
    }

    public abstract class ConfigEntry
    extends ContainerObjectSelectionList.Entry<ConfigEntry> {
        private final List<FormattedCharSequence> label;
        @Nullable
        private final List<FormattedCharSequence> tooltip;
        protected final List<AbstractWidget> children = new ArrayList<AbstractWidget>();

        public ConfigEntry(List<FormattedCharSequence> pTooltip, Component pLabel) {
            this.tooltip = pTooltip;
            this.label = Objects.requireNonNull(((EditConfigScreen)EditConfigScreen.this).f_96541_).f_91062_.m_92923_((FormattedText)pLabel, 175);
        }

        @Nonnull
        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        @Nonnull
        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }

        protected void renderLabel(GuiGraphics guiGraphics, int y, int x) {
            if (this.label.size() == 1) {
                guiGraphics.m_280649_(Objects.requireNonNull(((EditConfigScreen)EditConfigScreen.this).f_96541_).f_91062_, this.label.get(0), x, y + 5, 0xFFFFFF, false);
            } else if (this.label.size() >= 2) {
                guiGraphics.m_280649_(Objects.requireNonNull(((EditConfigScreen)EditConfigScreen.this).f_96541_).f_91062_, this.label.get(0), x, y, 0xFFFFFF, false);
                guiGraphics.m_280649_(Objects.requireNonNull(((EditConfigScreen)EditConfigScreen.this).f_96541_).f_91062_, this.label.get(1), x, y + 10, 0xFFFFFF, false);
            }
        }
    }

    public class EnumConfigEntry<T extends Enum<T>>
    extends ConfigEntry {
        private final CycleButton<Object> checkbox;

        public EnumConfigEntry(Component pLabel, List<FormattedCharSequence> pTooltip, String p_101103_, String key, Class<T> clazz) {
            super(pTooltip, pLabel);
            this.checkbox = CycleButton.m_168894_(t -> {
                Enum en = EnumUtils.getEnum((Class)clazz, (String)t.toString());
                if (en != null) {
                    return Component.m_237113_((String)en.name());
                }
                return Component.m_237113_((String)"ERROR");
            }).m_168961_((Object[])clazz.getEnumConstants()).m_168948_((Object)EnumUtils.getEnum(clazz, (String)EditConfigScreen.this.values.get(key).toString())).m_168929_().m_168959_(cycle -> cycle.m_168904_().m_130946_("\n").m_130946_(p_101103_)).m_168936_(10, 5, 100, 20, pLabel, (button, value) -> EditConfigScreen.this.values.put(key, value.toString()));
            this.children.add(this.checkbox);
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int p_281471_, int y, int x, int offset, int p_283543_, int mouseX, int mouseY, boolean p_283227_, float delta) {
            this.renderLabel(guiGraphics, y, x);
            this.checkbox.m_252865_(x + offset - 101);
            this.checkbox.m_253211_(y);
            this.checkbox.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public class StringConfigEntry
    extends ConfigEntry {
        private final EditBox input;

        public StringConfigEntry(Component pLabel, List<FormattedCharSequence> pTooltip, String p_101177_, String key) {
            super(pTooltip, pLabel);
            this.input = new EditBox(Objects.requireNonNull(((EditConfigScreen)EditConfigScreen.this).f_96541_).f_91062_, 10, 5, 98, 20, (Component)pLabel.m_6881_().m_130946_("\n").m_130946_(p_101177_).m_130946_("\n"));
            this.input.m_94144_(EditConfigScreen.this.values.get(key).toString());
            this.input.m_94151_(newValue -> {
                Object obj = EditConfigScreen.this.spec.get(key);
                if (obj instanceof SpectreConfigSpec.ValueSpec) {
                    SpectreConfigSpec.ValueSpec valueSpec = (SpectreConfigSpec.ValueSpec)obj;
                    if (valueSpec.test(newValue)) {
                        this.input.m_94202_(0xE0E0E0);
                        EditConfigScreen.this.values.put(key, newValue);
                        EditConfigScreen.this.clearInvalid(key);
                    } else {
                        this.input.m_94202_(0xFF0000);
                        EditConfigScreen.this.markInvalid(key);
                    }
                }
            });
            this.children.add(this.input);
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int p_281471_, int y, int x, int offset, int p_283543_, int mouseX, int mouseY, boolean p_283227_, float delta) {
            this.renderLabel(guiGraphics, y, x);
            this.input.m_252865_(x + offset - 100);
            this.input.m_253211_(y);
            this.input.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public class DoubleConfigEntry
    extends ConfigEntry {
        private final EditBox input;

        public DoubleConfigEntry(Component pLabel, List<FormattedCharSequence> pTooltip, String p_101177_, String key) {
            super(pTooltip, pLabel);
            this.input = new EditBox(Objects.requireNonNull(((EditConfigScreen)EditConfigScreen.this).f_96541_).f_91062_, 10, 5, 98, 20, (Component)pLabel.m_6881_().m_130946_("\n").m_130946_(p_101177_).m_130946_("\n"));
            this.input.m_94144_(EditConfigScreen.this.values.get(key).toString());
            this.input.m_94151_(newValue -> {
                Object obj = EditConfigScreen.this.spec.get(key);
                if (obj instanceof SpectreConfigSpec.ValueSpec) {
                    SpectreConfigSpec.ValueSpec valueSpec = (SpectreConfigSpec.ValueSpec)obj;
                    boolean flag = true;
                    double i = 0.0;
                    try {
                        i = Double.parseDouble(newValue);
                    }
                    catch (NumberFormatException e) {
                        flag = false;
                    }
                    if (flag && valueSpec.test(i)) {
                        this.input.m_94202_(0xE0E0E0);
                        EditConfigScreen.this.values.put(key, i);
                        EditConfigScreen.this.clearInvalid(key);
                    } else {
                        this.input.m_94202_(0xFF0000);
                        EditConfigScreen.this.markInvalid(key);
                    }
                }
            });
            this.children.add(this.input);
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int p_281471_, int y, int x, int offset, int p_283543_, int mouseX, int mouseY, boolean p_283227_, float delta) {
            this.renderLabel(guiGraphics, y, x);
            this.input.m_252865_(x + offset - 100);
            this.input.m_253211_(y);
            this.input.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public class LongConfigEntry
    extends ConfigEntry {
        private final EditBox input;

        public LongConfigEntry(Component pLabel, List<FormattedCharSequence> pTooltip, String p_101177_, String key) {
            super(pTooltip, pLabel);
            this.input = new EditBox(Objects.requireNonNull(((EditConfigScreen)EditConfigScreen.this).f_96541_).f_91062_, 10, 5, 98, 20, (Component)pLabel.m_6881_().m_130946_("\n").m_130946_(p_101177_).m_130946_("\n"));
            this.input.m_94144_(EditConfigScreen.this.values.get(key).toString());
            this.input.m_94151_(newValue -> {
                Object obj = EditConfigScreen.this.spec.get(key);
                if (obj instanceof SpectreConfigSpec.ValueSpec) {
                    SpectreConfigSpec.ValueSpec valueSpec = (SpectreConfigSpec.ValueSpec)obj;
                    boolean flag = true;
                    long i = 0L;
                    try {
                        i = Long.parseLong(newValue);
                    }
                    catch (NumberFormatException e) {
                        flag = false;
                    }
                    if (flag && valueSpec.test(i)) {
                        this.input.m_94202_(0xE0E0E0);
                        EditConfigScreen.this.values.put(key, i);
                        EditConfigScreen.this.clearInvalid(key);
                    } else {
                        this.input.m_94202_(0xFF0000);
                        EditConfigScreen.this.markInvalid(key);
                    }
                }
            });
            this.children.add(this.input);
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int p_281471_, int y, int x, int offset, int p_283543_, int mouseX, int mouseY, boolean p_283227_, float delta) {
            this.renderLabel(guiGraphics, y, x);
            this.input.m_252865_(x + offset - 100);
            this.input.m_253211_(y);
            this.input.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public class IntegerConfigEntry
    extends ConfigEntry {
        private final EditBox input;

        public IntegerConfigEntry(Component pLabel, List<FormattedCharSequence> pTooltip, String p_101177_, String key) {
            super(pTooltip, pLabel);
            this.input = new EditBox(Objects.requireNonNull(((EditConfigScreen)EditConfigScreen.this).f_96541_).f_91062_, 10, 5, 98, 20, (Component)pLabel.m_6881_().m_130946_("\n").m_130946_(p_101177_).m_130946_("\n"));
            this.input.m_94144_(EditConfigScreen.this.values.get(key).toString());
            this.input.m_94151_(newValue -> {
                Object obj = EditConfigScreen.this.spec.get(key);
                if (obj instanceof SpectreConfigSpec.ValueSpec) {
                    SpectreConfigSpec.ValueSpec valueSpec = (SpectreConfigSpec.ValueSpec)obj;
                    boolean flag = true;
                    int i = 0;
                    try {
                        i = Integer.parseInt(newValue);
                    }
                    catch (NumberFormatException e) {
                        flag = false;
                    }
                    if (flag && valueSpec.test(i)) {
                        this.input.m_94202_(0xE0E0E0);
                        EditConfigScreen.this.values.put(key, i);
                        EditConfigScreen.this.clearInvalid(key);
                    } else {
                        this.input.m_94202_(0xFF0000);
                        EditConfigScreen.this.markInvalid(key);
                    }
                }
            });
            this.children.add(this.input);
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int p_281471_, int y, int x, int offset, int p_283543_, int mouseX, int mouseY, boolean p_283227_, float delta) {
            this.renderLabel(guiGraphics, y, x);
            this.input.m_252865_(x + offset - 100);
            this.input.m_253211_(y);
            this.input.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public class BooleanConfigEntry
    extends ConfigEntry {
        private final CycleButton<Boolean> checkbox;

        public BooleanConfigEntry(Component pLabel, List<FormattedCharSequence> pTooltip, String p_101103_, String key) {
            super(pTooltip, pLabel);
            this.checkbox = CycleButton.m_168916_((boolean)((Boolean)EditConfigScreen.this.values.get(key))).m_168929_().m_168959_(cycle -> cycle.m_168904_().m_130946_("\n").m_130946_(p_101103_)).m_168936_(10, 5, 100, 20, pLabel, (button, value) -> EditConfigScreen.this.values.put(key, value));
            this.children.add(this.checkbox);
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int p_281471_, int y, int x, int offset, int p_283543_, int mouseX, int mouseY, boolean p_283227_, float delta) {
            this.renderLabel(guiGraphics, y, x);
            this.checkbox.m_252865_(x + offset - 101);
            this.checkbox.m_253211_(y);
            this.checkbox.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public class ListConfigEntry
    extends ConfigEntry {
        private final Button button;

        public ListConfigEntry(Component pLabel, List<FormattedCharSequence> pTooltip, String p_101103_, String key) {
            super(pTooltip, pLabel);
            List list = (List)EditConfigScreen.this.values.get(key);
            String result = String.join((CharSequence)",", list.stream().map(Object::toString).toList());
            this.button = Button.m_253074_((Component)Component.m_237113_((String)result), b -> {
                Object patt11530$temp = EditConfigScreen.this.spec.get(key);
                if (patt11530$temp instanceof SpectreConfigSpec.ValueSpec) {
                    SpectreConfigSpec.ValueSpec valueSpec = (SpectreConfigSpec.ValueSpec)patt11530$temp;
                    ListConfigScreen listConfigScreen = new ListConfigScreen(EditConfigScreen.this.f_96539_, EditConfigScreen.this.subtitle, list, EditConfigScreen.this, valueSpec::test, l -> {
                        list.clear();
                        list.addAll(l);
                    });
                    Minecraft.m_91087_().m_91152_((Screen)listConfigScreen);
                }
            }).m_252987_(10, 5, 100, 20).m_253136_();
            this.children.add(this.button);
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int p_281471_, int y, int x, int offset, int p_283543_, int mouseX, int mouseY, boolean p_283227_, float delta) {
            this.renderLabel(guiGraphics, y, x);
            this.button.m_252865_(x + offset - 101);
            this.button.m_253211_(y);
            this.button.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public class SectionEntry
    extends ConfigEntry {
        private final Button button;

        public SectionEntry(List<FormattedCharSequence> pTooltip, Component pLabel, Map<String, Object> spec, Map<String, Object> specValues, Map<String, Object> values) {
            super(pTooltip, pLabel);
            this.button = Button.m_253074_((Component)pLabel, b -> {
                Consumer<Map<String, Object>> consumer = values::putAll;
                EditConfigScreen newScreen = new EditConfigScreen(EditConfigScreen.this.f_96539_, pLabel, spec, specValues, values, EditConfigScreen.this, consumer);
                Minecraft.m_91087_().m_91152_((Screen)newScreen);
            }).m_253136_();
            this.children.add(this.button);
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int p_281471_, int y, int x, int offset, int p_283543_, int mouseX, int mouseY, boolean p_283227_, float delta) {
            this.button.m_252865_(x);
            this.button.m_253211_(y);
            this.button.m_93674_(EditConfigScreen.this.configList.m_5759_() - 5);
            this.button.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
    }
}

