/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.spectrelib.config;

import com.illusivesoulworks.spectrelib.config.SpectreConfigTracker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;

public class SpectreConfigNetwork {
    private static final List<FriendlyByteBuf> receivedBuffers = new ArrayList<FriendlyByteBuf>();

    public static List<FriendlyByteBuf> getConfigSync() {
        Map<String, byte[]> configData = SpectreConfigTracker.INSTANCE.getConfigSync();
        if (configData.isEmpty()) {
            return new ArrayList<FriendlyByteBuf>();
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_236831_(configData, FriendlyByteBuf::m_130070_, FriendlyByteBuf::m_130087_);
        return PacketSplitter.split(buf);
    }

    public static void handleConfigSync(FriendlyByteBuf buffer) {
        if (!Minecraft.m_91087_().m_91090_()) {
            if (buffer.isReadable()) {
                buffer.retain();
                receivedBuffers.add(buffer);
                return;
            }
            FriendlyByteBuf full = new FriendlyByteBuf(Unpooled.wrappedBuffer((ByteBuf[])((ByteBuf[])receivedBuffers.toArray(new FriendlyByteBuf[0]))));
            Map configs = full.m_236847_(FriendlyByteBuf::m_130277_, FriendlyByteBuf::m_130052_);
            configs.forEach(SpectreConfigNetwork::acceptSyncedConfigs);
            full.release();
            for (FriendlyByteBuf receivedBuffer : receivedBuffers) {
                receivedBuffer.release();
            }
            receivedBuffers.clear();
        }
    }

    public static void acceptSyncedConfigs(String fileName, byte[] data) {
        if (!Minecraft.m_91087_().m_91090_()) {
            SpectreConfigTracker.INSTANCE.acceptSyncedConfigs(fileName, data);
        }
    }

    private static class PacketSplitter {
        private static final int PART_SIZE = 0x100000;

        private PacketSplitter() {
        }

        public static List<FriendlyByteBuf> split(FriendlyByteBuf buf) {
            ArrayList<FriendlyByteBuf> result = new ArrayList<FriendlyByteBuf>();
            while (buf.isReadable(0x100000)) {
                result.add(new FriendlyByteBuf(buf.readBytes(0x100000)));
            }
            if (buf.isReadable()) {
                result.add(buf);
            }
            return result;
        }
    }
}

