/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.spectrelib;

import com.illusivesoulworks.spectrelib.SpectreClientForgeMod;
import com.illusivesoulworks.spectrelib.config.SpectreConfigEvents;
import com.illusivesoulworks.spectrelib.config.SpectreConfigNetwork;
import com.illusivesoulworks.spectrelib.network.ConfigSyncPacket;
import com.illusivesoulworks.spectrelib.network.SpectreForgePacketHandler;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.NewRegistryEvent;

@Mod(value="spectrelib")
public class SpectreForgeMod {
    public SpectreForgeMod() {
        MinecraftForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopped);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::loadConfigs);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
    }

    private void loadConfigs(NewRegistryEvent evt) {
        SpectreConfigEvents.onLoadGlobal();
    }

    private void setup(FMLCommonSetupEvent evt) {
        SpectreForgePacketHandler.setup();
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        SpectreClientForgeMod.setup();
    }

    private void onServerAboutToStart(ServerAboutToStartEvent evt) {
        SpectreConfigEvents.onLoadServer(evt.getServer());
    }

    private void onServerStopped(ServerStoppedEvent evt) {
        SpectreConfigEvents.onUnloadServer();
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List<FriendlyByteBuf> configData = SpectreConfigNetwork.getConfigSync();
            if (!configData.isEmpty()) {
                for (FriendlyByteBuf configDatum : configData) {
                    SpectreForgePacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ConfigSyncPacket(configDatum));
                }
                SpectreForgePacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ConfigSyncPacket(new FriendlyByteBuf(Unpooled.buffer())));
            }
        }
    }
}

