/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.spectrelib;

import com.illusivesoulworks.spectrelib.SpectreConstants;
import com.illusivesoulworks.spectrelib.config.SpectreConfig;
import com.illusivesoulworks.spectrelib.config.SpectreConfigEvents;
import com.illusivesoulworks.spectrelib.config.SpectreConfigTracker;
import com.illusivesoulworks.spectrelib.config.client.screen.ModConfigSelectScreen;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;

public class SpectreClientForgeMod {
    public static void setup() {
        MinecraftForge.EVENT_BUS.addListener(SpectreClientForgeMod::onPlayerLoggedOut);
        ModList.get().forEachModContainer((modId, modContainer) -> {
            Map<String, Map<SpectreConfig.Type, Set<SpectreConfig>>> configs = SpectreConfigTracker.INSTANCE.getConfigsByMod();
            Map<SpectreConfig.Type, Set<SpectreConfig>> modConfigs = configs.get(modId);
            if (modConfigs != null && !modConfigs.isEmpty()) {
                int count = modConfigs.values().stream().mapToInt(Set::size).sum();
                SpectreConstants.LOG.info("Registering config screens for mod {} with {} config(s)", modId, (Object)count);
                String displayName = modContainer.getModInfo().getDisplayName();
                modContainer.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ModConfigSelectScreen(modConfigs, (Screen)screen, (Component)Component.m_237113_((String)displayName))));
            }
        });
    }

    private static void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut evt) {
        if (!Minecraft.m_91087_().m_91090_()) {
            SpectreConfigEvents.onUnloadServer();
        }
    }
}

