/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.managers.journal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.client.gui.screen.journal.JournalEntryRenderers;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.managers.SkiesSyncedDataManager;
import com.legacy.blue_skies.data.objects.journal.JournalEntry;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.ItemLike;

public class JournalEntryManager
extends SkiesSyncedDataManager<ResourceLocation, JournalEntry, JournalEntryManager> {
    public JournalEntryManager() {
        super(JournalEntry.getDirectory());
    }

    @Override
    public JournalEntryManager newInstance() {
        return new JournalEntryManager();
    }

    @Override
    public Pair<CompoundTag, CompoundTag> entryToNbt(ResourceLocation key, JournalEntry value) {
        CompoundTag keyNbt = new CompoundTag();
        keyNbt.m_128359_("0", key.toString());
        CompoundTag valueNbt = (CompoundTag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, (JsonElement)value.toJson());
        return Pair.of((Object)keyNbt, (Object)valueNbt);
    }

    @Override
    public Pair<ResourceLocation, JournalEntry> entryFromNbt(CompoundTag keyNbt, CompoundTag valueNbt) {
        ResourceLocation key = new ResourceLocation(keyNbt.m_128461_("0"));
        JsonObject json = ((JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)valueNbt)).getAsJsonObject();
        try {
            return Pair.of((Object)key, (Object)((JournalEntry)this.parseJson(json, key).getSecond()));
        }
        catch (SkiesDataManager.RegistryObjectNotFoundException e) {
            throw new IllegalArgumentException("Failed to get registry object");
        }
    }

    @Override
    protected Pair<ResourceLocation, JournalEntry> parseJson(JsonObject json, ResourceLocation name) throws SkiesDataManager.RegistryObjectNotFoundException {
        String title = GsonHelper.m_13906_((JsonObject)json, (String)"title");
        ArrayList<JournalEntry.Lore> lores = new ArrayList<JournalEntry.Lore>();
        JsonArray loreArray = GsonHelper.m_13933_((JsonObject)json, (String)"lores");
        for (JsonElement e : loreArray) {
            JsonObject loreJson = e.getAsJsonObject();
            String text = GsonHelper.m_13906_((JsonObject)loreJson, (String)"text");
            ResourceLocation requirement = loreJson.has("requirement") ? new ResourceLocation(GsonHelper.m_13906_((JsonObject)loreJson, (String)"requirement")) : null;
            JournalEntryRenderers.IRenderable display = null;
            if (loreJson.has("display")) {
                JsonObject displayJson = GsonHelper.m_13930_((JsonObject)loreJson, (String)"display");
                String displayType = GsonHelper.m_13906_((JsonObject)displayJson, (String)"type");
                JsonObject displayData = GsonHelper.m_13930_((JsonObject)displayJson, (String)"display");
                if (displayType.equals("entity")) {
                    int scale = GsonHelper.m_13927_((JsonObject)displayData, (String)"scale");
                    int yOffset = GsonHelper.m_13927_((JsonObject)displayData, (String)"y_offset");
                    display = new JournalEntryRenderers.EntityDisplay(JournalEntryManager.parseEntity(displayData, "entity"), scale, yOffset);
                } else if (displayType.equals("image")) {
                    display = new JournalEntryRenderers.ImageDisplay(new ResourceLocation(GsonHelper.m_13906_((JsonObject)displayData, (String)"image")));
                } else {
                    throw new IllegalArgumentException("display type invalid");
                }
            }
            lores.add(new JournalEntry.Lore(text, requirement, display));
        }
        JournalEntryRenderers.IRenderable icon = null;
        JsonObject iconJson = GsonHelper.m_13930_((JsonObject)json, (String)"icon");
        String iconType = GsonHelper.m_13906_((JsonObject)iconJson, (String)"type");
        JsonObject iconData = GsonHelper.m_13930_((JsonObject)iconJson, (String)"icon");
        if (iconType.equals("item")) {
            icon = new JournalEntryRenderers.ItemIcon((ItemLike)JournalEntryManager.parseItem(iconData, "item"));
        } else if (iconType.equals("texture")) {
            icon = new JournalEntryRenderers.TextureIcon(new ResourceLocation(GsonHelper.m_13906_((JsonObject)iconData, (String)"texture")));
        } else {
            throw new IllegalArgumentException("icon type invalid");
        }
        ResourceLocation section = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"section"));
        ResourceLocation requirement = json.has("requirement") ? new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"requirement")) : null;
        int priority = GsonHelper.m_13824_((JsonObject)json, (String)"priority", (int)0);
        return Pair.of((Object)name, (Object)new JournalEntry(title, lores, icon, section, requirement, priority));
    }
}

