/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.sources;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.EnergizerDisplaySourceEntity;
import it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.ReactorDisplaySourceEntity;
import it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.TurbineDisplaySourceEntity;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.level.block.entity.BlockEntity;

@FunctionalInterface
public interface IDisplayLinkContextAdapter<Part> {
    public static final IDisplayLinkContextAdapter<ReactorDisplaySourceEntity> REACTOR = () -> ReactorDisplaySourceEntity.class;
    public static final IDisplayLinkContextAdapter<TurbineDisplaySourceEntity> TURBINE = () -> TurbineDisplaySourceEntity.class;
    public static final IDisplayLinkContextAdapter<EnergizerDisplaySourceEntity> ENERGIZER = () -> EnergizerDisplaySourceEntity.class;

    public Class<Part> getMultiblockPartClass();

    default public Optional<Part> getMultiblockPart(DisplayLinkContext context) {
        BlockEntity be;
        Class<Part> clazz = this.getMultiblockPartClass();
        if (clazz.isInstance(be = context.getSourceBlockEntity())) {
            return Optional.of(clazz.cast(be));
        }
        return Optional.empty();
    }

    default public <R> R invoke(DisplayLinkContext context, Function<Part, R> mapper, R defaultValue) {
        return this.getMultiblockPart(context).map(mapper).orElse(defaultValue);
    }

    default public <R> R invoke(DisplayLinkContext context, DisplayTargetStats stats, BiFunction<Part, DisplayTargetStats, R> mapper, R defaultValue) {
        return (R)this.getMultiblockPart(context).map(part -> mapper.apply(part, stats)).orElse(defaultValue);
    }
}

