/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.extremereactors.compat.create.gamecontent.CreateContent;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TurbineDisplaySourceEntity
extends AbstractTurbineEntity {
    public TurbineDisplaySourceEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)CreateContent.TileEntityTypes.TURBINE_DISPLAYSOURCE.get(), position, blockState);
    }

    public MutableComponent getActivationStatus(DisplayTargetStats stats) {
        return Component.m_237115_((String)(this.isTurbineActive() ? "gui.bigreactors.turbine.active" : "gui.bigreactors.turbine.inactive"));
    }

    public float getEnergyStoredPercentage() {
        return ((Float)this.evalOnController(controller -> Float.valueOf((float)controller.getEnergyStoredPercentage()), Float.valueOf(0.0f))).floatValue();
    }

    public MutableComponent getEnergyStored(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> {
            EnergySystem energySystem = controller.getOutputEnergySystem();
            double energyStored = controller.getEnergyStored(energySystem).doubleValue();
            return CodeHelper.formatAsHumanReadableNumber((double)energyStored, (String)energySystem.getUnit());
        }, "?")));
    }

    public MutableComponent getVaporStored(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> CodeHelper.formatAsMillibuckets((float)controller.getVaporAmount()), "?")));
    }

    public MutableComponent getCoolantStored(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> CodeHelper.formatAsMillibuckets((float)controller.getCoolantAmount()), "?")));
    }

    public MutableComponent getEnergyGenerated(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> {
            EnergySystem energySystem = controller.getOutputEnergySystem();
            double energyOutput = controller.getEnergyGeneratedLastTick();
            return CodeHelper.formatAsHumanReadableNumber((double)energyOutput, (String)energySystem.getUnit()) + "/t";
        }, "?")));
    }

    public MutableComponent getMaxIntakeRate(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> String.format("%d mB/t", controller.getMaxIntakeRate()), "?")));
    }

    public MutableComponent getRotorSpeed(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> String.format("%.2f RPM", Float.valueOf(controller.getRotorSpeed())), "?")));
    }

    public MutableComponent getVentSetting(DisplayTargetStats stats) {
        return (MutableComponent)this.evalOnControllerOrGet(this::getVentSettingText, () -> Component.m_237113_((String)"?"));
    }

    public MutableComponent getInductorMode(DisplayTargetStats stats) {
        return (MutableComponent)this.evalOnControllerOrGet(this::getInductorMode, () -> Component.m_237113_((String)"?"));
    }

    public MutableComponent getRotorBladesCount(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> String.format("%d", controller.getRotorBladesCount()), "?")));
    }

    public MutableComponent getRotorEfficiency(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> String.format("%.1f%%", Float.valueOf(Mth.m_14036_((float)controller.getRotorEfficiencyLastTick(), (float)0.0f, (float)1.0f) * 100.0f)), "?")));
    }

    public List<List<MutableComponent>> getTurbineStatus(DisplayTargetStats stats) {
        return (List)this.evalOnController(this::getTurbineStatus, Collections.emptyList());
    }

    private List<List<MutableComponent>> getTurbineStatus(MultiblockTurbine controller) {
        ObjectArrayList lines = new ObjectArrayList(9);
        lines.add(List.of(Component.m_237115_((String)"er2create.display_source.turbine.turbine_status")));
        lines.add(DisplaySource.EMPTY);
        EnergySystem energySystem = controller.getOutputEnergySystem();
        double energyOutput = controller.getEnergyGeneratedLastTick();
        WideAmount energyStored = controller.getEnergyStored(energySystem);
        double energyStoredPercentage = controller.getEnergyStoredPercentage();
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.turbine.turbine_status.value1", (Object[])new Object[]{CodeHelper.formatAsHumanReadableNumber((double)energyOutput, (String)energySystem.getUnit()) + "/t"})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.turbine.turbine_status.value2", (Object[])new Object[]{CodeHelper.formatAsHumanReadableNumber((double)energyStored.doubleValue(), (String)energySystem.getUnit())})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.turbine.turbine_status.value3", (Object[])new Object[]{String.format("%.2f", energyStoredPercentage * 100.0)})));
        lines.add(DisplaySource.EMPTY);
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.turbine.turbine_status.value4", (Object[])new Object[]{CodeHelper.formatAsMillibuckets((float)controller.getVaporAmount())})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.turbine.turbine_status.value5", (Object[])new Object[]{CodeHelper.formatAsMillibuckets((float)controller.getCoolantAmount())})));
        lines.add(List.of(Component.m_237115_((String)"er2create.display_source.turbine.turbine_status.value6").m_7220_((Component)this.getVentSettingText(controller))));
        lines.add(DisplaySource.EMPTY);
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.turbine.turbine_status.value7", (Object[])new Object[]{String.format("%.2f", Float.valueOf(controller.getRotorSpeed()))})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.turbine.turbine_status.value8", (Object[])new Object[]{String.format("%d", controller.getMaxIntakeRate())})));
        lines.add(List.of(Component.m_237115_((String)"er2create.display_source.turbine.turbine_status.value9").m_7220_((Component)this.getInductorMode(controller))));
        lines.add(DisplaySource.EMPTY);
        lines.add(List.of(Component.m_237115_((String)(controller.isMachineActive() ? "gui.bigreactors.turbine.active" : "gui.bigreactors.turbine.inactive"))));
        return lines;
    }

    private MutableComponent getVentSettingText(MultiblockTurbine controller) {
        return switch (controller.getVentSetting()) {
            default -> throw new IncompatibleClassChangeError();
            case VentSetting.VentAll -> Component.m_237115_((String)"gui.bigreactors.turbine.controller.vent.all.line1");
            case VentSetting.VentOverflow -> Component.m_237115_((String)"gui.bigreactors.turbine.controller.vent.overflow.line1");
            case VentSetting.DoNotVent -> Component.m_237115_((String)"gui.bigreactors.turbine.controller.vent.donotvent.line1");
        };
    }

    private MutableComponent getInductorMode(MultiblockTurbine controller) {
        return Component.m_237115_((String)(controller.isInductorEngaged() ? "gui.bigreactors.turbine.controller.inductor.mode.engaged" : "gui.bigreactors.turbine.controller.inductor.mode.disengaged"));
    }
}

