/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.extremereactors.compat.create.gamecontent.CreateContent;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ReactorDisplaySourceEntity
extends AbstractReactorEntity {
    public ReactorDisplaySourceEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)CreateContent.TileEntityTypes.REACTOR_DISPLAYSOURCE.get(), position, blockState);
    }

    public MutableComponent getActivationStatus(DisplayTargetStats stats) {
        return Component.m_237115_((String)(this.isReactorActive() ? "gui.bigreactors.reactor.active" : "gui.bigreactors.reactor.inactive"));
    }

    public float getEnergyStoredPercentage() {
        return ((Float)this.evalOnController(controller -> Float.valueOf(controller.getOperationalMode().isPassive() ? (float)controller.getEnergyStoredPercentage() : 0.0f), Float.valueOf(0.0f))).floatValue();
    }

    public MutableComponent getEnergyStored(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> {
            if (controller.getOperationalMode().isActive()) {
                return "0";
            }
            EnergySystem energySystem = controller.getOutputEnergySystem();
            double energyStored = controller.getEnergyStored(energySystem).doubleValue();
            return CodeHelper.formatAsHumanReadableNumber((double)energyStored, (String)energySystem.getUnit());
        }, "?")));
    }

    public MutableComponent getVaporStored(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> {
            if (controller.getOperationalMode().isPassive()) {
                return "0";
            }
            return CodeHelper.formatAsMillibuckets((float)controller.getVaporAmount());
        }, "?")));
    }

    public MutableComponent getCoolantStored(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> {
            if (controller.getOperationalMode().isPassive()) {
                return "0";
            }
            return CodeHelper.formatAsMillibuckets((float)controller.getCoolantAmount());
        }, "?")));
    }

    public float getFuelPercentage() {
        return ((Float)this.evalOnController(controller -> Float.valueOf((float)controller.getFuelAmount() / (float)controller.getCapacity()), Float.valueOf(0.0f))).floatValue();
    }

    public MutableComponent getFuelAmount(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> CodeHelper.formatAsMillibuckets((float)controller.getFuelAmount()), "?")));
    }

    public float getWastePercentage() {
        return ((Float)this.evalOnController(controller -> Float.valueOf((float)controller.getWasteAmount() / (float)controller.getCapacity()), Float.valueOf(0.0f))).floatValue();
    }

    public MutableComponent getWasteAmount(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> CodeHelper.formatAsMillibuckets((float)controller.getWasteAmount()), "?")));
    }

    public MutableComponent getCoreHeatTemperature(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> String.format("%.0f C", controller.getFuelHeatValue().getAsDouble()), "?")));
    }

    public MutableComponent getCasingHeatTemperature(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> String.format("%.0f C", controller.getReactorHeatValue().getAsDouble()), "?")));
    }

    public MutableComponent getFuelBurnupRate(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> CodeHelper.formatAsMillibuckets((float)controller.getUiStats().getFuelConsumedLastTick()) + "/t", "?")));
    }

    public MutableComponent getEnergyGenerated(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> {
            if (controller.getOperationalMode().isActive()) {
                return "0";
            }
            EnergySystem energySystem = controller.getOutputEnergySystem();
            double energyOutput = controller.getUiStats().getAmountGeneratedLastTick();
            return CodeHelper.formatAsHumanReadableNumber((double)energyOutput, (String)energySystem.getUnit()) + "/t";
        }, "?")));
    }

    public MutableComponent getVaporGenerated(DisplayTargetStats stats) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> {
            if (controller.getOperationalMode().isPassive()) {
                return "0";
            }
            return CodeHelper.formatAsHumanReadableNumber((double)(controller.getUiStats().getAmountGeneratedLastTick() / 1000.0), (String)"B/t");
        }, "?")));
    }

    public List<List<MutableComponent>> getReactorStatus(DisplayTargetStats stats) {
        return (List)this.evalOnController(this::getReactorStatus, Collections.emptyList());
    }

    public List<List<MutableComponent>> getCoreFuelStatus(DisplayTargetStats stats) {
        return (List)this.evalOnController(this::getCoreFuelStatus, Collections.emptyList());
    }

    private List<List<MutableComponent>> getReactorStatus(MultiblockReactor controller) {
        ObjectArrayList lines = new ObjectArrayList(9);
        lines.add(List.of(Component.m_237115_((String)"er2create.display_source.reactor.reactor_status")));
        lines.add(DisplaySource.EMPTY);
        if (controller.getOperationalMode().isPassive()) {
            EnergySystem energySystem = controller.getOutputEnergySystem();
            double energyOutput = controller.getUiStats().getAmountGeneratedLastTick();
            WideAmount energyStored = controller.getEnergyStored(energySystem);
            double energyStoredPercentage = controller.getEnergyStoredPercentage();
            lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.reactor_status.value1.passive", (Object[])new Object[]{CodeHelper.formatAsHumanReadableNumber((double)energyOutput, (String)energySystem.getUnit()) + "/t"})));
            lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.reactor_status.value2.passive", (Object[])new Object[]{CodeHelper.formatAsHumanReadableNumber((double)energyStored.doubleValue(), (String)energySystem.getUnit())})));
            lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.reactor_status.value3.passive", (Object[])new Object[]{String.format("%.2f", energyStoredPercentage * 100.0)})));
        } else {
            double vaporOutput = controller.getUiStats().getAmountGeneratedLastTick();
            int vaporAmount = controller.getVaporAmount();
            int coolantAmount = controller.getCoolantAmount();
            lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.reactor_status.value1.active", (Object[])new Object[]{CodeHelper.formatAsHumanReadableNumber((double)(vaporOutput / 1000.0), (String)"B/t")})));
            lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.reactor_status.value2.active", (Object[])new Object[]{CodeHelper.formatAsMillibuckets((float)vaporAmount)})));
            lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.reactor_status.value3.active", (Object[])new Object[]{CodeHelper.formatAsMillibuckets((float)coolantAmount)})));
        }
        lines.add(DisplaySource.EMPTY);
        float fuelConsumed = controller.getUiStats().getFuelConsumedLastTick();
        double fuelHeat = controller.getFuelHeatValue().getAsDouble();
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.reactor_status.value4", (Object[])new Object[]{CodeHelper.formatAsMillibuckets((float)fuelConsumed) + "/t"})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.reactor_status.value5", (Object[])new Object[]{String.format("%.0f C", fuelHeat)})));
        lines.add(DisplaySource.EMPTY);
        lines.add(List.of(Component.m_237115_((String)(controller.isMachineActive() ? "gui.bigreactors.reactor.active" : "gui.bigreactors.reactor.inactive"))));
        return lines;
    }

    private List<List<MutableComponent>> getCoreFuelStatus(MultiblockReactor controller) {
        ObjectArrayList lines = new ObjectArrayList(9);
        lines.add(List.of(Component.m_237115_((String)"er2create.display_source.reactor.core_fuel_status")));
        float capacity = controller.getCapacity();
        int fuelAmount = controller.getFuelAmount();
        int wasteAmount = controller.getWasteAmount();
        float reactantsAmount = fuelAmount + wasteAmount;
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.core_fuel_status.value1", (Object[])new Object[]{String.format("%.2f", Float.valueOf(reactantsAmount / capacity * 100.0f))})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.core_fuel_status.value2", (Object[])new Object[]{String.format("%.2f", Float.valueOf((float)wasteAmount / reactantsAmount * 100.0f))})));
        lines.add(DisplaySource.EMPTY);
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.core_fuel_status.value3", (Object[])new Object[]{controller.getFuelRodsCount()})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.core_fuel_status.value4", (Object[])new Object[]{CodeHelper.formatAsMillibuckets((float)capacity)})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.core_fuel_status.value5", (Object[])new Object[]{CodeHelper.formatAsMillibuckets((float)fuelAmount)})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.core_fuel_status.value6", (Object[])new Object[]{CodeHelper.formatAsMillibuckets((float)wasteAmount)})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.reactor.core_fuel_status.value7", (Object[])new Object[]{CodeHelper.formatAsMillibuckets((float)capacity)})));
        return lines;
    }
}

