/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.extremereactors.compat.create.gamecontent.CreateContent;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractEnergyGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.MultiBlockEnergizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part.AbstractEnergizerEntity;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EnergizerDisplaySourceEntity
extends AbstractEnergizerEntity {
    public EnergizerDisplaySourceEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)CreateContent.TileEntityTypes.ENERGIZER_DISPLAYSOURCE.get(), position, blockState);
    }

    protected int getUpdatedModelVariantIndex() {
        return this.isMachineAssembled() ? 1 : 0;
    }

    public MutableComponent getActivationStatus(DisplayTargetStats stats) {
        return Component.m_237115_((String)(this.isEnergizerActive() ? "gui.bigreactors.energizer.active" : "gui.bigreactors.energizer.inactive"));
    }

    public float getEnergyStoredPercentage() {
        return ((Float)this.evalOnController(controller -> Float.valueOf((float)controller.getEnergyStoredPercentage()), Float.valueOf(0.0f))).floatValue();
    }

    public MutableComponent getEnergyStored(DisplayTargetStats stats) {
        return this.getEnergyReadout(AbstractEnergyGeneratorMultiblockController::getEnergyStored);
    }

    public MutableComponent getEnergyCapacity(DisplayTargetStats stats) {
        return this.getEnergyReadout(AbstractEnergyGeneratorMultiblockController::getCapacity);
    }

    public MutableComponent getEnergyInsertedLastTick(DisplayTargetStats stats) {
        return this.getEnergyReadout(MultiBlockEnergizer::getEnergyInsertedLastTick);
    }

    public MutableComponent getEnergyExtractedLastTick(DisplayTargetStats stats) {
        return this.getEnergyReadout(MultiBlockEnergizer::getEnergyExtractedLastTick);
    }

    public MutableComponent getEnergyIoRate(DisplayTargetStats stats) {
        return this.getEnergyReadout(MultiBlockEnergizer::getEnergyIoRate);
    }

    public List<List<MutableComponent>> getEnergizerStatus(DisplayTargetStats stats) {
        return (List)this.evalOnController(this::getEnergizerStatus, Collections.emptyList());
    }

    private MutableComponent getEnergyReadout(BiFunction<@NotNull MultiBlockEnergizer, @NotNull EnergySystem, @NotNull WideAmount> getter) {
        return Component.m_237113_((String)((String)this.evalOnController(controller -> {
            EnergySystem energySystem = controller.getOutputEnergySystem();
            WideAmount energy = (WideAmount)getter.apply((MultiBlockEnergizer)controller, energySystem);
            return energySystem.asHumanReadableNumber(energy);
        }, "?")));
    }

    private List<List<MutableComponent>> getEnergizerStatus(MultiBlockEnergizer controller) {
        ObjectArrayList lines = new ObjectArrayList(10);
        lines.add(List.of(Component.m_237115_((String)"er2create.display_source.energizer.energizer_status")));
        lines.add(DisplaySource.EMPTY);
        EnergySystem energySystem = controller.getOutputEnergySystem();
        WideAmount capacity = controller.getCapacity(energySystem);
        WideAmount stored = controller.getEnergyStored(energySystem);
        WideAmount io = controller.getEnergyIoRate(energySystem);
        WideAmount inserted = controller.getEnergyInsertedLastTick(energySystem);
        WideAmount extracted = controller.getEnergyExtractedLastTick(energySystem);
        double filled = controller.getEnergyStoredPercentage();
        double energyStoredPercentage = controller.getEnergyStoredPercentage();
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.energizer.energizer_status.value1", (Object[])new Object[]{energySystem.asHumanReadableNumber(stored)})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.energizer.energizer_status.value2", (Object[])new Object[]{energySystem.asHumanReadableNumber(io)})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.energizer.energizer_status.value3", (Object[])new Object[]{energySystem.asHumanReadableNumber(capacity)})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.energizer.energizer_status.value4", (Object[])new Object[]{String.format("%.2f", energyStoredPercentage * 100.0)})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.energizer.energizer_status.value5", (Object[])new Object[]{energySystem.asHumanReadableNumber(inserted)})));
        lines.add(List.of(Component.m_237110_((String)"er2create.display_source.energizer.energizer_status.value6", (Object[])new Object[]{energySystem.asHumanReadableNumber(extracted)})));
        lines.add(DisplaySource.EMPTY);
        lines.add(List.of(Component.m_237115_((String)(controller.isMachineActive() ? "gui.bigreactors.energizer.active" : "gui.bigreactors.energizer.inactive"))));
        return lines;
    }
}

