/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.compat.create.gamecontent;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.registry.registrate.SimpleBuilder;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.foundation.data.CreateRegistrate;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.compat.create.gamecontent.CreateEnergizerPartType;
import it.zerono.mods.extremereactors.compat.create.gamecontent.CreateReactorPartType;
import it.zerono.mods.extremereactors.compat.create.gamecontent.CreateTurbinePartType;
import it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.EnergizerDisplaySourceEntity;
import it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.ReactorDisplaySourceEntity;
import it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.TurbineDisplaySourceEntity;
import it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.sources.IDisplayLinkContextAdapter;
import it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.sources.MultiblockMultiLineDisplaySource;
import it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.sources.MultiblockPercentOrProgressBarDisplaySource;
import it.zerono.mods.extremereactors.compat.create.gamecontent.displayLink.sources.MultiblockSingleLineDisplaySource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.IEnergizerPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.MultiBlockEnergizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.variant.EnergizerVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.base.multiblock.part.GenericDeviceBlock;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class CreateContent {
    public static void initialize() {
        IEventBus bus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        Blocks.initialize(bus);
        DisplaySources.initialize(bus);
        Items.initialize(bus);
        TileEntityTypes.initialize(bus);
        CreativeTabs.initialize(bus);
    }

    private static <T> DeferredRegister<T> defer(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)"er2create");
    }

    private static <T> DeferredRegister<T> defer(ResourceKey<? extends Registry<T>> key) {
        return DeferredRegister.create(key, (String)"er2create");
    }

    private CreateContent() {
    }

    public static final class Blocks {
        private static final DeferredRegister<Block> BLOCKS = CreateContent.defer(ForgeRegistries.BLOCKS);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, IReactorPartType>> REACTOR_DISPLAYSOURCE_BASIC = Blocks.registerReactorBlock("basic_reactordisplaysource", ReactorVariant.Basic, CreateReactorPartType.DisplaySource);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, IReactorPartType>> REACTOR_DISPLAYSOURCE_REINFORCED = Blocks.registerReactorBlock("reinforced_reactordisplaysource", ReactorVariant.Reinforced, CreateReactorPartType.DisplaySource);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, ITurbinePartType>> TURBINE_DISPLAYSOURCE_BASIC = Blocks.registerTurbineBlock("basic_turbinedisplaysource", TurbineVariant.Basic, CreateTurbinePartType.DisplaySource);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, ITurbinePartType>> TURBINE_DISPLAYSOURCE_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinedisplaysource", TurbineVariant.Reinforced, CreateTurbinePartType.DisplaySource);
        public static final RegistryObject<GenericDeviceBlock<MultiBlockEnergizer, IEnergizerPartType>> ENERGIZER_DISPLAYSOURCE = Blocks.registerEnergizerBlock("energizerdisplaysource", CreateEnergizerPartType.DisplaySource);

        static void initialize(IEventBus bus) {
            BLOCKS.register(bus);
        }

        public static Collection<RegistryObject<Block>> getAll() {
            return BLOCKS.getEntries();
        }

        private static <T extends MultiblockPartBlock<MultiblockReactor, IReactorPartType>> RegistryObject<T> registerReactorBlock(String name, ReactorVariant variant, IReactorPartType partType) {
            return BLOCKS.register(name, () -> partType.createBlock((IMultiblockVariant)variant));
        }

        private static <T extends MultiblockPartBlock<MultiblockTurbine, ITurbinePartType>> RegistryObject<T> registerTurbineBlock(String name, TurbineVariant variant, ITurbinePartType partType) {
            return BLOCKS.register(name, () -> partType.createBlock((IMultiblockVariant)variant));
        }

        private static <T extends MultiblockPartBlock<MultiBlockEnergizer, IEnergizerPartType>> RegistryObject<T> registerEnergizerBlock(String name, IEnergizerPartType partType) {
            return BLOCKS.register(name, () -> partType.createBlock((IMultiblockVariant)EnergizerVariant.INSTANCE));
        }
    }

    public static final class DisplaySources {
        private static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"er2create");

        static void initialize(IEventBus bus) {
            REGISTRATE.registerEventListeners(bus);
            DisplaySources.reactorMultiLineSource("reactor_status", ReactorDisplaySourceEntity::getReactorStatus);
            DisplaySources.reactorMultiLineSource("core_fuel_status", ReactorDisplaySourceEntity::getCoreFuelStatus);
            DisplaySources.reactorSingleLineSource("active", ReactorDisplaySourceEntity::getActivationStatus);
            DisplaySources.reactorSingleLineSource("fuel_amount", ReactorDisplaySourceEntity::getFuelAmount);
            DisplaySources.reactorPercentageSource("fuel_percentage", ReactorDisplaySourceEntity::getFuelPercentage);
            DisplaySources.reactorSingleLineSource("waste_amount", ReactorDisplaySourceEntity::getWasteAmount);
            DisplaySources.reactorPercentageSource("waste_percentage", ReactorDisplaySourceEntity::getWastePercentage);
            DisplaySources.reactorSingleLineSource("energy_stored", ReactorDisplaySourceEntity::getEnergyStored);
            DisplaySources.reactorPercentageSource("energy_percentage", ReactorDisplaySourceEntity::getEnergyStoredPercentage);
            DisplaySources.reactorSingleLineSource("vapor_stored", ReactorDisplaySourceEntity::getVaporStored);
            DisplaySources.reactorSingleLineSource("coolant_stored", ReactorDisplaySourceEntity::getCoolantStored);
            DisplaySources.reactorSingleLineSource("core_temperature", ReactorDisplaySourceEntity::getCoreHeatTemperature);
            DisplaySources.reactorSingleLineSource("casing_temperature", ReactorDisplaySourceEntity::getCasingHeatTemperature);
            DisplaySources.reactorSingleLineSource("fuel_burnup_rate", ReactorDisplaySourceEntity::getFuelBurnupRate);
            DisplaySources.reactorSingleLineSource("energy_generated", ReactorDisplaySourceEntity::getEnergyGenerated);
            DisplaySources.reactorSingleLineSource("vapor_generated", ReactorDisplaySourceEntity::getVaporGenerated);
            DisplaySources.turbineMultiLineSource("turbine_status", TurbineDisplaySourceEntity::getTurbineStatus);
            DisplaySources.turbineSingleLineSource("active", TurbineDisplaySourceEntity::getActivationStatus);
            DisplaySources.turbineSingleLineSource("energy_stored", TurbineDisplaySourceEntity::getEnergyStored);
            DisplaySources.turbinePercentageSource("energy_percentage", TurbineDisplaySourceEntity::getEnergyStoredPercentage);
            DisplaySources.turbineSingleLineSource("vapor_stored", TurbineDisplaySourceEntity::getVaporStored);
            DisplaySources.turbineSingleLineSource("coolant_stored", TurbineDisplaySourceEntity::getCoolantStored);
            DisplaySources.turbineSingleLineSource("energy_generated", TurbineDisplaySourceEntity::getEnergyGenerated);
            DisplaySources.turbineSingleLineSource("vapor_max_intake_rate", TurbineDisplaySourceEntity::getMaxIntakeRate);
            DisplaySources.turbineSingleLineSource("rotor_speed", TurbineDisplaySourceEntity::getRotorSpeed);
            DisplaySources.turbineSingleLineSource("rotor_blades_count", TurbineDisplaySourceEntity::getRotorBladesCount);
            DisplaySources.turbineSingleLineSource("rotor_efficiency", TurbineDisplaySourceEntity::getRotorEfficiency);
            DisplaySources.turbineSingleLineSource("vent_settings", TurbineDisplaySourceEntity::getVentSetting);
            DisplaySources.turbineSingleLineSource("inductor_mode", TurbineDisplaySourceEntity::getInductorMode);
            DisplaySources.energizerMultiLineSource("energizer_status", EnergizerDisplaySourceEntity::getEnergizerStatus);
            DisplaySources.energizerPercentageSource("energy_percentage", EnergizerDisplaySourceEntity::getEnergyStoredPercentage);
            DisplaySources.energizerSingleLineSource("energy_stored", EnergizerDisplaySourceEntity::getEnergyStored);
            DisplaySources.energizerSingleLineSource("active", EnergizerDisplaySourceEntity::getActivationStatus);
            DisplaySources.energizerSingleLineSource("energy_capacity", EnergizerDisplaySourceEntity::getEnergyCapacity);
            DisplaySources.energizerSingleLineSource("energy_inserted", EnergizerDisplaySourceEntity::getEnergyInsertedLastTick);
            DisplaySources.energizerSingleLineSource("energy_extracted", EnergizerDisplaySourceEntity::getEnergyExtractedLastTick);
            DisplaySources.energizerSingleLineSource("energy_io", EnergizerDisplaySourceEntity::getEnergyIoRate);
        }

        private static void reactorPercentageSource(String name, Function<ReactorDisplaySourceEntity, Float> mapper) {
            DisplaySources.reactorSource(name, () -> new MultiblockPercentOrProgressBarDisplaySource<ReactorDisplaySourceEntity>(IDisplayLinkContextAdapter.REACTOR, mapper));
        }

        private static void reactorSingleLineSource(String name, BiFunction<ReactorDisplaySourceEntity, DisplayTargetStats, MutableComponent> mapper) {
            DisplaySources.reactorSource(name, () -> new MultiblockSingleLineDisplaySource<ReactorDisplaySourceEntity>(IDisplayLinkContextAdapter.REACTOR, mapper));
        }

        private static void reactorMultiLineSource(String name, BiFunction<ReactorDisplaySourceEntity, DisplayTargetStats, List<List<MutableComponent>>> mapper) {
            DisplaySources.reactorSource(name, () -> new MultiblockMultiLineDisplaySource<ReactorDisplaySourceEntity>(IDisplayLinkContextAdapter.REACTOR, mapper));
        }

        private static <T extends DisplaySource> void reactorSource(String name, Supplier<T> displaySource) {
            DisplaySources.registerDisplaySource("reactor." + name, displaySource, new Supplier[]{Blocks.REACTOR_DISPLAYSOURCE_BASIC, Blocks.REACTOR_DISPLAYSOURCE_REINFORCED});
        }

        private static void turbinePercentageSource(String name, Function<TurbineDisplaySourceEntity, Float> mapper) {
            DisplaySources.turbineSource(name, () -> new MultiblockPercentOrProgressBarDisplaySource<TurbineDisplaySourceEntity>(IDisplayLinkContextAdapter.TURBINE, mapper));
        }

        private static void turbineSingleLineSource(String name, BiFunction<TurbineDisplaySourceEntity, DisplayTargetStats, MutableComponent> mapper) {
            DisplaySources.turbineSource(name, () -> new MultiblockSingleLineDisplaySource<TurbineDisplaySourceEntity>(IDisplayLinkContextAdapter.TURBINE, mapper));
        }

        private static void turbineMultiLineSource(String name, BiFunction<TurbineDisplaySourceEntity, DisplayTargetStats, List<List<MutableComponent>>> mapper) {
            DisplaySources.turbineSource(name, () -> new MultiblockMultiLineDisplaySource<TurbineDisplaySourceEntity>(IDisplayLinkContextAdapter.TURBINE, mapper));
        }

        private static <T extends DisplaySource> void turbineSource(String name, Supplier<T> displaySource) {
            DisplaySources.registerDisplaySource("turbine." + name, displaySource, new Supplier[]{Blocks.TURBINE_DISPLAYSOURCE_BASIC, Blocks.TURBINE_DISPLAYSOURCE_REINFORCED});
        }

        private static void energizerPercentageSource(String name, Function<EnergizerDisplaySourceEntity, Float> mapper) {
            DisplaySources.energizerSource(name, () -> new MultiblockPercentOrProgressBarDisplaySource<EnergizerDisplaySourceEntity>(IDisplayLinkContextAdapter.ENERGIZER, mapper));
        }

        private static void energizerSingleLineSource(String name, BiFunction<EnergizerDisplaySourceEntity, DisplayTargetStats, MutableComponent> mapper) {
            DisplaySources.energizerSource(name, () -> new MultiblockSingleLineDisplaySource<EnergizerDisplaySourceEntity>(IDisplayLinkContextAdapter.ENERGIZER, mapper));
        }

        private static void energizerMultiLineSource(String name, BiFunction<EnergizerDisplaySourceEntity, DisplayTargetStats, List<List<MutableComponent>>> mapper) {
            DisplaySources.energizerSource(name, () -> new MultiblockMultiLineDisplaySource<EnergizerDisplaySourceEntity>(IDisplayLinkContextAdapter.ENERGIZER, mapper));
        }

        private static <T extends DisplaySource> void energizerSource(String name, Supplier<T> displaySource) {
            DisplaySources.registerDisplaySource("energizer." + name, displaySource, new Supplier[]{Blocks.ENERGIZER_DISPLAYSOURCE});
        }

        @SafeVarargs
        private static <T extends DisplaySource, B extends Block> void registerDisplaySource(String name, Supplier<T> displaySource, Supplier<B> ... blocks) {
            SimpleBuilder builder = REGISTRATE.displaySource(name, displaySource);
            builder.onRegister(source -> {
                for (Supplier block : blocks) {
                    DisplaySource.BY_BLOCK.add((Object)((Block)block.get()), source);
                }
            });
            builder.register();
        }
    }

    public static final class Items {
        private static final DeferredRegister<Item> ITEMS = CreateContent.defer(ForgeRegistries.ITEMS);
        public static final RegistryObject<BlockItem> REACTOR_DISPLAYSOURCE_BASIC = Items.registerItemBlock("basic_reactordisplaysource", () -> () -> Blocks.REACTOR_DISPLAYSOURCE_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_DISPLAYSOURCE_REINFORCED = Items.registerItemBlock("reinforced_reactordisplaysource", () -> () -> Blocks.REACTOR_DISPLAYSOURCE_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_DISPLAYSOURCE_BASIC = Items.registerItemBlock("basic_turbinedisplaysource", () -> () -> Blocks.TURBINE_DISPLAYSOURCE_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_DISPLAYSOURCE_REINFORCED = Items.registerItemBlock("reinforced_turbinedisplaysource", () -> () -> Blocks.TURBINE_DISPLAYSOURCE_REINFORCED.get());
        public static final RegistryObject<BlockItem> ENERGIZER_DISPLAYSOURCE = Items.registerItemBlock("energizerdisplaysource", () -> () -> Blocks.ENERGIZER_DISPLAYSOURCE.get());

        static void initialize(IEventBus bus) {
            ITEMS.register(bus);
        }

        private static RegistryObject<BlockItem> registerItemBlock(String name, Supplier<Supplier<ModBlock>> blockSupplier) {
            return ITEMS.register(name, () -> ((ModBlock)((Supplier)blockSupplier.get()).get()).createBlockItem(new Item.Properties().m_41487_(64)));
        }
    }

    public static final class TileEntityTypes {
        private static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = CreateContent.defer(ForgeRegistries.BLOCK_ENTITY_TYPES);
        public static final RegistryObject<BlockEntityType<ReactorDisplaySourceEntity>> REACTOR_DISPLAYSOURCE = TileEntityTypes.registerBlockEntity("reactordisplaysource", ReactorDisplaySourceEntity::new, () -> () -> Blocks.REACTOR_DISPLAYSOURCE_BASIC.get(), () -> () -> Blocks.REACTOR_DISPLAYSOURCE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineDisplaySourceEntity>> TURBINE_DISPLAYSOURCE = TileEntityTypes.registerBlockEntity("turbinedisplaysource", TurbineDisplaySourceEntity::new, () -> () -> Blocks.TURBINE_DISPLAYSOURCE_BASIC.get(), () -> () -> Blocks.TURBINE_DISPLAYSOURCE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<EnergizerDisplaySourceEntity>> ENERGIZER_DISPLAYSOURCE = TileEntityTypes.registerBlockEntity("energizerdisplaysource", EnergizerDisplaySourceEntity::new, () -> () -> Blocks.ENERGIZER_DISPLAYSOURCE.get());

        static void initialize(IEventBus bus) {
            TILE_ENTITIES.register(bus);
        }

        @SafeVarargs
        private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerBlockEntity(String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<Supplier<Block>> ... validBlockSuppliers) {
            return TILE_ENTITIES.register(name, () -> {
                Block[] validBlocks = new Block[validBlockSuppliers.length];
                if (validBlockSuppliers.length > 0) {
                    for (int i = 0; i < validBlockSuppliers.length; ++i) {
                        validBlocks[i] = (Block)((Supplier)validBlockSuppliers[i].get()).get();
                    }
                }
                return BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])validBlocks).m_58966_(null);
            });
        }
    }

    public static final class CreativeTabs {
        private static final DeferredRegister<CreativeModeTab> TABS = CreateContent.defer(Registries.f_279569_);

        static void initialize(IEventBus bus) {
            TABS.register(bus);
            TABS.register("tab.general", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.er2create.general")).m_257737_(() -> new ItemStack((ItemLike)Items.REACTOR_DISPLAYSOURCE_BASIC.get())).withTabsBefore(new ResourceLocation[]{ExtremeReactors.ROOT_LOCATION.buildWithSuffix("tab.turbine")}).m_257501_((parameters, output) -> {
                output.m_246326_((ItemLike)Items.REACTOR_DISPLAYSOURCE_BASIC.get());
                output.m_246326_((ItemLike)Items.REACTOR_DISPLAYSOURCE_REINFORCED.get());
                output.m_246326_((ItemLike)Items.TURBINE_DISPLAYSOURCE_BASIC.get());
                output.m_246326_((ItemLike)Items.TURBINE_DISPLAYSOURCE_REINFORCED.get());
                output.m_246326_((ItemLike)Items.ENERGIZER_DISPLAYSOURCE.get());
            }).m_257652_());
        }
    }
}

