/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.compat.create.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import it.zerono.mods.extremereactors.compat.create.client.model.CreateEnergizerModelBuilder;
import it.zerono.mods.extremereactors.compat.create.client.model.CreateReactorModelBuilder;
import it.zerono.mods.extremereactors.compat.create.client.model.CreateTurbineModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.variant.EnergizerVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.lib.client.model.ICustomModelBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientInitializer {
    private static final List<ICustomModelBuilder> s_modelBuilders = (List)Streams.concat((Stream[])new Stream[]{Arrays.stream(ReactorVariant.values()).map(CreateReactorModelBuilder::new), Arrays.stream(TurbineVariant.values()).map(CreateTurbineModelBuilder::new), Arrays.stream(EnergizerVariant.values()).map(CreateEnergizerModelBuilder::new)}).collect(ImmutableList.toImmutableList());

    @SubscribeEvent
    public static void onRegisterModels(ModelEvent.RegisterAdditional event) {
        s_modelBuilders.forEach(b -> b.onRegisterModels(event));
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        s_modelBuilders.forEach(builder -> builder.onBakeModels(event));
    }
}

