/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.recipes.AltarRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import de.ellpeck.naturesaura.recipes.OfferingRecipe;
import de.ellpeck.naturesaura.recipes.TreeRitualRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class NaturesAuraAddon {
    public static final String MODID = "naturesaura";

    public static String NAME(String name) {
        return "NaturesAura" + name + "Mapper";
    }

    @ConversionProvider(value="naturesaura")
    public static class NAConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            ((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)builder.comment("Default conversions for Natures Aura").before((ItemLike)ModItems.GOLD_LEAF, 2L).before((ItemLike)ModBlocks.END_FLOWER, 32L).conversion((ItemLike)ModItems.AURA_BOTTLE)).ingredient((ItemLike)ModItems.BOTTLE_TWO_THE_REBOTTLING)).end();
        }
    }

    @RecipeTypeMapper(requiredMods={"naturesaura"}, priority=1)
    public static class NATreeRitualMapper
    extends ARecipeTypeMapper<TreeRitualRecipe> {
        @Override
        public String getName() {
            return NaturesAuraAddon.NAME("TreeRitual");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipes.TREE_RITUAL_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(TreeRitualRecipe recipe) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(recipe.ingredients.length + 17);
            ingredients.add(recipe.saplingType);
            ingredients.addAll(List.of(recipe.ingredients));
            ingredients.addAll(Collections.nCopies(16, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModBlocks.GOLD_POWDER})));
            return ingredients;
        }
    }

    @RecipeTypeMapper(requiredMods={"naturesaura"}, priority=1)
    public static class NAOfferingMapper
    extends ARecipeTypeMapper<OfferingRecipe> {
        @Override
        public String getName() {
            return NaturesAuraAddon.NAME("Offering");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipes.OFFERING_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(OfferingRecipe recipe) {
            return Collections.singletonList(recipe.input);
        }
    }

    @RecipeTypeMapper(requiredMods={"naturesaura"}, priority=1)
    public static class NAAltarMapper
    extends ARecipeTypeMapper<AltarRecipe> {
        @Override
        public String getName() {
            return NaturesAuraAddon.NAME("Altar");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipes.ALTAR_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(AltarRecipe recipe) {
            return Collections.singletonList(recipe.input);
        }
    }
}

