/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.recipe.DragonForgeRecipe;
import com.github.alexthe666.iceandfire.recipe.IafRecipeRegistry;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import java.util.Arrays;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class IceAndFireAddon {
    public static final String MODID = "iceandfire";

    @ConversionProvider(value="iceandfire")
    public static class IAFDataGenerator
    extends AConversionProvider {
        protected static NormalizedSimpleStack bonesTag(String tag) {
            return IAFDataGenerator.forgeTag("bones/" + tag);
        }

        protected static NormalizedSimpleStack scaleTag(String tag) {
            return IAFDataGenerator.forgeTag("scales/" + tag);
        }

        protected static NormalizedSimpleStack iafTag(String tag) {
            return IAFDataGenerator.tag("iceandfire:" + tag);
        }

        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("default conversions for Ice and Fire: Dragons").before(IAFDataGenerator.gemTag("amethyst"), 2048L).before(IAFDataGenerator.forgeTag("heart"), 262144L).before(IAFDataGenerator.iafTag("mob_skulls"), 320L).before(IAFDataGenerator.iafTag("dragon_skulls"), 624L).before(IAFDataGenerator.iafTag("myrmex_harvestables"), 32L).before(IAFDataGenerator.scaleTag("sea_serpent"), 256L).before(IAFDataGenerator.scaleTag("dragon"), 512L).before(IAFDataGenerator.bonesTag("dragon"), 156L).before(IAFDataGenerator.bonesTag("wither"), 156L).before((ItemLike)IafItemRegistry.ICE_DRAGON_BLOOD.get(), 256L).before((ItemLike)IafItemRegistry.LIGHTNING_DRAGON_BLOOD.get(), 256L).before((ItemLike)IafItemRegistry.FIRE_DRAGON_BLOOD.get(), 256L).before((ItemLike)IafItemRegistry.DREAD_SHARD.get(), 144L).before((ItemLike)IafItemRegistry.HIPPOGRYPH_TALON.get(), 128L).before((ItemLike)IafItemRegistry.HIPPOCAMPUS_FIN.get(), 512L).before((ItemLike)IafItemRegistry.SHINY_SCALES.get(), 512L).before((ItemLike)IafItemRegistry.SIREN_TEAR.get(), 768L).before((ItemLike)IafItemRegistry.CYCLOPS_EYE.get(), 96L).before((ItemLike)IafItemRegistry.PIXIE_DUST.get(), 1L).before((ItemLike)IafItemRegistry.PIXIE_WINGS.get(), 1L);
        }
    }

    @RecipeTypeMapper(requiredMods={"iceandfire"}, priority=1)
    public static class IAFDragonForgeMapper
    extends ARecipeTypeMapper<DragonForgeRecipe> {
        @Override
        public String getName() {
            return "IceAndFireDragonForgeMapper";
        }

        @Override
        public String getDescription() {
            return "Recipe mapper for Ice and Fire DragonForge recipes";
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IafRecipeRegistry.DRAGON_FORGE_TYPE.get();
        }

        @Override
        protected List<Ingredient> getIngredients(DragonForgeRecipe recipe) {
            return Arrays.asList(recipe.getInput(), recipe.getBlood());
        }
    }
}

