/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.network;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record PacketSendDimletPackages(Map<DimletKey, DimletSettings> dimlets) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsdim", "senddimletpackages");

    public PacketSendDimletPackages(Map<DimletKey, DimletSettings> dimlets) {
        this.dimlets = new HashMap<DimletKey, DimletSettings>(dimlets);
    }

    public static PacketSendDimletPackages create(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashMap<DimletKey, DimletSettings> dimlets = new HashMap<DimletKey, DimletSettings>(size);
        for (int i = 0; i < size; ++i) {
            DimletKey key = DimletKey.create(buf);
            DimletSettings settings = new DimletSettings(buf);
            dimlets.put(key, settings);
        }
        return new PacketSendDimletPackages(dimlets);
    }

    public static PacketSendDimletPackages create(Map<DimletKey, DimletSettings> collected) {
        return new PacketSendDimletPackages(collected);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.dimlets.size());
        for (Map.Entry<DimletKey, DimletSettings> entry : this.dimlets.entrySet()) {
            entry.getKey().toBytes(buf);
            entry.getValue().toBytes(buf);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            RegistryAccess access = SafeClientTools.getClientWorld().m_9598_();
            DimletDictionary dictionary = DimletDictionary.get();
            for (Map.Entry<DimletKey, DimletSettings> entry : this.dimlets.entrySet()) {
                dictionary.register(access, entry.getKey(), entry.getValue());
            }
        });
    }
}

