/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import com.google.common.collect.ImmutableList;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.MinecraftEndecs;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public record AccessoryItemAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final AccessoryItemAttributeModifiers EMPTY = new AccessoryItemAttributeModifiers(List.of(), true);
    public static final Endec<AccessoryItemAttributeModifiers> ENDEC = StructEndecBuilder.of((StructField)Entry.ENDEC.listOf().fieldOf("modifiers", AccessoryItemAttributeModifiers::modifiers), (StructField)Endec.BOOLEAN.optionalFieldOf("show_in_tooltip", AccessoryItemAttributeModifiers::showInTooltip, (Object)true), AccessoryItemAttributeModifiers::new);

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasModifier(Attribute holder, ResourceLocation location) {
        return this.getModifier(holder, location) != null;
    }

    @Nullable
    public AttributeModifier getModifier(Attribute holder, ResourceLocation location) {
        for (Entry entry : this.modifiers) {
            ResourceLocation modifierLocation = AttributeUtils.getLocation(entry.modifier.m_22214_());
            if (!entry.attribute.equals(holder) || !modifierLocation.equals((Object)location)) continue;
            return entry.modifier();
        }
        return null;
    }

    public AccessoryItemAttributeModifiers withModifierAddedForAny(Attribute holder, ResourceLocation location, double amount, AttributeModifier.Operation operation, String slotName, boolean isStackable) {
        Pair<String, UUID> data = AttributeUtils.getModifierData(location);
        return this.withModifierAdded(holder, new AttributeModifier((UUID)data.second(), (String)data.first(), amount, operation), "any", isStackable);
    }

    public AccessoryItemAttributeModifiers withModifierAdded(Attribute holder, ResourceLocation location, double amount, AttributeModifier.Operation operation, String slotName, boolean isStackable) {
        Pair<String, UUID> data = AttributeUtils.getModifierData(location);
        return this.withModifierAdded(holder, new AttributeModifier((UUID)data.second(), (String)data.first(), amount, operation), slotName, isStackable);
    }

    public AccessoryItemAttributeModifiers withModifierAddedForAny(Attribute holder, AttributeModifier attributeModifier, String slotName, boolean isStackable) {
        return this.withModifierAdded(holder, attributeModifier, "any", isStackable);
    }

    public AccessoryItemAttributeModifiers withModifierAdded(Attribute holder, AttributeModifier attributeModifier, String slotName, boolean isStackable) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        this.modifiers.forEach(entry -> {
            if (!entry.modifier.m_22209_().equals(attributeModifier.m_22209_())) {
                builder.add(entry);
            }
        });
        builder.add((Object)new Entry(holder, attributeModifier, slotName, isStackable));
        return new AccessoryItemAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip());
    }

    public AccessoryItemAttributeModifiers withoutModifier(Holder<Attribute> holder, ResourceLocation location) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        this.modifiers.forEach(entry -> {
            ResourceLocation modifierLocation = AttributeUtils.getLocation(entry.modifier.m_22214_());
            if (modifierLocation.equals((Object)location) && entry.attribute().equals(holder)) {
                return;
            }
            builder.add(entry);
        });
        return new AccessoryItemAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip());
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder gatherAttributes(SlotReference slotReference) {
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(slotReference);
        if (this.modifiers().isEmpty()) {
            return builder;
        }
        LivingEntity entity = slotReference.entity();
        Map slots = entity != null ? SlotTypeLoader.getSlotTypes(entity.m_9236_()) : Map.of();
        for (Entry entry : this.modifiers()) {
            AttributeModifier modifer = entry.modifier();
            String slotTarget = entry.slotName();
            if (!slots.containsKey(slotTarget) && !slotReference.slotName().equals(slotTarget) && !slotTarget.equals("any")) continue;
            if (entry.isStackable()) {
                builder.addStackable(entry.attribute(), AttributeUtils.getLocation(modifer.m_22214_()), modifer.m_22218_(), modifer.m_22217_());
                continue;
            }
            builder.addExclusive(entry.attribute(), AttributeUtils.getLocation(modifer.m_22214_()), modifer.m_22218_(), modifer.m_22217_());
        }
        return builder;
    }

    public static class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();
        private boolean showInTooltip = true;

        private Builder() {
        }

        @Deprecated(forRemoval=true)
        @ApiStatus.ScheduledForRemoval(inVersion="1.22")
        public Builder add(Attribute attribute, AttributeModifier attributeModifier, String slotName, boolean isStackable) {
            return this.addForSlot(attribute, attributeModifier, slotName, isStackable);
        }

        public Builder addForSlot(Attribute attribute, AttributeModifier attributeModifier, String slotName, boolean isStackable) {
            this.entries.add(new Entry(attribute, attributeModifier, slotName, isStackable));
            return this;
        }

        public Builder addForAny(Attribute attribute, AttributeModifier attributeModifier, boolean isStackable) {
            this.entries.add(new Entry(attribute, attributeModifier, "any", isStackable));
            return this;
        }

        public Builder showInTooltip(boolean value) {
            this.showInTooltip = value;
            return this;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public AccessoryItemAttributeModifiers build() {
            return new AccessoryItemAttributeModifiers(Collections.unmodifiableList(this.entries), this.showInTooltip);
        }
    }

    public record Entry(Attribute attribute, AttributeModifier modifier, String slotName, boolean isStackable) {
        private static final Endec<Attribute> ATTRIBUTE_ENDEC = MinecraftEndecs.IDENTIFIER.xmapWithContext((context, attributeType) -> {
            if (attributeType.m_135827_().equals("accessories")) {
                String path = attributeType.m_135815_();
                if (path.contains("/")) {
                    path = path.replace("/", ":");
                }
                return SlotAttribute.getSlotAttribute(path);
            }
            return (Attribute)BuiltInRegistries.f_256951_.m_6612_(attributeType).orElseThrow(IllegalStateException::new);
        }, (context, attribute) -> {
            if (attribute instanceof SlotAttribute) {
                SlotAttribute slotAttribute = (SlotAttribute)((Object)attribute);
                String path = slotAttribute.slotName();
                if (UniqueSlotHandling.isUniqueSlot(path)) {
                    path = path.replace(":", "/");
                }
                return Accessories.of(path);
            }
            return BuiltInRegistries.f_256951_.m_7981_(attribute);
        });
        public static final Endec<Entry> ENDEC = StructEndecBuilder.of((StructField)ATTRIBUTE_ENDEC.fieldOf("type", Entry::attribute), (StructField)AttributeUtils.ATTRIBUTE_MODIFIER_ENDEC.flatFieldOf(Entry::modifier), (StructField)Endec.STRING.fieldOf("slot_name", Entry::slotName), (StructField)Endec.BOOLEAN.optionalFieldOf("is_stackable", Entry::isStackable, (Object)false), Entry::new);
    }
}

