/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import io.wispforest.accessories.api.client.Side;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.mixin.client.ModelPartAccessor;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface AccessoryRenderer {
    public <M extends LivingEntity> void render(ItemStack var1, SlotReference var2, PoseStack var3, EntityModel<M> var4, MultiBufferSource var5, int var6, float var7, float var8, float var9, float var10, float var11, float var12);

    default public boolean shouldRender(boolean isRendering) {
        return isRendering;
    }

    default public boolean shouldRenderInFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference) {
        return false;
    }

    default public <M extends LivingEntity> void renderOnFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light) {
        if (!this.shouldRenderInFirstPerson(arm, stack, reference)) {
            return;
        }
        this.render(stack, reference, matrices, model, multiBufferSource, light, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Deprecated(forRemoval=true)
    public static void followBodyRotations(LivingEntity entity, HumanoidModel<LivingEntity> model) {
        LivingEntityRenderer renderer;
        EntityModel entityModel;
        EntityRenderer render = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        if (render instanceof LivingEntityRenderer && (entityModel = (renderer = (LivingEntityRenderer)render).m_7200_()) instanceof HumanoidModel) {
            HumanoidModel entityModel2 = (HumanoidModel)entityModel;
            entityModel2.m_102872_(model);
        }
    }

    @Deprecated
    public static void translateToFace(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity entity) {
        AccessoryRenderer.transformToFace(poseStack, model.f_102808_, Side.FRONT);
    }

    @Deprecated(forRemoval=true)
    public static void translateToChest(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity livingEntity) {
        AccessoryRenderer.transformToModelPart(poseStack, model.f_102810_);
    }

    @Deprecated(forRemoval=true)
    public static void translateToRightArm(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.f_102811_, Side.BOTTOM);
    }

    @Deprecated(forRemoval=true)
    public static void translateToLeftArm(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.f_102812_, Side.BOTTOM);
    }

    @Deprecated(forRemoval=true)
    public static void translateToRightLeg(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.f_102813_, Side.BOTTOM);
    }

    @Deprecated(forRemoval=true)
    public static void translateToLeftLeg(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.f_102814_, Side.BOTTOM);
    }

    public static void transformToFace(PoseStack poseStack, ModelPart part, Side side) {
        AccessoryRenderer.transformToModelPart(poseStack, part, side.direction.m_122436_().m_123341_(), side.direction.m_122436_().m_123342_(), side.direction.m_122436_().m_123343_());
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part) {
        AccessoryRenderer.transformToModelPart(poseStack, part, 0, 0, 0);
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        part.m_104299_(poseStack);
        Pair<Vec3, Vec3> aabb = AccessoryRenderer.getAABB(part);
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        poseStack.m_85837_(xPercent != null ? Mth.m_14139_((double)((-xPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).f_82479_, (double)((Vec3)aabb.getSecond()).f_82479_) : 0.0, yPercent != null ? Mth.m_14139_((double)((-yPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).f_82480_, (double)((Vec3)aabb.getSecond()).f_82480_) : 0.0, zPercent != null ? Mth.m_14139_((double)((-zPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).f_82481_, (double)((Vec3)aabb.getSecond()).f_82481_) : 0.0);
        poseStack.m_85841_(8.0f, 8.0f, 8.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
    }

    private static Pair<Vec3, Vec3> getAABB(ModelPart part) {
        Vec3 min = new Vec3(0.0, 0.0, 0.0);
        Vec3 max = new Vec3(0.0, 0.0, 0.0);
        if (part.getClass().getSimpleName().contains("EMFModelPart")) {
            ArrayList<ModelPart> parts = new ArrayList<ModelPart>();
            parts.add(part);
            parts.addAll(((ModelPartAccessor)part).getChildren().values());
            for (ModelPart modelPart : parts) {
                for (ModelPart.Cube cube : ((ModelPartAccessor)modelPart).getCubes()) {
                    min = new Vec3(Math.min(min.f_82479_, (double)Math.min(cube.f_104335_ + modelPart.f_104200_, cube.f_104338_ + modelPart.f_104200_)), Math.min(min.f_82480_, (double)Math.min(cube.f_104336_ + modelPart.f_104201_, cube.f_104339_ + modelPart.f_104201_)), Math.min(min.f_82481_, (double)Math.min(cube.f_104337_ + modelPart.f_104202_, cube.f_104340_ + modelPart.f_104202_)));
                    max = new Vec3(Math.max(max.f_82479_, (double)Math.max(cube.f_104335_ + modelPart.f_104200_, cube.f_104338_ + modelPart.f_104200_)), Math.max(max.f_82480_, (double)Math.max(cube.f_104336_ + modelPart.f_104201_, cube.f_104339_ + modelPart.f_104201_)), Math.max(max.f_82481_, (double)Math.max(cube.f_104337_ + modelPart.f_104202_, cube.f_104340_ + modelPart.f_104202_)));
                }
            }
        } else {
            for (ModelPart.Cube cube : ((ModelPartAccessor)part).getCubes()) {
                min = new Vec3(Math.min(min.f_82479_, (double)Math.min(cube.f_104335_, cube.f_104338_)), Math.min(min.f_82480_, (double)Math.min(cube.f_104336_, cube.f_104339_)), Math.min(min.f_82481_, (double)Math.min(cube.f_104337_, cube.f_104340_)));
                max = new Vec3(Math.max(max.f_82479_, (double)Math.max(cube.f_104335_, cube.f_104338_)), Math.max(max.f_82480_, (double)Math.max(cube.f_104336_, cube.f_104339_)), Math.max(max.f_82481_, (double)Math.max(cube.f_104337_, cube.f_104340_)));
            }
        }
        return Pair.of((Object)min, (Object)max);
    }
}

