/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public interface AccessoryNest
extends Accessory {
    default public List<ItemStack> getInnerStacks(ItemStack holderStack) {
        AccessoryNestContainerContents data = AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.NESTED_ACCESSORIES, holderStack);
        return data == null ? List.of() : data.accessories();
    }

    default public boolean setInnerStack(ItemStack holderStack, int index, ItemStack newStack) {
        if (!AccessoryNest.isAccessoryNest(holderStack)) {
            return false;
        }
        if (AccessoryNest.isAccessoryNest(newStack) && !this.allowDeepRecursion()) {
            return false;
        }
        AccessoriesDataComponents.update(AccessoriesDataComponents.NESTED_ACCESSORIES, holderStack, contents -> contents.setStack(index, newStack));
        return true;
    }

    default public boolean allowDeepRecursion() {
        return false;
    }

    default public List<Pair<DropRule, ItemStack>> getDropRules(ItemStack stack, SlotReference reference, DamageSource source) {
        ArrayList<Pair<DropRule, ItemStack>> innerRules = new ArrayList<Pair<DropRule, ItemStack>>();
        List<ItemStack> innerStacks = this.getInnerStacks(stack);
        for (int i = 0; i < innerStacks.size(); ++i) {
            ItemStack innerStack = innerStacks.get(i);
            DropRule rule = AccessoriesAPI.getOrDefaultAccessory(innerStack).getDropRule(innerStack, reference, source);
            innerRules.add((Pair<DropRule, ItemStack>)Pair.of((Object)((Object)rule), (Object)innerStack));
        }
        return innerRules;
    }

    public static <T> T attemptFunction(ItemStack holderStack, SlotReference slotReference, Function<Map<SlotEntryReference, Accessory>, T> func, T defaultValue) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return defaultValue;
        }
        AccessoryNest nest = (AccessoryNest)AccessoriesAPI.getAccessory(holderStack);
        T t = func.apply(data.getMap(slotReference));
        if (data.hasChangesOccured(holderStack)) {
            nest.onStackChanges(holderStack, AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.NESTED_ACCESSORIES, holderStack), slotReference.entity());
        }
        return t;
    }

    public static <T> T attemptFunction(ItemStack holderStack, @Nullable LivingEntity livingEntity, Function<Map<ItemStack, Accessory>, T> func, T defaultValue) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return defaultValue;
        }
        AccessoryNest nest = (AccessoryNest)AccessoriesAPI.getAccessory(holderStack);
        T t = func.apply(data.getMap());
        if (data.hasChangesOccured(holderStack)) {
            nest.onStackChanges(holderStack, AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.NESTED_ACCESSORIES, holderStack), livingEntity);
        }
        return t;
    }

    public static void attemptConsumer(ItemStack holderStack, SlotReference slotReference, Consumer<Map<SlotEntryReference, Accessory>> consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return;
        }
        AccessoryNest nest = (AccessoryNest)AccessoriesAPI.getAccessory(holderStack);
        consumer.accept(data.getMap(slotReference));
        if (data.hasChangesOccured(holderStack)) {
            nest.onStackChanges(holderStack, AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.NESTED_ACCESSORIES, holderStack), slotReference.entity());
        }
    }

    public static void attemptConsumer(ItemStack holderStack, @Nullable LivingEntity livingEntity, Consumer<Map<ItemStack, Accessory>> consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return;
        }
        AccessoryNest nest = (AccessoryNest)AccessoriesAPI.getAccessory(holderStack);
        consumer.accept(data.getMap());
        if (data.hasChangesOccured(holderStack)) {
            nest.onStackChanges(holderStack, AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.NESTED_ACCESSORIES, holderStack), livingEntity);
        }
    }

    public static boolean isAccessoryNest(ItemStack holderStack) {
        return AccessoriesAPI.getAccessory(holderStack) instanceof AccessoryNest;
    }

    default public void onStackChanges(ItemStack holderStack, AccessoryNestContainerContents data, @Nullable LivingEntity livingEntity) {
    }

    @Override
    default public void tick(ItemStack stack, SlotReference reference) {
        AccessoryNest.attemptConsumer(stack, reference, (Map<SlotEntryReference, Accessory> map) -> map.forEach((entryRef, accessory) -> accessory.tick(entryRef.stack(), entryRef.reference())));
    }

    @Override
    default public void onEquip(ItemStack stack, SlotReference reference) {
        AccessoryNest.attemptConsumer(stack, reference, (Map<SlotEntryReference, Accessory> map) -> map.forEach((entryRef, accessory) -> accessory.onEquip(entryRef.stack(), entryRef.reference())));
    }

    @Override
    default public void onUnequip(ItemStack stack, SlotReference reference) {
        AccessoryNest.attemptConsumer(stack, reference, (Map<SlotEntryReference, Accessory> map) -> map.forEach((entryRef, accessory) -> accessory.onUnequip(entryRef.stack(), entryRef.reference())));
    }

    @Override
    default public boolean canEquip(ItemStack stack, SlotReference reference) {
        return AccessoryNest.attemptFunction(stack, reference, (Map<SlotEntryReference, Accessory> map) -> {
            MutableBoolean canEquip = new MutableBoolean(true);
            map.forEach((entryRef, accessory) -> canEquip.setValue(canEquip.booleanValue() && accessory.canEquip(entryRef.stack(), entryRef.reference())));
            return canEquip.getValue();
        }, Boolean.valueOf(false));
    }

    @Override
    default public boolean canUnequip(ItemStack stack, SlotReference reference) {
        return AccessoryNest.attemptFunction(stack, reference, (Map<SlotEntryReference, Accessory> map) -> {
            MutableBoolean canUnequip = new MutableBoolean(true);
            map.forEach((entryRef, accessory) -> canUnequip.setValue(canUnequip.booleanValue() && accessory.canUnequip(entryRef.stack(), entryRef.reference())));
            return canUnequip.getValue();
        }, Boolean.valueOf(true));
    }

    @Override
    default public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        AccessoryNest.attemptConsumer(stack, reference, (Map<SlotEntryReference, Accessory> innerMap) -> innerMap.forEach((entryRef, accessory) -> {
            AccessoryAttributeBuilder innerBuilder = new AccessoryAttributeBuilder(entryRef.reference());
            accessory.getDynamicModifiers(entryRef.stack(), entryRef.reference(), innerBuilder);
            builder.addFrom(innerBuilder);
        }));
    }

    @Override
    default public void getAttributesTooltip(ItemStack stack, SlotType type, List<Component> tooltips, TooltipFlag tooltipType) {
        AccessoryNest.attemptConsumer(stack, (LivingEntity)null, (Map<ItemStack, Accessory> map) -> map.forEach((stack1, accessory) -> accessory.getAttributesTooltip((ItemStack)stack1, type, tooltips, tooltipType)));
    }

    @Override
    default public void getExtraTooltip(ItemStack stack, List<Component> tooltips, TooltipFlag tooltipType) {
        AccessoryNest.attemptConsumer(stack, (LivingEntity)null, (Map<ItemStack, Accessory> map) -> map.forEach((stack1, accessory) -> accessory.getExtraTooltip((ItemStack)stack1, tooltips, tooltipType)));
    }
}

