/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.block;

import com.google.common.collect.Maps;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractIronShulkerBoxBlock
extends BaseEntityBlock {
    private static final VoxelShape UP_OPEN_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WES_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_OPEN_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> OPEN_SHAPE_BY_DIRECTION = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), p_258974_ -> {
        p_258974_.put(Direction.NORTH, NORTH_OPEN_AABB);
        p_258974_.put(Direction.EAST, EAST_OPEN_AABB);
        p_258974_.put(Direction.SOUTH, SOUTH_OPEN_AABB);
        p_258974_.put(Direction.WEST, WES_OPEN_AABB);
        p_258974_.put(Direction.UP, UP_OPEN_AABB);
        p_258974_.put(Direction.DOWN, DOWN_OPEN_AABB);
    });
    public static final EnumProperty<Direction> FACING = DirectionalBlock.f_52588_;
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    private final IronShulkerBoxesTypes type;
    @Nullable
    protected final DyeColor color;
    protected final Supplier<BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>> blockEntityType;

    public AbstractIronShulkerBoxBlock(BlockBehaviour.Properties properties, @Nullable DyeColor color, Supplier<BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>> blockEntityType, IronShulkerBoxesTypes type) {
        super(properties);
        this.color = color;
        this.type = type;
        this.blockEntityType = blockEntityType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.UP));
    }

    public BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity> blockEntityType() {
        return this.blockEntityType.get();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return AbstractIronShulkerBoxBlock.m_152132_(pBlockEntityType, this.blockEntityType(), AbstractIronShulkerBoxBlockEntity::tick);
    }

    @Deprecated
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof AbstractIronShulkerBoxBlockEntity) {
            AbstractIronShulkerBoxBlockEntity ironShulkerBoxBlockEntity = (AbstractIronShulkerBoxBlockEntity)blockentity;
            if (AbstractIronShulkerBoxBlock.canOpen(pState, pLevel, pPos, ironShulkerBoxBlockEntity)) {
                pPlayer.m_5893_((MenuProvider)ironShulkerBoxBlockEntity);
                pPlayer.m_36220_(Stats.f_12970_);
                PiglinAi.m_34873_((Player)pPlayer, (boolean)true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static boolean canOpen(BlockState pState, Level pLevel, BlockPos pPos, AbstractIronShulkerBoxBlockEntity pBlockEntity) {
        if (pBlockEntity.getAnimationStatus() != AbstractIronShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        AABB aabb = Shulker.m_149793_((Direction)((Direction)pState.m_61143_(FACING)), (float)0.0f, (float)0.5f).m_82338_(pPos).m_82406_(1.0E-6);
        return pLevel.m_45772_(aabb);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)pContext.m_43719_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof AbstractIronShulkerBoxBlockEntity) {
            AbstractIronShulkerBoxBlockEntity ironShulkerBoxBlockEntity = (AbstractIronShulkerBoxBlockEntity)blockentity;
            if (!pLevel.f_46443_ && pPlayer.m_7500_() && !ironShulkerBoxBlockEntity.m_7983_()) {
                ItemStack itemstack = AbstractIronShulkerBoxBlock.getColoredItemStack(this.getColor(), this.getType());
                blockentity.m_187476_(itemstack);
                if (ironShulkerBoxBlockEntity.m_8077_()) {
                    itemstack.m_41714_(ironShulkerBoxBlockEntity.m_7770_());
                }
                ItemEntity itementity = new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                pLevel.m_7967_((Entity)itementity);
            } else {
                ironShulkerBoxBlockEntity.m_59640_(pPlayer);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    @Deprecated
    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pBuilder) {
        BlockEntity blockentity = (BlockEntity)pBuilder.m_287159_(LootContextParams.f_81462_);
        if (blockentity instanceof AbstractIronShulkerBoxBlockEntity) {
            AbstractIronShulkerBoxBlockEntity ironShulkerBoxBlockEntity = (AbstractIronShulkerBoxBlockEntity)blockentity;
            pBuilder = pBuilder.m_287145_(CONTENTS, itemStackConsumer -> {
                for (int i = 0; i < ironShulkerBoxBlockEntity.m_6643_(); ++i) {
                    itemStackConsumer.accept(ironShulkerBoxBlockEntity.m_8020_(i));
                }
            });
        }
        return super.m_49635_(pState, pBuilder);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockentity;
        if (pStack.m_41788_() && (blockentity = pLevel.m_7702_(pPos)) instanceof AbstractIronShulkerBoxBlockEntity) {
            ((AbstractIronShulkerBoxBlockEntity)blockentity).m_58638_(pStack.m_41786_());
        }
    }

    @Deprecated
    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof AbstractIronShulkerBoxBlockEntity) {
                pLevel.m_46717_(pPos, pState.m_60734_());
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)pStack);
        if (compoundtag != null) {
            if (compoundtag.m_128425_("LootTable", 8)) {
                pTooltip.add((Component)Component.m_237113_((String)"???????"));
            }
            if (compoundtag.m_128425_("Items", 9)) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)this.type.size, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundtag, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.m_41619_()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    MutableComponent mutablecomponent = itemstack.m_41786_().m_6881_();
                    mutablecomponent.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                    pTooltip.add((Component)mutablecomponent);
                }
                if (j - i > 0) {
                    pTooltip.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC));
                }
            }
        }
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        AbstractIronShulkerBoxBlockEntity ironShulkerBoxBlockEntity;
        BlockEntity blockentity = pReader.m_7702_(pPos);
        if (blockentity instanceof AbstractIronShulkerBoxBlockEntity && !(ironShulkerBoxBlockEntity = (AbstractIronShulkerBoxBlockEntity)blockentity).isClosed()) {
            return OPEN_SHAPE_BY_DIRECTION.get(((Direction)pState.m_61143_(FACING)).m_122424_());
        }
        return Shapes.m_83144_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        return blockentity instanceof AbstractIronShulkerBoxBlockEntity ? Shapes.m_83064_((AABB)((AbstractIronShulkerBoxBlockEntity)blockentity).getBoundingBox(pState)) : Shapes.m_83144_();
    }

    @Deprecated
    public boolean m_7278_(BlockState pState) {
        return true;
    }

    @Deprecated
    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.m_38938_((Container)((Container)pLevel.m_7702_(pPos)));
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        ItemStack itemstack = super.m_7397_(pLevel, pPos, pState);
        pLevel.m_141902_(pPos, this.blockEntityType()).ifPresent(shulkerBoxBlockEntity -> shulkerBoxBlockEntity.m_187476_(itemstack));
        return itemstack;
    }

    @Nullable
    public static IronShulkerBoxesTypes getTypeFromItem(Item itemIn) {
        return AbstractIronShulkerBoxBlock.getTypeFromBlock(Block.m_49814_((Item)itemIn));
    }

    @Nullable
    public static IronShulkerBoxesTypes getTypeFromBlock(Block blockIn) {
        return blockIn instanceof AbstractIronShulkerBoxBlock ? ((AbstractIronShulkerBoxBlock)blockIn).getType() : null;
    }

    public IronShulkerBoxesTypes getType() {
        return this.type;
    }

    @Nullable
    public static DyeColor getColorFromItem(Item itemIn) {
        return AbstractIronShulkerBoxBlock.getColorFromBlock(Block.m_49814_((Item)itemIn));
    }

    @Nullable
    public static DyeColor getColorFromBlock(Block pBlock) {
        return pBlock instanceof AbstractIronShulkerBoxBlock ? ((AbstractIronShulkerBoxBlock)pBlock).getColor() : null;
    }

    public static Block getBlockByColor(@Nullable DyeColor colorIn, IronShulkerBoxesTypes typeIn) {
        return IronShulkerBoxesTypes.get(typeIn, colorIn);
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable DyeColor pColor, IronShulkerBoxesTypes typeIn) {
        return new ItemStack((ItemLike)AbstractIronShulkerBoxBlock.getBlockByColor(pColor, typeIn));
    }

    @Deprecated
    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_(FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_(FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_(FACING)));
    }
}

