/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.technical;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface MaxArmorLevelModule
extends HookProvider,
EquipmentChangeModifierHook,
ModifierCondition.ConditionalModule<IToolStackView> {
    public static final List<ModuleHook<?>> NO_TOOLTIP_HOOKS = HookProvider.defaultHooks(ModifierHooks.EQUIPMENT_CHANGE);
    public static final List<ModuleHook<?>> TOOLTIP_HOOKS = HookProvider.defaultHooks(ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.TOOLTIP);

    public TinkerDataCapability.ComputableDataKey<ModifierMaxLevel> maxLevel();

    public boolean allowBroken();

    @Nullable
    public TagKey<Item> heldTag();

    @Override
    default public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        this.updateLevel(tool, modifier, modifier.getEffectiveLevel(), context);
    }

    @Override
    default public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        this.updateLevel(tool, modifier, 0.0f, context);
    }

    default public void updateLevel(IToolStackView tool, ModifierEntry modifier, float effectiveLevel, EquipmentChangeContext context) {
        if (this.condition().matches(tool, modifier) && ArmorLevelModule.validSlot(tool, context.getChangedSlot(), this.heldTag()) && (!tool.isBroken() || this.allowBroken())) {
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel maxLevel = (ModifierMaxLevel)data.computeIfAbsent(this.maxLevel());
                float oldLevel = maxLevel.getMax();
                maxLevel.set(context.getChangedSlot(), effectiveLevel);
                float newLevel = maxLevel.getMax();
                if (oldLevel != newLevel) {
                    this.updateValue(tool, modifier, context, (TinkerDataCapability.Holder)data, newLevel, oldLevel);
                }
            });
        }
    }

    public void updateValue(IToolStackView var1, ModifierEntry var2, EquipmentChangeContext var3, TinkerDataCapability.Holder var4, float var5, float var6);

    public static boolean shouldAddTooltip(MaxArmorLevelModule module, IToolStackView tool, ModifierEntry modifier, @Nullable Player player) {
        TagKey<Item> heldTag = module.heldTag();
        if (module.condition().matches(tool, modifier) && (tool.hasTag(TinkerTags.Items.WORN_ARMOR) || heldTag != null && tool.hasTag(heldTag)) && (!tool.isBroken() || module.allowBroken())) {
            return player == null || player.getCapability(TinkerDataCapability.CAPABILITY).filter(data -> ((ModifierMaxLevel)data.computeIfAbsent(module.maxLevel())).getMax() <= modifier.getEffectiveLevel()).isPresent();
        }
        return false;
    }

    public static TinkerDataCapability.ComputableDataKey<ModifierMaxLevel> createKey(@Nullable ResourceLocation id) {
        if (id == null) {
            id = new ResourceLocation("missingno");
        }
        return TinkerDataCapability.ComputableDataKey.of(id.m_266382_("_data"), ModifierMaxLevel::new);
    }
}

