/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus;

import com.Gabou.sereneseasonsplus.SereneSeasonPlusCommon;
import com.Gabou.sereneseasonsplus.SereneSeasonsPlusClientForge;
import com.Gabou.sereneseasonsplus.config.SereneExtendedConfig;
import com.Gabou.sereneseasonsplus.event.SeasonChangeEvent;
import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.ForgeSnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ForgeAsyncExecutorHandler;
import com.Gabou.sereneseasonsplus.util.ForgeEnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import com.Gabou.sereneseasonsplus.util.ProjectAtmosphereRainHandler;
import com.Gabou.sereneseasonsplus.util.SereneService;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="sereneseasonsplus")
public class SereneSeasonsPlusForge
extends SereneSeasonPlusCommon {
    public static boolean isProjectAtmosphereLoaded = false;

    public SereneSeasonsPlusForge(FMLJavaModLoadingContext context) {
        isProjectAtmosphereLoaded = ModList.get().isLoaded("projectatmosphere");
        MinecraftForge.EVENT_BUS.register((Object)this);
        CommonSnowBlockFeature.HANDLER = new ForgeSnowEnvironmentHandler();
        EnvironmentHelper.init(new ForgeEnvironmentHelper());
        if (isProjectAtmosphereLoaded) {
            EnvironmentHelper.initRainHandler(new ProjectAtmosphereRainHandler());
        }
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SereneExtendedConfig.COMMON_SPEC);
        if (!isProjectAtmosphereLoaded) {
            SeasonChangeEvent.register();
        }
        context.getModEventBus().addListener(event -> {
            LOGGER.info("Setting up Serene Season Plus (Common)");
            this.clientSetup((FMLClientSetupEvent)event, context);
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Serene Seasons Extended is loading!");
        SereneService.HANDLER = new ForgeAsyncExecutorHandler();
        ((GameRules.IntegerValue)event.getServer().m_129900_().m_46170_(GameRules.f_254637_)).m_151489_(((Integer)SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get()).intValue(), event.getServer());
        CommonSnowBlockFeature.onServerStarting((Integer)SereneExtendedConfig.TICK_SNOW_REPLACER.get(), (Boolean)SereneExtendedConfig.SNOWSTORM_ENABLED.get(), (Integer)SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get());
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        EnvironmentHelper.onServerStarted(event.getServer().m_129880_(Level.f_46428_));
    }

    private void clientSetup(FMLClientSetupEvent event, FMLJavaModLoadingContext context) {
        LOGGER.info("Setting up Serene Season Plus (Client)");
        event.enqueueWork(() -> SereneSeasonsPlusClientForge.init(context));
        MinecraftForge.EVENT_BUS.register(SereneSeasonsPlusClientForge.class);
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        SereneService.HANDLER.shutdown();
        SereneService.HANDLER = null;
        EnvironmentHelper.onServerStopping(event.getServer().m_129880_(Level.f_46428_));
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.END || !event.haveTime()) {
            return;
        }
        ServerLevel level = (ServerLevel)event.level;
        if (level.m_46472_() != Level.f_46428_) {
            return;
        }
        this.onTick((Level)level, (Boolean)SereneExtendedConfig.ENABLE_SEASONAL_DAYLIGHT_CYCLE.get(), (Boolean)SereneExtendedConfig.CUSTOM_CYCLE_LENGTH.get(), (Double)SereneExtendedConfig.CUSTOM_DAY_LENGTH.get(), (Double)SereneExtendedConfig.CUSTOM_NIGHT_LENGTH.get());
        CommonSnowBlockFeature.handleServerTick(level.m_7654_(), level);
    }

    @SubscribeEvent
    public void onConfigReload(TickEvent.ServerTickEvent event) {
        CommonSnowBlockFeature.onConfigReload((Integer)SereneExtendedConfig.TICK_SNOW_REPLACER.get(), (Boolean)SereneExtendedConfig.SNOWSTORM_ENABLED.get(), (Integer)SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get());
        SereneService.reloadConfig();
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (!(chunkAccess instanceof LevelChunk)) {
            return;
        }
        LevelChunk chunk = (LevelChunk)chunkAccess;
        Level level = chunk.m_62953_();
        if (level.m_5776_()) {
            return;
        }
        if (level.m_46472_() != Level.f_46428_) {
            return;
        }
        CommonSnowBlockFeature.handleOnChunkLoad(chunk);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        int activeId;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (level.m_46472_() != Level.f_46428_) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (!state.m_60713_(Blocks.f_50125_) && !state.m_60713_(Blocks.f_50127_)) {
            return;
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        int n = activeId = sd != null ? sd.currentStormId : 0;
        if (activeId <= 0) {
            return;
        }
        LevelChunk chunk = level.m_7726_().m_62227_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, false);
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        if (tracked.sereneseasonsplus$getDestroyedStormId() != activeId) {
            tracked.sereneseasonsplus$getDestroyedColumns().clear();
            tracked.sereneseasonsplus$setDestroyedStormId(activeId);
        }
        long xz = (long)pos.m_123341_() << 32 ^ (long)pos.m_123343_() & 0xFFFFFFFFL;
        tracked.sereneseasonsplus$getDestroyedColumns().add(xz);
        tracked.sereneseasonsplus$getSnowColumns().keySet().removeIf(p -> p.m_123341_() == pos.m_123341_() && p.m_123343_() == pos.m_123343_());
        chunk.m_8092_(true);
    }
}

