/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.wtwoa.mixin.weather2;

import com.litewolf101.wtwoa.events.modded.WeatherEvent;
import java.util.HashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import weather2.weathersystem.WeatherManager;
import weather2.weathersystem.storm.WeatherObject;

@Mixin(value={WeatherManager.class})
public class WeatherManagerEventListener {
    @Shadow
    public HashMap<Long, WeatherObject> lookupStormObjectsByID;

    @Inject(method={"addStormObject"}, at={@At(value="TAIL")}, remap=false)
    protected void onAddStormObject(WeatherObject so, CallbackInfo ci) {
        if (this.lookupStormObjectsByID.containsKey(so.ID)) {
            WeatherEvent.OnStormObjectAdded evt = new WeatherEvent.OnStormObjectAdded(so);
            MinecraftForge.EVENT_BUS.post((Event)evt);
        }
    }

    @Inject(method={"removeStormObject"}, at={@At(value="HEAD")}, remap=false)
    protected void onRemoveStormObject(long ID, CallbackInfo ci) {
        WeatherObject so = this.lookupStormObjectsByID.get(ID);
        if (so != null) {
            WeatherEvent.OnStormObjectRemoved evt = new WeatherEvent.OnStormObjectRemoved(so);
            MinecraftForge.EVENT_BUS.post((Event)evt);
        }
    }
}

