/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.wtwoa.mixin.weather2;

import com.corosus.coroutil.util.CoroUtilParticle;
import com.litewolf101.wtwoa.utils.ModMixinUtil;
import java.awt.Color;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import weather2.ClientTickHandler;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.TornadoHelper;

@Mixin(value={StormObject.class})
public class ClientTornadoColorizer {
    @Shadow
    public Vec3 posBaseFormationPos;
    @Shadow
    public int levelCurIntensityStage;
    @Shadow
    public boolean attrib_precipitation;
    @Shadow
    public int levelWater;
    @Shadow
    public int levelWaterStartRaining;
    @Shadow
    public TornadoHelper tornadoHelper;

    @ModifyArg(method={"spawnFogParticle(DDDILnet/minecraft/client/renderer/texture/TextureAtlasSprite;)Lextendedrenderer/particle/entity/EntityRotFX;"}, at=@At(value="INVOKE", target="Lextendedrenderer/particle/entity/EntityRotFX;setColor(FFF)V", ordinal=0), index=0)
    private float modifyTornadoParticleColorRed(float r) {
        if (this.tornadoHelper.storm.isTornadoFormingOrGreater()) {
            WeatherManagerClient manager = ClientTickHandler.getClientWeather();
            if (manager.getWorld().f_46443_) {
                float finalBright;
                float randFloat = CoroUtilParticle.rand.nextFloat() * 0.6f;
                float baseBright = 0.7f;
                if (this.levelCurIntensityStage > StormObject.STATE_NORMAL) {
                    baseBright = 0.2f;
                } else if (this.attrib_precipitation) {
                    baseBright = 0.2f;
                } else if (manager.isVanillaRainActiveOnServer) {
                    baseBright = 0.2f;
                } else {
                    finalBright = Math.min(1.0f, (float)(this.levelWater / this.levelWaterStartRaining)) * 0.6f;
                    baseBright -= finalBright;
                }
                finalBright = Math.min(1.0f, baseBright + randFloat);
                int color = ModMixinUtil.materialColorFromBlockPosition(manager.getWorld(), this.tornadoHelper.storm.posGround);
                if (color > -1) {
                    return (float)new Color(color, true).getRed() / 255.0f;
                }
                return r;
            }
        }
        return r;
    }

    @ModifyArg(method={"spawnFogParticle(DDDILnet/minecraft/client/renderer/texture/TextureAtlasSprite;)Lextendedrenderer/particle/entity/EntityRotFX;"}, at=@At(value="INVOKE", target="Lextendedrenderer/particle/entity/EntityRotFX;setColor(FFF)V", ordinal=0), index=1)
    private float modifyTornadoParticleColorGreen(float g) {
        if (this.tornadoHelper.storm.isTornadoFormingOrGreater()) {
            WeatherManagerClient manager = ClientTickHandler.getClientWeather();
            if (manager.getWorld().f_46443_) {
                float finalBright;
                float randFloat = CoroUtilParticle.rand.nextFloat() * 0.6f;
                float baseBright = 0.7f;
                if (this.levelCurIntensityStage > StormObject.STATE_NORMAL) {
                    baseBright = 0.2f;
                } else if (this.attrib_precipitation) {
                    baseBright = 0.2f;
                } else if (manager.isVanillaRainActiveOnServer) {
                    baseBright = 0.2f;
                } else {
                    finalBright = Math.min(1.0f, (float)(this.levelWater / this.levelWaterStartRaining)) * 0.6f;
                    baseBright -= finalBright;
                }
                finalBright = Math.min(1.0f, baseBright + randFloat);
                int color = ModMixinUtil.materialColorFromBlockPosition(manager.getWorld(), this.tornadoHelper.storm.posGround);
                if (color > -1) {
                    return (float)new Color(color, true).getGreen() / 255.0f;
                }
                return g;
            }
        }
        return g;
    }

    @ModifyArg(method={"spawnFogParticle(DDDILnet/minecraft/client/renderer/texture/TextureAtlasSprite;)Lextendedrenderer/particle/entity/EntityRotFX;"}, at=@At(value="INVOKE", target="Lextendedrenderer/particle/entity/EntityRotFX;setColor(FFF)V", ordinal=0), index=2)
    private float modifyTornadoParticleColorBlue(float b) {
        if (this.tornadoHelper.storm.isTornadoFormingOrGreater()) {
            WeatherManagerClient manager = ClientTickHandler.getClientWeather();
            if (manager.getWorld().f_46443_) {
                float finalBright;
                float randFloat = CoroUtilParticle.rand.nextFloat() * 0.6f;
                float baseBright = 0.7f;
                if (this.levelCurIntensityStage > StormObject.STATE_NORMAL) {
                    baseBright = 0.2f;
                } else if (this.attrib_precipitation) {
                    baseBright = 0.2f;
                } else if (manager.isVanillaRainActiveOnServer) {
                    baseBright = 0.2f;
                } else {
                    finalBright = Math.min(1.0f, (float)(this.levelWater / this.levelWaterStartRaining)) * 0.6f;
                    baseBright -= finalBright;
                }
                finalBright = Math.min(1.0f, baseBright + randFloat);
                int color = ModMixinUtil.materialColorFromBlockPosition(manager.getWorld(), this.tornadoHelper.storm.posGround);
                if (color > -1) {
                    return (float)new Color(color, true).getBlue() / 255.0f;
                }
                return b;
            }
        }
        return b;
    }
}

