/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.wtwoa.compat.journeymap;

import com.litewolf101.wtwoa.Weather2Additions;
import java.awt.geom.Point2D;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IOverlayListener;
import journeymap.client.api.display.MarkerOverlay;
import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.util.UIState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import weather2.weathersystem.storm.StormObject;

public class SampleMarkerOverlayFactory {
    static MarkerOverlay create(MapImage image, StormObject object, IClientAPI jmAPI, BlockPos center) {
        MarkerOverlay markerOverlay = new MarkerOverlay("wtwoa", String.valueOf(object.ID), center, image);
        markerOverlay.setDimension(Level.f_46428_).setTitle(new BlockPos((int)object.pos.f_82479_, (int)object.pos.f_82480_, (int)object.pos.f_82481_).toString().substring(9)).setLabel(SampleMarkerOverlayFactory.updateOrGetLabel(object));
        try {
            jmAPI.show((Displayable)markerOverlay);
        }
        catch (Exception e) {
            Weather2Additions.LOGGER.error("Can't add marker overlay", (Throwable)e);
        }
        return markerOverlay;
    }

    private static String updateOrGetLabel(StormObject object) {
        int stage = object.levelCurIntensityStage;
        return switch (stage) {
            case 1 -> "Thunder Storm";
            case 2 -> "High Wind Storm";
            case 3 -> "Hail Storm";
            default -> object.isTornadoFormingOrGreater() ? "Tornado - F" + (object.levelCurIntensityStage - 4) : (object.isCycloneFormingOrGreater() ? "Hurricane - C" + (object.levelCurIntensityStage - 4) : "Rain Storm");
        };
    }

    static class MarkerListener
    implements IOverlayListener {
        final IClientAPI jmAPI;
        final MarkerOverlay overlay;
        final int color;
        final float opacity;

        MarkerListener(IClientAPI jmAPI, MarkerOverlay overlay) {
            this.jmAPI = jmAPI;
            this.overlay = overlay;
            this.color = overlay.getIcon().getColor();
            this.opacity = overlay.getIcon().getOpacity();
        }

        public void onActivate(UIState uiState) {
            this.refresh(uiState);
        }

        public void onDeactivate(UIState uiState) {
            this.refresh(uiState);
        }

        public void onMouseMove(UIState uiState, Point2D.Double mousePosition, BlockPos blockPosition) {
        }

        public void onMouseOut(UIState uiState, Point2D.Double mousePosition, BlockPos blockPosition) {
            this.refresh(uiState);
        }

        public boolean onMouseClick(UIState uiState, Point2D.Double mousePosition, BlockPos blockPosition, int button, boolean doubleClick) {
            return true;
        }

        public void onOverlayMenuPopup(UIState mapState, Point2D.Double mousePosition, BlockPos blockPosition, ModPopupMenu modPopupMenu) {
        }

        private void refresh(UIState uiState) {
            double size = uiState.blockSize;
            this.overlay.getIcon().setColor(this.color).setOpacity(this.opacity).setDisplayWidth(size).setDisplayHeight(size).setAnchorX(size / 2.0).setAnchorY(size);
            this.overlay.flagForRerender();
        }
    }
}

