/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.wtwoa.compat.journeymap;

import com.litewolf101.wtwoa.Weather2Additions;
import com.litewolf101.wtwoa.compat.journeymap.ForgeEventListener;
import java.util.EnumSet;
import javax.annotation.Nullable;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.event.ClientEvent;
import net.minecraftforge.common.MinecraftForge;

@ClientPlugin
public class JourneyMapPlugin
implements IClientPlugin {
    private static JourneyMapPlugin instance;
    private IClientAPI jmAPI;
    private boolean hasJMStarted;
    private ForgeEventListener forgeEventListener;

    @Nullable
    public static JourneyMapPlugin getInstance() {
        return instance;
    }

    public void initialize(IClientAPI iClientAPI) {
        this.jmAPI = iClientAPI;
        instance = this;
        this.forgeEventListener = new ForgeEventListener(this.jmAPI);
        MinecraftForge.EVENT_BUS.register((Object)this.forgeEventListener);
        iClientAPI.subscribe("wtwoa", EnumSet.of(ClientEvent.Type.MAPPING_STARTED, ClientEvent.Type.MAPPING_STOPPED, ClientEvent.Type.MAP_MOUSE_MOVED));
    }

    public String getModId() {
        return "wtwoa";
    }

    public void onEvent(ClientEvent clientEvent) {
        try {
            switch (clientEvent.type) {
                case MAPPING_STARTED: {
                    this.onMappingStarted(clientEvent);
                    break;
                }
                case MAPPING_STOPPED: {
                    this.onMappingStopped(clientEvent);
                    break;
                }
                case DISPLAY_UPDATE: {
                    this.onDisplayUpdated(clientEvent);
                }
            }
        }
        catch (Throwable t) {
            Weather2Additions.LOGGER.error(t.getMessage(), t);
        }
    }

    private void onDisplayUpdated(ClientEvent event) {
    }

    private void onMappingStopped(ClientEvent event) {
        if (this.jmAPI.playerAccepts("wtwoa", DisplayType.Marker)) {
            this.jmAPI.removeAll(this.getModId());
        }
    }

    private void onMappingStarted(ClientEvent event) throws Exception {
    }
}

