/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.wtwoa.compat.journeymap;

import com.litewolf101.wtwoa.Weather2Additions;
import com.litewolf101.wtwoa.compat.journeymap.SampleMarkerOverlayFactory;
import com.litewolf101.wtwoa.events.modded.WeatherEvent;
import java.util.HashMap;
import java.util.Map;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.MarkerOverlay;
import journeymap.client.api.model.MapImage;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import weather2.weathersystem.storm.StormObject;

public class ForgeEventListener {
    private final IClientAPI jmAPI;
    private final Map<StormObject, MarkerOverlay> stormMarkers;

    public ForgeEventListener(IClientAPI api) {
        this.jmAPI = api;
        this.stormMarkers = new HashMap<StormObject, MarkerOverlay>();
    }

    private MapImage updateOrGetIcon(StormObject object) {
        int stage = object.levelCurIntensityStage;
        MapImage icon = new MapImage(switch (stage) {
            case 1 -> new ResourceLocation("wtwoa", "textures/dev/lightning_icon_jm.png");
            case 2 -> new ResourceLocation("wtwoa", "textures/dev/high_wind_icon_jm.png");
            case 3 -> new ResourceLocation("wtwoa", "textures/dev/hail_icon_jm.png");
            default -> object.isTornadoFormingOrGreater() ? new ResourceLocation("wtwoa", "textures/dev/tornado_icon_jm.png") : (object.isCycloneFormingOrGreater() ? new ResourceLocation("wtwoa", "textures/dev/cyclone_icon_jm.png") : new ResourceLocation("wtwoa", "textures/dev/rain_icon_jm.png"));
        }, 0, 0, 64, 64, -1, 1.0f);
        icon.centerAnchors();
        return icon;
    }

    @SubscribeEvent
    public void onStormAdded(WeatherEvent.OnStormObjectAdded event) {
        if (event.getWeatherObject().manager.getWorld().f_46443_ && event.getWeatherObject() instanceof StormObject && ((StormObject)event.getWeatherObject()).isPrecipitating() && this.jmAPI.playerAccepts("wtwoa", DisplayType.Image) && !this.stormMarkers.containsValue(event.getWeatherObject())) {
            MarkerOverlay markerOverlay = SampleMarkerOverlayFactory.create(this.updateOrGetIcon((StormObject)event.getWeatherObject()), (StormObject)event.getWeatherObject(), this.jmAPI, new BlockPos((int)event.getWeatherObject().pos.f_82479_, (int)event.getWeatherObject().pos.f_82480_, (int)event.getWeatherObject().pos.f_82481_));
            this.stormMarkers.put((StormObject)event.getWeatherObject(), markerOverlay);
        }
    }

    @SubscribeEvent
    public void onStormRemoved(WeatherEvent.OnStormObjectRemoved event) {
        if (this.stormMarkers.containsValue(event.getWeatherObject())) {
            System.out.println("Killed ya");
            this.jmAPI.remove((Displayable)this.stormMarkers.get(event.getWeatherObject()));
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        try {
            if (event.level.f_46443_ && this.jmAPI.playerAccepts("wtwoa", DisplayType.Image)) {
                this.stormMarkers.forEach((storm, marker) -> {
                    if (storm == null || storm.isDead) {
                        this.jmAPI.remove((Displayable)marker);
                    } else {
                        marker.setPoint(new BlockPos((int)storm.pos.f_82479_, (int)storm.pos.f_82480_, (int)storm.pos.f_82481_));
                        marker.setIcon(this.updateOrGetIcon((StormObject)storm));
                        marker.setTitle(marker.getPoint().toString());
                        marker.setLabel(this.updateOrGetLabel((StormObject)storm));
                        marker.flagForRerender();
                    }
                });
            }
        }
        catch (Throwable t) {
            Weather2Additions.LOGGER.error(t.getMessage(), t);
        }
    }

    private String updateOrGetLabel(StormObject object) {
        int stage = object.levelCurIntensityStage;
        return switch (stage) {
            case 1 -> "Thunder Storm";
            case 2 -> "High Wind Storm";
            case 3 -> "Hail Storm";
            default -> object.isTornadoFormingOrGreater() ? "Tornado - F" + (object.levelCurIntensityStage - 4) : (object.isCycloneFormingOrGreater() ? "Hurricane - C" + (object.levelCurIntensityStage - 4) : "Rain Storm");
        };
    }
}

