/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.wtwoa.client.renderer;

import com.litewolf101.wtwoa.blocks.entities.RadarBlockEntity;
import com.litewolf101.wtwoa.utils.StormTypeUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import weather2.ClientTickHandler;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.storm.EnumWeatherObjectType;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;

public class RadarBlockEntityRenderer
implements BlockEntityRenderer<RadarBlockEntity> {
    private static final ResourceLocation CYCLONE = new ResourceLocation("wtwoa", "textures/dev/cyclone_icon.png");
    private static final ResourceLocation HAIL = new ResourceLocation("wtwoa", "textures/dev/hail_icon.png");
    private static final ResourceLocation HIGH_WIND = new ResourceLocation("wtwoa", "textures/dev/high_wind_icon.png");
    private static final ResourceLocation LIGHTNING = new ResourceLocation("wtwoa", "textures/dev/lightning_icon.png");
    private static final ResourceLocation RAIN = new ResourceLocation("wtwoa", "textures/dev/rain_icon.png");
    private static final ResourceLocation SANDSTORM = new ResourceLocation("wtwoa", "textures/dev/sandstorm_icon.png");
    private static final ResourceLocation SNOWSTORM = new ResourceLocation("wtwoa", "textures/dev/snowstorm_icon.png");
    private static final ResourceLocation TORNADO = new ResourceLocation("wtwoa", "textures/dev/tornado_icon.png");
    private static final RenderType CYCLONE_TYPE = RenderType.m_110473_((ResourceLocation)CYCLONE);
    private static final RenderType HAIL_TYPE = RenderType.m_110473_((ResourceLocation)HAIL);
    private static final RenderType HIGH_WIND_TYPE = RenderType.m_110473_((ResourceLocation)HIGH_WIND);
    private static final RenderType LIGHTNING_TYPE = RenderType.m_110473_((ResourceLocation)LIGHTNING);
    private static final RenderType RAIN_TYPE = RenderType.m_110473_((ResourceLocation)RAIN);
    private static final RenderType SANDSTORM_TYPE = RenderType.m_110473_((ResourceLocation)SANDSTORM);
    private static final RenderType SNOWSTORM_TYPE = RenderType.m_110473_((ResourceLocation)SNOWSTORM);
    private static final RenderType TORNADO_TYPE = RenderType.m_110473_((ResourceLocation)TORNADO);
    private final BlockEntityRendererProvider.Context context;
    public List<StormTypeUtil> storms = new ArrayList<StormTypeUtil>();

    public RadarBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    private static void renderMarker(BlockEntityRendererProvider.Context context, PoseStack stack, MultiBufferSource bufferSource, int light, int color, float xPos, float zPos) {
        stack.m_85836_();
        PoseStack.Pose posestacktext = stack.m_85850_();
        Matrix4f matrix4ftext = posestacktext.m_252922_();
        stack.m_252880_(0.5f + xPos, 1.1f, 0.5f + zPos);
        stack.m_252781_(new Quaternionf(0.0f, context.m_234446_().m_253208_().y, 0.0f, context.m_234446_().m_253208_().w));
        stack.m_85841_(0.01f, 0.01f, 0.01f);
        context.m_173586_().m_271703_("|", 0.0f, 0.0f, color, false, matrix4ftext, bufferSource, Font.DisplayMode.NORMAL, 0, light);
        stack.m_85849_();
    }

    private static void renderSpecialIcon(Vec3 BEPosition, BlockEntityRendererProvider.Context context, PoseStack stack, MultiBufferSource bufferSource, int light, Vec3 position, WeatherObject object) {
        float xposOffset = (float)(position.f_82479_ - BEPosition.f_82479_) / 768.0f;
        float zposOffset = (float)(position.f_82481_ - BEPosition.f_82481_) / 768.0f;
        RadarBlockEntityRenderer.renderMarker(context, stack, bufferSource, light, -1, 0.0f, 0.0f);
        stack.m_85836_();
        stack.m_252880_(0.5f + xposOffset, 1.25f, 0.5f + zposOffset);
        stack.m_85841_(0.25f, 0.25f, 0.25f);
        stack.m_252781_(context.m_234446_().m_253208_());
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose posestack$pose2 = stack.m_85850_();
        Matrix4f matrix4f2 = posestack$pose2.m_252922_();
        Matrix3f matrix3f2 = posestack$pose2.m_252943_();
        VertexConsumer vertexconsumer2 = switch (object.weatherObjectType) {
            case EnumWeatherObjectType.SAND -> bufferSource.m_6299_(SANDSTORM_TYPE);
            case EnumWeatherObjectType.SNOW -> bufferSource.m_6299_(SNOWSTORM_TYPE);
            default -> bufferSource.m_6299_(RAIN_TYPE);
        };
        RadarBlockEntityRenderer.vertex(vertexconsumer2, matrix4f2, matrix3f2, light, 0.0f, 0, 0, 1);
        RadarBlockEntityRenderer.vertex(vertexconsumer2, matrix4f2, matrix3f2, light, 1.0f, 0, 1, 1);
        RadarBlockEntityRenderer.vertex(vertexconsumer2, matrix4f2, matrix3f2, light, 1.0f, 1, 1, 0);
        RadarBlockEntityRenderer.vertex(vertexconsumer2, matrix4f2, matrix3f2, light, 0.0f, 1, 0, 0);
        stack.m_85849_();
    }

    private static void renderWeatherIcon(Vec3 BEPosition, BlockEntityRendererProvider.Context context, PoseStack stack, MultiBufferSource bufferSource, int light, Vec3 position, StormTypeUtil util) {
        float xposOffset = (float)(position.f_82479_ - BEPosition.f_82479_) / 768.0f;
        float zposOffset = (float)(position.f_82481_ - BEPosition.f_82481_) / 768.0f;
        if (util.isIntensifying()) {
            RadarBlockEntityRenderer.renderMarker(context, stack, bufferSource, light, ChatFormatting.GREEN.m_126665_(), xposOffset, zposOffset);
        } else {
            RadarBlockEntityRenderer.renderMarker(context, stack, bufferSource, light, ChatFormatting.RED.m_126665_(), xposOffset, zposOffset);
        }
        stack.m_85836_();
        stack.m_252880_(0.5f + xposOffset, 1.25f, 0.5f + zposOffset);
        stack.m_85841_(0.25f, 0.25f, 0.25f);
        stack.m_252781_(context.m_234446_().m_253208_());
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose posestack$pose2 = stack.m_85850_();
        Matrix4f matrix4f2 = posestack$pose2.m_252922_();
        Matrix3f matrix3f2 = posestack$pose2.m_252943_();
        VertexConsumer vertexconsumer2 = bufferSource.m_6299_(PreStageType.RAIN.byStormType(util.getStormType() == StormObject.TYPE_LAND, util.getStormStage()));
        RadarBlockEntityRenderer.vertex(vertexconsumer2, matrix4f2, matrix3f2, light, 0.0f, 0, 0, 1);
        RadarBlockEntityRenderer.vertex(vertexconsumer2, matrix4f2, matrix3f2, light, 1.0f, 0, 1, 1);
        RadarBlockEntityRenderer.vertex(vertexconsumer2, matrix4f2, matrix3f2, light, 1.0f, 1, 1, 0);
        RadarBlockEntityRenderer.vertex(vertexconsumer2, matrix4f2, matrix3f2, light, 0.0f, 1, 0, 0);
        if (util.getStormType() == StormObject.TYPE_LAND && util.getStormStage() >= StormObject.STATE_FORMING) {
            stack.m_85836_();
            PoseStack.Pose posestacktext = stack.m_85850_();
            Matrix4f matrix4ftext = posestacktext.m_252922_();
            stack.m_252880_(-0.5f, 1.4f, 0.0f);
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            stack.m_85841_(0.075f, 0.075f, 0.075f);
            context.m_173586_().m_271703_("F" + (util.getStormStage() - 4), 0.0f, 0.0f, -1, false, matrix4ftext, bufferSource, Font.DisplayMode.NORMAL, 0, light);
            stack.m_85849_();
        } else if (util.getStormType() == StormObject.TYPE_WATER && util.getStormStage() >= StormObject.STATE_FORMING) {
            stack.m_85836_();
            PoseStack.Pose posestacktext = stack.m_85850_();
            Matrix4f matrix4ftext = posestacktext.m_252922_();
            stack.m_252880_(-0.5f, 1.4f, 0.0f);
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            stack.m_85841_(0.075f, 0.075f, 0.075f);
            context.m_173586_().m_271703_("C" + (util.getStormStage() - 4), 0.0f, 0.0f, -1, false, matrix4ftext, bufferSource, Font.DisplayMode.NORMAL, 0, light);
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    private static void vertex(VertexConsumer consumer, Matrix4f matrix4f, Matrix3f matrix3f, int p_253829_, float p_253995_, int p_254031_) {
        consumer.m_252986_(matrix4f, p_253995_, (float)p_254031_, 0.0f).m_6122_(0, 0, 0, 100).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(p_253829_).m_252939_(matrix3f, 0.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void vertex(VertexConsumer p_254095_, Matrix4f p_254477_, Matrix3f p_253948_, int p_253829_, float p_253995_, int p_254031_, int p_253641_, int p_254243_) {
        p_254095_.m_252986_(p_254477_, p_253995_ - 0.5f, (float)p_254031_ - 0.25f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)p_253641_, (float)p_254243_).m_86008_(OverlayTexture.f_118083_).m_85969_(p_253829_).m_252939_(p_253948_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public void render(RadarBlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        stack.m_85836_();
        RadarBlockEntityRenderer.renderMarker(this.context, stack, bufferSource, light, ChatFormatting.BLUE.m_126665_(), 0.0f, 0.0f);
        stack.m_252880_(-1.0f, 1.0001f, 2.0f);
        stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        PoseStack.Pose posestack$pose = stack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110466_());
        RadarBlockEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, 0.0f, 0);
        RadarBlockEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, 3.0f, 0);
        RadarBlockEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, 3.0f, 3);
        RadarBlockEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, 0.0f, 3);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        stack.m_85849_();
        WeatherManagerClient wmc = ClientTickHandler.getClientWeather();
        wmc.getStormObjects().stream().filter(storm -> storm.pos.m_82554_(blockEntity.m_58899_().m_252807_()) < 1024.0).forEach(storm -> {
            if (storm instanceof StormObject) {
                StormTypeUtil util = new StormTypeUtil((StormObject)storm);
                if (!((StormObject)storm).isCloudlessStorm() && ((StormObject)storm).isPrecipitating()) {
                    RadarBlockEntityRenderer.renderWeatherIcon(blockEntity.m_58899_().m_252807_(), this.context, stack, bufferSource, light, util.getPos(), util);
                }
            } else {
                RadarBlockEntityRenderer.renderSpecialIcon(blockEntity.m_58899_().m_252807_(), this.context, stack, bufferSource, light, storm.pos, storm);
            }
        });
    }

    public void setStorms(List<StormTypeUtil> storms) {
        this.storms = storms;
    }

    public static enum PreStageType {
        RAIN(RAIN_TYPE),
        LIGHTNING(LIGHTNING_TYPE),
        HIGH_WIND(HIGH_WIND_TYPE),
        HAIL(HAIL_TYPE),
        TORNADO(TORNADO_TYPE),
        CYCLONE(CYCLONE_TYPE);

        RenderType icon;

        private PreStageType(RenderType icon) {
            this.icon = icon;
        }

        public RenderType getIcon() {
            return this.icon;
        }

        public RenderType byStormType(boolean isLand, int stage) {
            if (isLand && stage >= StormObject.STATE_FORMING) {
                return TORNADO_TYPE;
            }
            if (!isLand && stage >= StormObject.STATE_FORMING) {
                return CYCLONE_TYPE;
            }
            if (stage == StormObject.STATE_NORMAL) {
                return RAIN_TYPE;
            }
            if (stage == StormObject.STATE_THUNDER) {
                return LIGHTNING_TYPE;
            }
            if (stage == StormObject.STATE_HIGHWIND) {
                return HIGH_WIND_TYPE;
            }
            if (stage == StormObject.STATE_HAIL) {
                return HAIL_TYPE;
            }
            return RAIN_TYPE;
        }
    }
}

