/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;
import org.apache.commons.compress.utils.Lists;

public class ModEnchantTableRenderer
extends EnchantTableRenderer {
    public ModEnchantTableRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void m_6922_(EnchantmentTableBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        super.m_6922_(blockEntity, partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        Container container = (Container)blockEntity;
        ItemStack itemToEnchant = container.m_8020_(0);
        ItemStack enchantingStack = container.m_8020_(1);
        ItemStack rerollStack = container.m_8020_(2);
        int posData = (int)blockEntity.m_58899_().m_121878_();
        switch (((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).renderContentsType) {
            case FLAT: {
                List<ItemStack> items = ModEnchantTableRenderer.getItemsList(itemToEnchant, enchantingStack, rerollStack);
                this.renderFlatItemList(items, blockEntity.m_58899_(), poseStack, bufferIn, combinedLightIn, combinedOverlayIn, blockEntity.m_58904_(), posData);
                break;
            }
            case FLOATING: {
                List<ItemStack> items = ModEnchantTableRenderer.getItemsList(ItemStack.f_41583_, enchantingStack, rerollStack);
                this.renderHoveringItem(blockEntity, itemToEnchant, partialTicks, poseStack, bufferIn, combinedLightIn);
                this.renderHoveringItemList(items, (float)blockEntity.f_59251_ + partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, true, blockEntity.m_58904_(), posData);
            }
        }
    }

    private static List<ItemStack> getItemsList(ItemStack itemToEnchant, ItemStack enchantingStack, ItemStack rerollStack) {
        ArrayList items = Lists.newArrayList();
        items.add(itemToEnchant);
        for (int i = 0; i < 3; ++i) {
            if (i < enchantingStack.m_41613_()) {
                items.add(enchantingStack);
            }
            if (i >= rerollStack.m_41613_()) continue;
            items.add(rerollStack);
        }
        items.removeIf(ItemStack::m_41619_);
        return items;
    }

    private void renderFlatItemList(List<ItemStack> items, BlockPos pos, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Level level, int posData) {
        int randomDirection = Math.abs(pos.m_123341_() + pos.m_123343_()) % 4;
        for (int i = 0; i < Math.min(4, items.size()); ++i) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.76171875, 0.5);
            Direction direction = Direction.m_122407_((int)((i + randomDirection) % 4));
            float horizontalAngle = -direction.m_122435_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(horizontalAngle));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85837_(-0.3125, -0.3125, 0.0);
            poseStack.m_85841_(0.375f, 0.375f, 0.375f);
            ItemStack renderStack = items.get(i);
            Minecraft.m_91087_().m_91291_().m_269128_(renderStack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, level, posData + i);
            poseStack.m_85849_();
        }
    }

    private void renderHoveringItem(EnchantmentTableBlockEntity blockEntity, ItemStack itemToEnchant, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        if (blockEntity.f_59256_ == 0.0f && blockEntity.f_59257_ == 0.0f) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.0f, 0.5f);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(itemToEnchant, blockEntity.m_58904_(), null, 0);
        float hoverOffset = Mth.m_14031_((float)(((float)blockEntity.f_59251_ + partialTicks) / 10.0f)) * 0.1f + 0.1f;
        float modelYScale = model.m_7442_().m_269404_((ItemDisplayContext)ItemDisplayContext.GROUND).f_111757_.y();
        float openness = Mth.m_14179_((float)partialTicks, (float)blockEntity.f_59257_, (float)blockEntity.f_59256_);
        poseStack.m_85837_(0.0, (double)(hoverOffset + 0.25f * modelYScale * openness - 0.15f * (1.0f - openness)), 0.0);
        float scale = openness * 0.8f + 0.2f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(Axis.f_252436_.m_252961_(((float)blockEntity.f_59251_ + partialTicks) / 20.0f));
        Minecraft.m_91087_().m_91291_().m_115143_(itemToEnchant, ItemDisplayContext.GROUND, false, poseStack, bufferIn, combinedLightIn, OverlayTexture.f_118083_, model);
        poseStack.m_85849_();
    }

    private void renderHoveringItemList(List<ItemStack> items, float age, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, boolean rotateItems, Level level, int posData) {
        float itemRenderAngle = 360.0f / (float)items.size();
        for (int i = 0; i < items.size(); ++i) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 1.0f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * itemRenderAngle + age));
            poseStack.m_252880_(0.75f, 0.0f, 0.25f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotateItems ? age % 360.0f : 90.0f));
            poseStack.m_85837_(0.0, 0.075 * Math.sin(((double)age + (double)i * 10.0) / 5.0), 0.0);
            Minecraft.m_91087_().m_91291_().m_269128_(items.get(i), ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, level, posData + i);
            poseStack.m_85849_();
        }
    }
}

