/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenHitBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenHitTileEntity;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;

public class ScreenBlock
extends BaseBlock {
    public static final DirectionProperty HORIZ_FACING = DirectionProperty.m_61546_((String)"horizfacing", (Predicate)Direction.Plane.HORIZONTAL);
    private final boolean creative;
    private static final Setup[] transitions = new Setup[]{new Setup(0, false), new Setup(0, true), new Setup(1, false), new Setup(1, true), new Setup(2, false), new Setup(2, true)};
    public static final VoxelShape BLOCK_AABB = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    public static final VoxelShape NORTH_AABB = Shapes.m_83048_((double)0.01f, (double)0.01f, (double)0.9375, (double)0.99f, (double)0.99f, (double)1.0);
    public static final VoxelShape SOUTH_AABB = Shapes.m_83048_((double)0.01f, (double)0.01f, (double)0.0, (double)0.99f, (double)0.99f, (double)0.0625);
    public static final VoxelShape WEST_AABB = Shapes.m_83048_((double)0.9375, (double)0.01f, (double)0.01f, (double)1.0, (double)0.99f, (double)0.99f);
    public static final VoxelShape EAST_AABB = Shapes.m_83048_((double)0.0, (double)0.01f, (double)0.01f, (double)0.0625, (double)0.99f, (double)0.99f);
    public static final VoxelShape UP_AABB = Shapes.m_83048_((double)0.01f, (double)0.0, (double)0.01f, (double)1.0, (double)0.061875f, (double)0.99f);
    public static final VoxelShape DOWN_AABB = Shapes.m_83048_((double)0.01f, (double)0.9375, (double)0.01f, (double)0.99f, (double)1.0, (double)0.99f);

    public ScreenBlock(BlockEntityType.BlockEntitySupplier<BlockEntity> supplier, boolean creative) {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:machines/screen")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(supplier));
        this.creative = creative;
    }

    public boolean isCreative() {
        return this.creative;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)HORIZ_FACING, (Comparable)context.m_43723_().m_6350_().m_122424_());
    }

    public static boolean hasModuleProvider(ItemStack stack) {
        return stack.m_41720_() instanceof IModuleProvider;
    }

    public static LazyOptional<IModuleProvider> getModuleProvider(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IModuleProvider) {
            return LazyOptional.of(() -> (IModuleProvider)item);
        }
        return stack.getCapability(IModuleProvider.CAPABILITY);
    }

    public InteractionResult activate(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        return this.m_6227_(state, world, pos, player, hand, result);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot) {
        return state;
    }

    public void m_6256_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player) {
        if (world.f_46443_) {
            HitResult mouseOver = SafeClientTools.getClientMouseOver();
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.m_7702_(pos);
            if (mouseOver instanceof BlockHitResult) {
                BlockHitResult blockResult = (BlockHitResult)mouseOver;
                screenTileEntity.hitScreenClient(mouseOver.m_82450_().f_82479_ - (double)pos.m_123341_(), mouseOver.m_82450_().f_82480_ - (double)pos.m_123342_(), mouseOver.m_82450_().f_82481_ - (double)pos.m_123343_(), blockResult.m_82434_(), (Direction)world.m_8055_(pos).m_61143_((Property)HORIZ_FACING));
            }
        }
    }

    private void setInvisibleBlockSafe(Level world, BlockPos pos, int dx, int dy, int dz, Direction facing) {
        int zz;
        int yy = pos.m_123342_() + dy;
        if (yy < world.m_141937_() || yy >= world.m_151558_()) {
            return;
        }
        int xx = pos.m_123341_() + dx;
        BlockPos posO = new BlockPos(xx, yy, zz = pos.m_123343_() + dz);
        if (world.m_46859_(posO)) {
            world.m_7731_(posO, (BlockState)((ScreenHitBlock)ScreenModule.SCREEN_HIT.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing), 3);
            ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.m_7702_(posO);
            screenHitTileEntity.setRelativeLocation(-dx, -dy, -dz);
        }
    }

    private void setInvisibleBlocks(Level world, BlockPos pos, int size) {
        BlockState state = world.m_8055_(pos);
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction horizontalFacing = (Direction)state.m_61143_((Property)HORIZ_FACING);
        for (int i = 0; i <= size; ++i) {
            block13: for (int j = 0; j <= size; ++j) {
                if (i == 0 && j == 0) continue;
                if (facing == Direction.NORTH) {
                    this.setInvisibleBlockSafe(world, pos, -i, -j, 0, facing);
                    continue;
                }
                if (facing == Direction.SOUTH) {
                    this.setInvisibleBlockSafe(world, pos, i, -j, 0, facing);
                    continue;
                }
                if (facing == Direction.WEST) {
                    this.setInvisibleBlockSafe(world, pos, 0, -i, j, facing);
                    continue;
                }
                if (facing == Direction.EAST) {
                    this.setInvisibleBlockSafe(world, pos, 0, -i, -j, facing);
                    continue;
                }
                if (facing == Direction.UP) {
                    switch (horizontalFacing) {
                        case NORTH: {
                            this.setInvisibleBlockSafe(world, pos, -i, 0, -j, facing);
                            break;
                        }
                        case SOUTH: {
                            this.setInvisibleBlockSafe(world, pos, i, 0, j, facing);
                            break;
                        }
                        case WEST: {
                            this.setInvisibleBlockSafe(world, pos, -i, 0, j, facing);
                            break;
                        }
                        case EAST: {
                            this.setInvisibleBlockSafe(world, pos, i, 0, -j, facing);
                        }
                    }
                    continue;
                }
                if (facing != Direction.DOWN) continue;
                switch (horizontalFacing) {
                    case NORTH: {
                        this.setInvisibleBlockSafe(world, pos, -i, 0, j, facing);
                        continue block13;
                    }
                    case SOUTH: {
                        this.setInvisibleBlockSafe(world, pos, i, 0, -j, facing);
                        continue block13;
                    }
                    case WEST: {
                        this.setInvisibleBlockSafe(world, pos, i, 0, j, facing);
                        continue block13;
                    }
                    case EAST: {
                        this.setInvisibleBlockSafe(world, pos, -i, 0, -j, facing);
                    }
                }
            }
        }
    }

    private void clearInvisibleBlockSafe(Level world, BlockPos pos) {
        if (pos.m_123342_() < world.m_141937_() || pos.m_123342_() >= world.m_151558_()) {
            return;
        }
        if (world.m_8055_(pos).m_60734_() == ScreenModule.SCREEN_HIT.get()) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    private void clearInvisibleBlocks(Level world, BlockPos pos, BlockState state, int size) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction horizontalFacing = (Direction)state.m_61143_((Property)HORIZ_FACING);
        for (int i = 0; i <= size; ++i) {
            block13: for (int j = 0; j <= size; ++j) {
                if (i == 0 && j == 0) continue;
                if (facing == Direction.NORTH) {
                    this.clearInvisibleBlockSafe(world, pos.m_7918_(-i, -j, 0));
                    continue;
                }
                if (facing == Direction.SOUTH) {
                    this.clearInvisibleBlockSafe(world, pos.m_7918_(i, -j, 0));
                    continue;
                }
                if (facing == Direction.WEST) {
                    this.clearInvisibleBlockSafe(world, pos.m_7918_(0, -i, j));
                    continue;
                }
                if (facing == Direction.EAST) {
                    this.clearInvisibleBlockSafe(world, pos.m_7918_(0, -i, -j));
                    continue;
                }
                if (facing == Direction.UP) {
                    switch (horizontalFacing) {
                        case NORTH: {
                            this.clearInvisibleBlockSafe(world, pos.m_7918_(-i, 0, -j));
                            break;
                        }
                        case SOUTH: {
                            this.clearInvisibleBlockSafe(world, pos.m_7918_(i, 0, j));
                            break;
                        }
                        case WEST: {
                            this.clearInvisibleBlockSafe(world, pos.m_7918_(-i, 0, j));
                            break;
                        }
                        case EAST: {
                            this.clearInvisibleBlockSafe(world, pos.m_7918_(i, 0, -j));
                        }
                    }
                    continue;
                }
                if (facing != Direction.DOWN) continue;
                switch (horizontalFacing) {
                    case NORTH: {
                        this.clearInvisibleBlockSafe(world, pos.m_7918_(-i, 0, j));
                        continue block13;
                    }
                    case SOUTH: {
                        this.clearInvisibleBlockSafe(world, pos.m_7918_(i, 0, -j));
                        continue block13;
                    }
                    case WEST: {
                        this.clearInvisibleBlockSafe(world, pos.m_7918_(i, 0, j));
                        continue block13;
                    }
                    case EAST: {
                        this.clearInvisibleBlockSafe(world, pos.m_7918_(-i, 0, -j));
                    }
                }
            }
        }
    }

    protected boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        this.cycleSizeTranspMode(world, pos);
        return true;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HORIZ_FACING});
    }

    public void cycleSizeTranspMode(Level world, BlockPos pos) {
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.m_7702_(pos);
        BlockState state = world.m_8055_(pos);
        this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        for (int i = 0; i < transitions.length; ++i) {
            Setup setup = transitions[i];
            if (setup.isTransparent() != screenTileEntity.isTransparent() || setup.getSize() != screenTileEntity.getSize()) continue;
            Setup next = transitions[(i + 1) % transitions.length];
            screenTileEntity.setTransparent(next.isTransparent());
            screenTileEntity.setSize(next.getSize());
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
            break;
        }
    }

    public void cycleSizeMode(Level world, BlockPos pos) {
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.m_7702_(pos);
        BlockState state = world.m_8055_(pos);
        this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        for (int i = 0; i < transitions.length; ++i) {
            Setup setup = transitions[i];
            if (setup.isTransparent() != screenTileEntity.isTransparent() || setup.getSize() != screenTileEntity.getSize()) continue;
            Setup next = transitions[(i + 2) % transitions.length];
            screenTileEntity.setTransparent(next.isTransparent());
            screenTileEntity.setSize(next.getSize());
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
            break;
        }
    }

    public void cycleTranspMode(Level world, BlockPos pos) {
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.m_7702_(pos);
        BlockState state = world.m_8055_(pos);
        this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        for (int i = 0; i < transitions.length; ++i) {
            Setup setup = transitions[i];
            if (setup.isTransparent() != screenTileEntity.isTransparent() || setup.getSize() != screenTileEntity.getSize()) continue;
            Setup next = transitions[i % 2 == 0 ? i + 1 : i - 1];
            screenTileEntity.setTransparent(next.isTransparent());
            screenTileEntity.setSize(next.getSize());
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
            break;
        }
    }

    protected boolean openGui(Level world, int x, int y, int z, Player player) {
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!itemStack.m_41619_() && itemStack.m_41720_() == Items.f_42498_) {
            int damage = itemStack.m_41773_();
            if (damage < 0) {
                damage = 0;
            } else if (damage > 15) {
                damage = 15;
            }
            DyeColor color = DyeColor.m_41053_((int)damage);
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.m_7702_(new BlockPos(x, y, z));
            screenTileEntity.setColor(color.m_284406_().f_283871_);
            return true;
        }
        if (player.m_6144_()) {
            return super.openGui(world, x, y, z, player);
        }
        if (world.f_46443_) {
            this.activateOnClient(world, new BlockPos(x, y, z));
        }
        return true;
    }

    private void activateOnClient(Level world, BlockPos pos) {
        HitResult mouseOver = SafeClientTools.getClientMouseOver();
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.m_7702_(pos);
        if (mouseOver instanceof BlockHitResult) {
            BlockHitResult hitResult = (BlockHitResult)mouseOver;
            screenTileEntity.hitScreenClient(mouseOver.m_82450_().f_82479_ - (double)pos.m_123341_(), mouseOver.m_82450_().f_82480_ - (double)pos.m_123342_(), mouseOver.m_82450_().f_82481_ - (double)pos.m_123343_(), hitResult.m_82434_(), (Direction)world.m_8055_(pos).m_61143_((Property)HORIZ_FACING));
        }
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.UP -> UP_AABB;
            case Direction.DOWN -> DOWN_AABB;
        };
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity entityLivingBase, @Nonnull ItemStack itemStack) {
        ScreenTileEntity screen;
        BlockEntity tileEntity;
        super.m_6402_(world, pos, state, entityLivingBase, itemStack);
        if (entityLivingBase instanceof Player) {
            // empty if block
        }
        if ((tileEntity = world.m_7702_(pos)) instanceof ScreenTileEntity && (screen = (ScreenTileEntity)tileEntity).getSize() > 0) {
            this.setInvisibleBlocks(world, pos, screen.getSize());
        }
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        ScreenTileEntity screen;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ScreenTileEntity && (screen = (ScreenTileEntity)te).getSize() > 0) {
            this.clearInvisibleBlocks(world, pos, state, screen.getSize());
        }
        super.m_6810_(state, world, pos, newstate, isMoving);
    }

    private static class Setup {
        private final boolean transparent;
        private final int size;

        public Setup(int size, boolean transparent) {
            this.size = size;
            this.transparent = transparent;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isTransparent() {
            return this.transparent;
        }
    }
}

