/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.trees;

import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.DynamicSaplingBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class LamentSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = LamentSpecies.createDefaultType(LamentSpecies::new);
    private Species altSpecies = Species.NULL_SPECIES;

    public void setAltSpecies(Species altSpecies) {
        if (altSpecies != this) {
            this.altSpecies = altSpecies;
        }
    }

    public LamentSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public boolean generate(WorldContext worldContext, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        if (this.altSpecies.isAcceptableSoilForWorldgen((IWorld)worldContext.level(), rootPos, worldContext.access().func_180495_p(rootPos))) {
            return this.altSpecies.generate(worldContext, rootPos, biome, random, radius, safeBounds);
        }
        return super.generate(worldContext, rootPos, biome, random, radius, safeBounds);
    }

    public boolean isAcceptableSoil(IWorldReader world, BlockPos pos, BlockState soilBlockState) {
        return super.isAcceptableSoil(world, pos, soilBlockState) || this.altSpecies.isAcceptableSoil(world, pos, soilBlockState);
    }

    protected boolean transitionToTree(World world, BlockPos pos, Family family) {
        if (this.altSpecies.isAcceptableSoil((IWorldReader)world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()))) {
            return this.altSpecies.transitionToTree(world, pos);
        }
        return super.transitionToTree(world, pos);
    }

    public Species generateSeed() {
        return !this.shouldGenerateSeed() || this.seed != null ? this : this.setSeed((Seed)RegistryHandler.addItem((ResourceLocation)this.getSeedName(), (Item)new Seed(this){

            public boolean func_234687_u_() {
                return true;
            }

            public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
                BlockRayTraceResult rayTraceResult = 1.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
                BlockRayTraceResult rayTraceResultUp = rayTraceResult.func_237485_a_(rayTraceResult.func_216350_a().func_177984_a());
                ActionResultType actionresulttype = super.func_195939_a(new ItemUseContext(player, hand, rayTraceResult.func_216354_b() == Direction.UP ? rayTraceResultUp : rayTraceResult));
                return new ActionResult(actionresulttype, (Object)player.func_184586_b(hand));
            }
        }));
    }

    public boolean plantSapling(IWorld world, BlockPos pos, boolean locationOverride) {
        FluidState fluidState = world.func_204610_c(pos);
        FluidState fluidStateUp = world.func_204610_c(pos.func_177984_a());
        DynamicSaplingBlock sapling = this.getSapling().orElse(null);
        if (sapling != null && fluidState.func_206886_c() == Fluids.field_204547_b && fluidStateUp.func_206886_c() == Fluids.field_204541_a) {
            return super.plantSapling(world, pos.func_177984_a(), locationOverride);
        }
        return super.plantSapling(world, pos, locationOverride);
    }
}

