/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.trees;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.branches.BasicBranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DiagonalPalmFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(DiagonalPalmFamily::new);

    public DiagonalPalmFamily(ResourceLocation name) {
        super(name);
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        BasicBranchBlock branch = new BasicBranchBlock(name, this.getProperties()){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public GrowSignal growIntoAir(World world, BlockPos pos, GrowSignal signal, int fromRadius) {
                Species species = signal.getSpecies();
                DynamicLeavesBlock leaves = species.getLeavesBlock().orElse(null);
                if (leaves != null) {
                    if (fromRadius != this.getFamily().getPrimaryThickness()) return leaves.branchOut(world, pos, signal);
                    if (1.isNextToBranch((World)world, (BlockPos)pos, (Direction)signal.dir.func_176734_d())) {
                        signal.success = false;
                        return signal;
                    }
                    signal.success = leaves.growLeavesIfLocationIsSuitable((IWorld)world, species.getLeavesProperties(), pos.func_177984_a(), 0);
                    if (!signal.success) return signal;
                    return leaves.branchOut(world, pos, signal);
                }
                if (1.isNextToBranch((World)world, (BlockPos)pos, (Direction)signal.dir.func_176734_d())) {
                    signal.success = false;
                    return signal;
                }
                this.setRadius((IWorld)world, pos, this.getFamily().getPrimaryThickness(), null);
                signal.radius = this.getFamily().getSecondaryThickness();
                signal.success = true;
                return signal;
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }
}

