/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.init;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.CellKit;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.api.registry.TypeRegistryEvent;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilHelper;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SpreadableSoilProperties;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.systems.BranchConnectables;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CommonVoxelShapes;
import com.google.common.collect.ImmutableList;
import corgiaoc.byg.common.properties.blocks.end.shattereddesert.OddityCactusBlock;
import corgiaoc.byg.common.properties.blocks.nether.warped.WarpedCactusBlock;
import corgiaoc.byg.common.world.feature.config.BYGMushroomConfig;
import corgiaoc.byg.common.world.feature.config.BYGTreeConfig;
import corgiaoc.byg.common.world.feature.config.GiantFlowerConfig;
import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.core.world.BYGBiomes;
import corgiaoc.byg.core.world.BYGConfiguredFeatures;
import corgiaoc.byg.core.world.util.WorldGenRegistrationHelper;
import java.util.List;
import java.util.Objects;
import maxhyper.dtbyg.DynamicTreesBYG;
import maxhyper.dtbyg.blocks.DynamicArisianBloomBranch;
import maxhyper.dtbyg.blocks.LavaSoilProperties;
import maxhyper.dtbyg.blocks.ScruffyLeavesProperties;
import maxhyper.dtbyg.cancellers.BYGFeatureCanceller;
import maxhyper.dtbyg.cancellers.CactusFeatureCanceller;
import maxhyper.dtbyg.cells.DTBYGCellKits;
import maxhyper.dtbyg.fruits.EtherBulbsFruit;
import maxhyper.dtbyg.genfeatures.DTBYGGenFeatures;
import maxhyper.dtbyg.growthlogic.DTBYGGrowthLogicKits;
import maxhyper.dtbyg.trees.DiagonalPalmFamily;
import maxhyper.dtbyg.trees.GenOnExtraSoilSpecies;
import maxhyper.dtbyg.trees.GenUnderwaterSpecies;
import maxhyper.dtbyg.trees.LamentSpecies;
import maxhyper.dtbyg.trees.MangroveSpecies;
import maxhyper.dtbyg.trees.NightshadeFamily;
import maxhyper.dtbyg.trees.PoplarSpecies;
import maxhyper.dtbyg.trees.SythianFungusFamily;
import maxhyper.dtbyg.trees.TwigletSpecies;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTBYGRegistries {
    public static Block ARISIAN_BLOOM_BRANCH;
    public static final VoxelShape MUSHROOM_STEM_LONG;
    public static final VoxelShape SYTHIAN_CAP_A;
    public static final VoxelShape SYTHIAN_CAP_B;
    public static final VoxelShape SYTHIAN_CAP_C;
    public static final VoxelShape SYTHIAN_MUSHROOM;
    public static final FeatureCanceller BYG_TREE_CANCELLER;
    public static final FeatureCanceller BYG_FUNGUS_CANCELLER;
    public static final FeatureCanceller GIANT_FLOWER_CANCELLER;
    public static final FeatureCanceller WARPED_CACTUS_CANCELLER;
    public static final FeatureCanceller ODDITY_CACTUS_CANCELLER;
    public static final ConfiguredFeature<?, ?> RANDOM_WARPED_DESERT_VEGETATION_NO_CACTI;
    public static final ConfiguredFeature<?, ?> RANDOM_ODDITY_PLANT_NO_CACTI;

    public static void setup() {
        CommonVoxelShapes.SHAPES.put(DynamicTreesBYG.resLoc("sythian").toString(), SYTHIAN_MUSHROOM);
    }

    public static void setupBlocks() {
        DTBYGRegistries.setUpSoils();
        DTBYGRegistries.setupConnectables();
    }

    private static void setUpSoils() {
        SoilProperties netherrackProperties = SoilHelper.getProperties((Block)Blocks.field_150424_aL);
        if (netherrackProperties instanceof SpreadableSoilProperties) {
            ((SpreadableSoilProperties)netherrackProperties).addSpreadableSoils(new Block[]{BYGBlocks.SYTHIAN_NYLIUM, BYGBlocks.OVERGROWN_NETHERRACK, BYGBlocks.MYCELIUM_NETHERRACK});
        }
    }

    private static void setupConnectables() {
        BranchConnectables.makeBlockConnectable((Block)BYGBlocks.POLLEN_BLOCK, (state, world, pos, side) -> {
            if (side == Direction.DOWN) {
                return 1;
            }
            return 0;
        });
        BranchConnectables.makeBlockConnectable((Block)BYGBlocks.PURPLE_SHROOMLIGHT, (state, world, pos, side) -> {
            if (side == Direction.DOWN) {
                BlockState branchState = world.func_180495_p(pos.func_177972_a(Direction.UP));
                BranchBlock branch = TreeHelper.getBranch((BlockState)branchState);
                if (branch != null) {
                    return MathHelper.func_76125_a((int)(branch.getRadius(branchState) - 1), (int)1, (int)8);
                }
                return 8;
            }
            return 0;
        });
        BranchConnectables.makeBlockConnectable((Block)ARISIAN_BLOOM_BRANCH, (state, world, pos, side) -> {
            if (state.func_235901_b_((Property)HorizontalBlock.field_185512_D)) {
                return state.func_177229_b((Property)HorizontalBlock.field_185512_D) == side ? 1 : 0;
            }
            return 0;
        });
    }

    @SubscribeEvent
    public static void onGenFeatureRegistry(RegistryEvent<GenFeature> event) {
        DTBYGGenFeatures.register((Registry<GenFeature>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onCellKitRegistry(RegistryEvent<CellKit> event) {
        DTBYGCellKits.register((Registry<CellKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onGrowthLogicKitRegistry(RegistryEvent<GrowthLogicKit> event) {
        DTBYGGrowthLogicKits.register((Registry<GrowthLogicKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerSpeciesTypes(TypeRegistryEvent<Species> event) {
        event.registerType(DynamicTreesBYG.resLoc("poplar"), PoplarSpecies.TYPE);
        event.registerType(DynamicTreesBYG.resLoc("twiglet"), TwigletSpecies.TYPE);
        event.registerType(DynamicTreesBYG.resLoc("generates_underwater"), GenUnderwaterSpecies.TYPE);
        event.registerType(DynamicTreesBYG.resLoc("generates_on_extra_soil"), GenOnExtraSoilSpecies.TYPE);
        event.registerType(DynamicTreesBYG.resLoc("mangrove"), MangroveSpecies.TYPE);
        event.registerType(DynamicTreesBYG.resLoc("lament"), LamentSpecies.TYPE);
    }

    @SubscribeEvent
    public static void registerFamilyTypes(TypeRegistryEvent<Family> event) {
        event.registerType(DynamicTreesBYG.resLoc("diagonal_palm"), DiagonalPalmFamily.TYPE);
        event.registerType(DynamicTreesBYG.resLoc("sythian_fungus"), SythianFungusFamily.TYPE);
        event.registerType(DynamicTreesBYG.resLoc("nightshade"), NightshadeFamily.TYPE);
    }

    @SubscribeEvent
    public static void registerLeavesPropertiesTypes(TypeRegistryEvent<LeavesProperties> event) {
        event.registerType(DynamicTreesBYG.resLoc("scruffy"), ScruffyLeavesProperties.TYPE);
    }

    @SubscribeEvent
    public static void registerSoilPropertiesTypes(TypeRegistryEvent<SoilProperties> event) {
        event.registerType(DynamicTreesBYG.resLoc("lava"), LavaSoilProperties.TYPE);
    }

    @SubscribeEvent
    public static void registerFruitTypes(TypeRegistryEvent<Fruit> event) {
        event.registerType(DynamicTreesBYG.resLoc("ether_bulbs"), EtherBulbsFruit.TYPE);
    }

    @SubscribeEvent
    public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
        ARISIAN_BLOOM_BRANCH = new DynamicArisianBloomBranch(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151678_z).func_200946_b().func_200947_a(SoundType.field_185850_c).func_226896_b_().func_200942_a().harvestTool(ToolType.HOE).func_235838_a_(state -> 10));
        ARISIAN_BLOOM_BRANCH.setRegistryName(DynamicTreesBYG.resLoc("arisian_bloom_branch"));
        event.getRegistry().register((IForgeRegistryEntry)ARISIAN_BLOOM_BRANCH);
        DTBYGRegistries.setupBlocks();
    }

    @SubscribeEvent
    public static void onFeatureCancellerRegistry(RegistryEvent<FeatureCanceller> event) {
        event.getRegistry().registerAll((RegistryEntry[])new FeatureCanceller[]{BYG_TREE_CANCELLER});
        event.getRegistry().registerAll((RegistryEntry[])new FeatureCanceller[]{BYG_FUNGUS_CANCELLER});
        event.getRegistry().registerAll((RegistryEntry[])new FeatureCanceller[]{GIANT_FLOWER_CANCELLER});
        event.getRegistry().registerAll((RegistryEntry[])new FeatureCanceller[]{WARPED_CACTUS_CANCELLER});
        event.getRegistry().registerAll((RegistryEntry[])new FeatureCanceller[]{ODDITY_CACTUS_CANCELLER});
    }

    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (Objects.equals(BYGBiomes.WARPED_DESERT.getRegistryName(), event.getName())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, RANDOM_WARPED_DESERT_VEGETATION_NO_CACTI);
        }
        if (Objects.equals(BYGBiomes.SHATTERED_DESERT.getRegistryName(), event.getName())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, RANDOM_ODDITY_PLANT_NO_CACTI);
        }
    }

    static {
        MUSHROOM_STEM_LONG = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0);
        SYTHIAN_CAP_A = Block.func_208617_a((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        SYTHIAN_CAP_B = Block.func_208617_a((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
        SYTHIAN_CAP_C = Block.func_208617_a((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
        SYTHIAN_MUSHROOM = VoxelShapes.func_216384_a((VoxelShape)MUSHROOM_STEM_LONG, (VoxelShape[])new VoxelShape[]{SYTHIAN_CAP_A, SYTHIAN_CAP_B, SYTHIAN_CAP_C});
        BYG_TREE_CANCELLER = new BYGFeatureCanceller<BYGTreeConfig>(DynamicTreesBYG.resLoc("tree"), BYGTreeConfig.class);
        BYG_FUNGUS_CANCELLER = new BYGFeatureCanceller<BYGMushroomConfig>(DynamicTreesBYG.resLoc("fungus"), BYGMushroomConfig.class);
        GIANT_FLOWER_CANCELLER = new BYGFeatureCanceller<GiantFlowerConfig>(DynamicTreesBYG.resLoc("giant_flower"), GiantFlowerConfig.class);
        WARPED_CACTUS_CANCELLER = new CactusFeatureCanceller<WarpedCactusBlock>(DynamicTreesBYG.resLoc("warped_cactus"), WarpedCactusBlock.class);
        ODDITY_CACTUS_CANCELLER = new CactusFeatureCanceller<OddityCactusBlock>(DynamicTreesBYG.resLoc("oddity_cactus"), OddityCactusBlock.class);
        RANDOM_WARPED_DESERT_VEGETATION_NO_CACTI = WorldGenRegistrationHelper.createConfiguredFeature((String)"warped_desert_plants_no_cacti", (ConfiguredFeature)Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)BYGConfiguredFeatures.WARPED_BUSH.func_227227_a_(0.25f), (Object)BYGConfiguredFeatures.WARPED_CORAL.func_227227_a_(0.25f), (Object)BYGConfiguredFeatures.WARPED_CORAL_FAN.func_227227_a_(0.25f)), Feature.field_227245_q_.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_))).func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(16))));
        RANDOM_ODDITY_PLANT_NO_CACTI = WorldGenRegistrationHelper.createConfiguredFeature((String)"oddity_plants_no_cacti", (ConfiguredFeature)Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_227245_q_.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227227_a_(0.5f)), BYGConfiguredFeatures.ODDITY_BUSH)).func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(16))));
    }
}

