/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.growthlogic;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import maxhyper.dtbyg.growthlogic.VariateHeightLogic;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class WillowLogic
extends VariateHeightLogic {
    public static final ConfigurationProperty<Integer> CANOPY_DEPTH = ConfigurationProperty.integer((String)"canopy_depth");

    public WillowLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CANOPY_DEPTH, (Object)4)).with(HEIGHT_VARIATION, (Object)8);
    }

    @Override
    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CANOPY_DEPTH, HEIGHT_VARIATION});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        Direction originDir = signal.dir.func_176734_d();
        probMap[Direction.DOWN.ordinal()] = 2;
        int lowestBranch = configuration.getLowestBranchHeight((PositionalSpeciesContext)context);
        if (signal.delta.func_177956_o() >= lowestBranch + (Integer)configuration.get(CANOPY_DEPTH)) {
            probMap[Direction.UP.ordinal()] = 0;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }
}

